/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildamolecule.control;

import edu.colorado.phet.buildamolecule.BuildAMoleculeStrings;
import edu.colorado.phet.buildamolecule.control.CollectionBoxNode;
import edu.colorado.phet.buildamolecule.control.GeneralLayoutNode;
import edu.colorado.phet.buildamolecule.control.MultipleCollectionBoxNode;
import edu.colorado.phet.buildamolecule.control.SingleCollectionBoxNode;
import edu.colorado.phet.buildamolecule.model.CollectionBox;
import edu.colorado.phet.buildamolecule.model.Kit;
import edu.colorado.phet.buildamolecule.model.KitCollection;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.piccolophet.nodes.HTMLImageButtonNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.PNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionAreaNode
extends GeneralLayoutNode {
    private List<CollectionBoxNode> collectionBoxNodes = new LinkedList<CollectionBoxNode>();

    public CollectionAreaNode(final KitCollection kitCollection, boolean bl, Function1<PNode, Rectangle2D> function1) {
        GeneralLayoutNode.CompositeLayoutMethod compositeLayoutMethod = new GeneralLayoutNode.CompositeLayoutMethod(new GeneralLayoutNode.VerticalLayoutMethod(), new GeneralLayoutNode.HorizontalAlignMethod(GeneralLayoutNode.HorizontalAlignMethod.Align.Centered));
        final double d = bl ? SingleCollectionBoxNode.getMaxWidth() : MultipleCollectionBoxNode.getMaxWidth();
        final double d2 = bl ? SingleCollectionBoxNode.getMaxHeight() : MultipleCollectionBoxNode.getMaxHeight();
        for (CollectionBox collectionBox : kitCollection.getCollectionBoxes()) {
            final CollectionBoxNode collectionBoxNode = bl ? new SingleCollectionBoxNode(collectionBox, function1) : new MultipleCollectionBoxNode(collectionBox, function1);
            this.collectionBoxNodes.add(collectionBoxNode);
            final VoidFunction0 voidFunction0 = new VoidFunction0(){

                public void apply() {
                    double d3 = (d - collectionBoxNode.getFullBounds().getWidth()) / 2.0;
                    double d22 = d2 - collectionBoxNode.getFullBounds().getHeight();
                    if (collectionBoxNode.getXOffset() != d3 || collectionBoxNode.getYOffset() != d22) {
                        collectionBoxNode.setOffset(d3, d22);
                    }
                }
            };
            voidFunction0.apply();
            collectionBoxNode.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    voidFunction0.apply();
                }
            });
            PNode pNode = new PNode(){
                {
                    this.addChild(new PhetPPath(new Rectangle2D.Double(0.0, 0.0, d, d2)){
                        {
                            this.setStroke(null);
                            this.setVisible(false);
                        }
                    });
                    this.addChild(collectionBoxNode);
                }
            };
            this.addChild(pNode, compositeLayoutMethod, 0.0, 0.0, 15.0, 0.0);
        }
        final HTMLImageButtonNode hTMLImageButtonNode = new HTMLImageButtonNode(BuildAMoleculeStrings.RESET_COLLECTION, Color.ORANGE){
            {
                super(string, color);
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        for (CollectionBox object : kitCollection.getCollectionBoxes()) {
                            object.clear();
                        }
                        for (Kit kit : kitCollection.getKits()) {
                            kit.resetKit();
                        }
                    }
                });
                for (CollectionBox collectionBox : kitCollection.getCollectionBoxes()) {
                    collectionBox.quantity.addObserver(new SimpleObserver(){

                        public void update() {
                            this.updateEnabled();
                        }
                    });
                }
            }

            public void updateEnabled() {
                boolean bl = false;
                for (CollectionBox collectionBox : kitCollection.getCollectionBoxes()) {
                    if (collectionBox.quantity.get() <= 0) continue;
                    bl = true;
                }
                this.setEnabled(bl);
            }
        };
        this.addChild(new PNode(){
            {
                this.addChild(new PhetPPath(hTMLImageButtonNode.getFullBounds()){
                    {
                        this.setStroke(new BasicStroke(2.0f));
                        this.setVisible(false);
                    }
                });
                this.addChild(hTMLImageButtonNode);
            }
        }, compositeLayoutMethod);
    }

    public void updateCollectionBoxLocations() {
        for (CollectionBoxNode collectionBoxNode : this.collectionBoxNodes) {
            collectionBoxNode.updateLocation();
        }
    }
}

