/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildamolecule.control;

import edu.colorado.phet.buildamolecule.BuildAMoleculeConstants;
import edu.colorado.phet.buildamolecule.BuildAMoleculeStrings;
import edu.colorado.phet.buildamolecule.control.CollectionAreaNode;
import edu.colorado.phet.buildamolecule.control.GeneralLayoutNode;
import edu.colorado.phet.buildamolecule.control.SoundOnOffNode;
import edu.colorado.phet.buildamolecule.model.CollectionBox;
import edu.colorado.phet.buildamolecule.model.CollectionList;
import edu.colorado.phet.buildamolecule.model.KitCollection;
import edu.colorado.phet.buildamolecule.model.LayoutBounds;
import edu.colorado.phet.buildamolecule.model.MoleculeList;
import edu.colorado.phet.common.phetcommon.model.property.ChangeObserver;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetRootPNode;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.common.piccolophet.nodes.NextPreviousNavigationNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionPanel
extends PNode {
    private GeneralLayoutNode layoutNode = new GeneralLayoutNode();
    private final PNode collectionAreaHolder = new PNode();
    private final PNode backgroundHolder = new PNode();
    private final Map<KitCollection, CollectionAreaNode> collectionAreaMap = new HashMap<KitCollection, CollectionAreaNode>();
    private VoidFunction1<SimpleObserver> addCollectionAttachmentListener;

    public CollectionPanel(final CollectionList collectionList, final boolean bl, VoidFunction1<SimpleObserver> voidFunction1, final Function1<PNode, Rectangle2D> function1) {
        this.addCollectionAttachmentListener = voidFunction1;
        GeneralLayoutNode.CompositeLayoutMethod compositeLayoutMethod = new GeneralLayoutNode.CompositeLayoutMethod(new GeneralLayoutNode.VerticalLayoutMethod(), new GeneralLayoutNode.HorizontalAlignMethod(GeneralLayoutNode.HorizontalAlignMethod.Align.Centered));
        this.layoutNode.translate(15.0, 15.0);
        this.layoutNode.addChild(new HTMLNode(BuildAMoleculeStrings.COLLECTION_AREA_YOUR_MOLECULE_COLLECTION){
            {
                this.setFont(new PhetFont(22));
            }
        }, compositeLayoutMethod, 0.0, 0.0, 5.0, 0.0);
        this.layoutNode.addChild(new NextPreviousNavigationNode(new PText(){
            {
                collectionList.currentCollection.addObserver(new SimpleObserver(){

                    public void update() {
                        this.setFont(new PhetFont(16, true));
                        this.setText(MessageFormat.format(BuildAMoleculeStrings.COLLECTION_LABEL, collectionList.getCurrentIndex() + 1));
                    }
                });
            }
        }, Color.YELLOW, Color.BLACK, 14.0, 18.0){
            {
                super(pNode, color, color2, d, d2);
                final SimpleObserver simpleObserver = new SimpleObserver(){

                    public void update() {
                        hasNext.set(collectionList.hasNextCollection());
                        hasPrevious.set(collectionList.hasPreviousCollection());
                    }
                };
                collectionList.currentCollection.addObserver(simpleObserver);
                collectionList.addListener(new CollectionList.Listener(){

                    public void addedCollection(KitCollection kitCollection) {
                        simpleObserver.update();
                    }

                    public void removedCollection(KitCollection kitCollection) {
                        simpleObserver.update();
                    }
                });
            }

            protected void next() {
                collectionList.switchToNextCollection();
            }

            protected void previous() {
                collectionList.switchToPreviousCollection();
            }
        }, compositeLayoutMethod, 0.0, 0.0, 10.0, 0.0);
        this.layoutNode.addChild(this.collectionAreaHolder, compositeLayoutMethod, 0.0, 0.0, 5.0, 0.0);
        this.layoutNode.addChild(new SoundOnOffNode(), compositeLayoutMethod);
        this.addChild(this.backgroundHolder);
        this.addChild(this.layoutNode);
        final VoidFunction1<KitCollection> voidFunction12 = new VoidFunction1<KitCollection>(){

            @Override
            public void apply(KitCollection kitCollection) {
                CollectionPanel.this.collectionAreaMap.put(kitCollection, new CollectionAreaNode(kitCollection, bl, function1));
            }
        };
        for (KitCollection kitCollection : collectionList.getCollections()) {
            voidFunction12.apply(kitCollection);
        }
        collectionList.addListener(new CollectionList.Adapter(){

            public void addedCollection(KitCollection kitCollection) {
                voidFunction12.apply(kitCollection);
            }
        });
        this.useCollection(collectionList.currentCollection.get());
        collectionList.currentCollection.addObserver(new ChangeObserver<KitCollection>(){

            @Override
            public void update(KitCollection kitCollection, KitCollection kitCollection2) {
                CollectionPanel.this.useCollection(kitCollection);
            }
        });
    }

    public void useCollection(KitCollection kitCollection) {
        this.collectionAreaHolder.removeAllChildren();
        final CollectionAreaNode collectionAreaNode = this.collectionAreaMap.get(kitCollection);
        this.collectionAreaHolder.addChild(collectionAreaNode);
        this.layoutNode.updateLayout();
        if (this.hasCanvasAsParent()) {
            collectionAreaNode.updateCollectionBoxLocations();
        } else {
            this.addCollectionAttachmentListener.apply(new SimpleObserver(){

                public void update() {
                    collectionAreaNode.updateCollectionBoxLocations();
                }
            });
        }
        this.backgroundHolder.removeAllChildren();
        PPath pPath = PPath.createRectangle(0.0f, 0.0f, (float)this.getPlacementWidth(), (float)this.getPlacementHeight());
        pPath.setPaint(BuildAMoleculeConstants.MOLECULE_COLLECTION_BACKGROUND);
        pPath.setStrokePaint(BuildAMoleculeConstants.MOLECULE_COLLECTION_BORDER);
        this.backgroundHolder.addChild(pPath);
    }

    private boolean hasCanvasAsParent() {
        PNode pNode = this;
        while (pNode.getParent() != null) {
            if (!((pNode = pNode.getParent()) instanceof PhetRootPNode)) continue;
            return true;
        }
        return false;
    }

    public static double getCollectionPanelModelWidth(boolean bl) {
        CollectionPanel collectionPanel = new CollectionPanel(new CollectionList(new KitCollection(){
            {
                this.addCollectionBox(new CollectionBox(MoleculeList.H2O, 1));
            }
        }, new LayoutBounds(false, 0.0)), bl, new VoidFunction1<SimpleObserver>(){

            @Override
            public void apply(SimpleObserver simpleObserver) {
            }
        }, new Function1<PNode, Rectangle2D>(){

            @Override
            public Rectangle2D apply(PNode pNode) {
                return null;
            }
        });
        double d = BuildAMoleculeConstants.MODEL_VIEW_TRANSFORM.viewToModelDeltaX(collectionPanel.getFullBounds().getWidth());
        return d;
    }

    private double getPlacementWidth() {
        return this.layoutNode.getFullBounds().getWidth() + 30.0;
    }

    private double getPlacementHeight() {
        double d;
        double d2 = this.layoutNode.getLayoutBounds().getHeight() + 30.0;
        if (d2 > (d = BuildAMoleculeConstants.STAGE_SIZE.getHeight() - 36.0)) {
            System.out.println("Warning: collection panel is too tall. required: " + d2 + ", but has: " + d);
        }
        return d;
    }
}

