/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildamolecule.control;

import edu.colorado.phet.buildamolecule.BuildAMoleculeConstants;
import edu.colorado.phet.buildamolecule.BuildAMoleculeStrings;
import edu.colorado.phet.buildamolecule.model.Kit;
import edu.colorado.phet.buildamolecule.model.KitCollection;
import edu.colorado.phet.buildamolecule.model.Molecule;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.HTMLImageButtonNode;
import edu.colorado.phet.common.piccolophet.nodes.NextPreviousNavigationNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.text.MessageFormat;

public class KitPanel
extends PNode {
    public KitPanel(final KitCollection kitCollection, PBounds pBounds) {
        assert (BuildAMoleculeConstants.MODEL_VIEW_TRANSFORM.getTransform().getScaleY() < 0.0);
        final Rectangle2D rectangle2D = BuildAMoleculeConstants.MODEL_VIEW_TRANSFORM.modelToViewRectangle(pBounds);
        PPath pPath = PPath.createRectangle((float)rectangle2D.getX(), (float)rectangle2D.getY(), (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight());
        pPath.setPaint(BuildAMoleculeConstants.KIT_BACKGROUND);
        pPath.setStrokePaint(BuildAMoleculeConstants.KIT_BORDER);
        this.addChild(pPath);
        this.addChild(new NextPreviousNavigationNode(new PText(){
            {
                this.setFont(new PhetFont(18, true));
                kitCollection.getCurrentKitProperty().addObserver(new SimpleObserver(){

                    public void update() {
                        this.setText(MessageFormat.format(BuildAMoleculeStrings.KIT_LABEL, kitCollection.getCurrentKitIndex() + 1));
                    }
                });
            }
        }, BuildAMoleculeConstants.KIT_ARROW_BACKGROUND_ENABLED, BuildAMoleculeConstants.KIT_ARROW_BORDER_ENABLED, 17.0, 24.0){
            {
                super(pNode, color, color2, d, d2);
                kitCollection.getCurrentKitProperty().addObserver(new SimpleObserver(){

                    public void update() {
                        hasNext.set(kitCollection.hasNextKit());
                        hasPrevious.set(kitCollection.hasPreviousKit());
                    }
                });
                this.setOffset(rectangle2D.getMaxX() - this.getFullBounds().getWidth() - 5.0, rectangle2D.getY() + 5.0);
            }

            protected void next() {
                kitCollection.goToNextKit();
            }

            protected void previous() {
                kitCollection.goToPreviousKit();
            }
        });
        this.addChild(new HTMLImageButtonNode(BuildAMoleculeStrings.KIT_REFILL, new PhetFont(1, 12), Color.ORANGE){
            private SimpleObserver observer;
            {
                super(string, phetFont, color);
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        kitCollection.getCurrentKit().resetKit();
                    }
                });
                this.observer = new SimpleObserver(){

                    public void update() {
                        this.setEnabled(kitCollection.getCurrentKit().hasAtomsOutsideOfBuckets());
                    }
                };
                for (Kit kit : kitCollection.getKits()) {
                    kit.addMoleculeListener(new Kit.MoleculeListener(){

                        public void addedMolecule(Molecule molecule) {
                            observer.update();
                        }

                        public void removedMolecule(Molecule molecule) {
                            observer.update();
                        }
                    });
                }
                kitCollection.getCurrentKitProperty().addObserver(this.observer);
                this.setOffset(rectangle2D.getMinX() + 5.0, rectangle2D.getMinY() + 5.0);
            }
        });
    }
}

