/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildamolecule.model;

import edu.colorado.phet.buildamolecule.BuildAMoleculeStrings;
import edu.colorado.phet.buildamolecule.model.Atom2D;
import edu.colorado.phet.chemistry.model.Element;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.SphereBucket;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bucket
extends SphereBucket<Atom2D> {
    private final Element element;

    public Bucket(IClock iClock, Element element, int n) {
        this(new PDimension(Bucket.calculateIdealBucketWidth(element.getRadius(), n), 200.0), iClock, element, n);
    }

    public Bucket(Dimension2D dimension2D, IClock iClock, Element element, int n) {
        super(new Point2D.Double(), dimension2D, element.getColor(), BuildAMoleculeStrings.getAtomName(element), element.getRadius());
        this.element = element;
        for (int i = 0; i < n; ++i) {
            super.addParticleFirstOpen(new Atom2D(element, iClock), true);
        }
    }

    public static int calculateIdealBucketWidth(double d, int n) {
        int n2 = n <= 2 ? n : n / 2 + 1;
        double d2 = 2.0 * d * (double)(n2 + 1);
        return (int)Math.max(350.0, d2 + 1.0);
    }

    @Override
    public void setPosition(Point2D point2D) {
        Vector2D vector2D = new Vector2D(point2D).minus(new Vector2D(this.getPosition()));
        for (Atom2D atom2D : this.getAtoms()) {
            atom2D.setPositionAndDestination(atom2D.getPosition().plus(vector2D));
        }
        super.setPosition(point2D);
    }

    public List<Atom2D> getAtoms() {
        return this.getParticleList();
    }

    public void placeAtom(Atom2D atom2D) {
        if (this.containsParticle(atom2D)) {
            this.removeParticle(atom2D);
        }
        super.addParticleFirstOpen(atom2D, true);
    }

    public double getWidth() {
        return this.getContainerShape().getBounds().getWidth();
    }

    public Element getElement() {
        return this.element;
    }
}

