/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildamolecule.model;

import edu.colorado.phet.buildamolecule.model.KitCollection;
import edu.colorado.phet.buildamolecule.model.LayoutBounds;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.umd.cs.piccolo.util.PBounds;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionList {
    private final List<KitCollection> collections;
    private int currentIndex = 0;
    public final Property<KitCollection> currentCollection;
    private final List<Listener> listeners = new LinkedList<Listener>();
    private LayoutBounds layoutBounds;

    public CollectionList(KitCollection kitCollection, LayoutBounds layoutBounds) {
        this.layoutBounds = layoutBounds;
        this.collections = new LinkedList<KitCollection>();
        this.currentCollection = new Property<KitCollection>(kitCollection);
        this.addCollection(kitCollection);
    }

    private void switchTo(KitCollection kitCollection) {
        this.currentIndex = this.collections.indexOf(kitCollection);
        this.currentCollection.set(kitCollection);
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public void addCollection(KitCollection kitCollection) {
        this.collections.add(kitCollection);
        for (Listener listener : new ArrayList<Listener>(this.listeners)) {
            listener.addedCollection(kitCollection);
        }
        this.currentIndex = this.collections.indexOf(kitCollection);
        this.currentCollection.set(kitCollection);
    }

    public void removeCollection(KitCollection kitCollection) {
        assert (this.currentCollection.get() != kitCollection);
        this.collections.remove(kitCollection);
        for (Listener listener : new ArrayList<Listener>(this.listeners)) {
            listener.removedCollection(kitCollection);
        }
    }

    public void reset() {
        this.switchTo(this.collections.get(0));
        this.collections.get(0).resetAll();
        for (KitCollection kitCollection : new ArrayList<KitCollection>(this.collections)) {
            if (this.currentCollection.get() == kitCollection) continue;
            this.removeCollection(kitCollection);
        }
    }

    public PBounds getAvailableKitBounds() {
        return this.layoutBounds.getAvailableKitBounds();
    }

    public PBounds getAvailablePlayAreaBounds() {
        return this.layoutBounds.getAvailablePlayAreaBounds();
    }

    public boolean hasPreviousCollection() {
        return this.currentIndex > 0;
    }

    public boolean hasNextCollection() {
        return this.currentIndex < this.collections.size() - 1;
    }

    public void switchToPreviousCollection() {
        this.switchTo(this.collections.get(this.currentIndex - 1));
    }

    public void switchToNextCollection() {
        this.switchTo(this.collections.get(this.currentIndex + 1));
    }

    public List<KitCollection> getCollections() {
        return new ArrayList<KitCollection>(this.collections);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public static class Adapter
    implements Listener {
        public void addedCollection(KitCollection kitCollection) {
        }

        public void removedCollection(KitCollection kitCollection) {
        }
    }

    public static interface Listener {
        public void addedCollection(KitCollection var1);

        public void removedCollection(KitCollection var1);
    }
}

