/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildamolecule.model;

import edu.colorado.phet.buildamolecule.BuildAMoleculeConstants;
import edu.colorado.phet.buildamolecule.model.MoleculeStructure;
import edu.colorado.phet.chemistry.model.Atom;
import edu.colorado.phet.chemistry.model.Element;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementHistogram {
    public static Set<String> ALLOWED_CHEMICAL_SYMBOLS = new HashSet<String>(){
        {
            for (Element element : BuildAMoleculeConstants.SUPPORTED_ELEMENTS) {
                this.add(element.getSymbol());
            }
        }
    };
    public final Map<String, Integer> quantities = new HashMap<String, Integer>(){
        {
            for (String string : ALLOWED_CHEMICAL_SYMBOLS) {
                this.put(string, 0);
            }
        }
    };

    public ElementHistogram() {
    }

    public ElementHistogram(MoleculeStructure<? extends Atom> moleculeStructure) {
        this.add(moleculeStructure);
    }

    public int getQuantity(Element element) {
        return this.quantities.get(element.getSymbol());
    }

    public void add(Element element) {
        this.quantities.put(element.getSymbol(), this.quantities.get(element.getSymbol()) + 1);
    }

    public <T extends Atom> void add(MoleculeStructure<T> moleculeStructure) {
        for (Atom atom : moleculeStructure.getAtoms()) {
            this.add(atom.getElement());
        }
    }

    public String getHashString() {
        String string = "";
        for (String string2 : ALLOWED_CHEMICAL_SYMBOLS) {
            string = string + this.quantities.get(string2);
        }
        return string;
    }

    public int hashCode() {
        return this.getHashString().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof ElementHistogram) {
            ElementHistogram elementHistogram = (ElementHistogram)object;
            for (String string : ALLOWED_CHEMICAL_SYMBOLS) {
                if (this.quantities.get(string).equals(elementHistogram.quantities.get(string))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

