/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildamolecule.model;

import edu.colorado.phet.buildamolecule.model.Atom2D;
import edu.colorado.phet.buildamolecule.model.CollectionBox;
import edu.colorado.phet.buildamolecule.model.Kit;
import edu.colorado.phet.buildamolecule.model.Molecule;
import edu.colorado.phet.common.phetcommon.model.property.ChangeObserver;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KitCollection {
    private List<Kit> kits = new LinkedList<Kit>();
    private List<CollectionBox> boxes = new LinkedList<CollectionBox>();
    private Property<Kit> currentKit;
    public final Property<Boolean> allCollectionBoxesFilled = new Property<Boolean>(false);

    public void addKit(final Kit kit) {
        if (this.currentKit == null) {
            this.currentKit = new Property<Kit>(kit);
            kit.show();
            this.currentKit.addObserver(new ChangeObserver<Kit>(){

                @Override
                public void update(Kit kit, Kit kit2) {
                    kit.show();
                    kit2.hide();
                }
            });
        } else {
            kit.hide();
        }
        this.kits.add(kit);
        for (Atom2D atom2D : kit.getAtoms()) {
            atom2D.addListener(new Atom2D.Adapter(){

                public void droppedByUser(Atom2D atom2D) {
                    boolean bl = false;
                    if (kit.isAtomInPlay(atom2D)) {
                        Molecule molecule = kit.getMolecule(atom2D);
                        for (CollectionBox collectionBox : KitCollection.this.boxes) {
                            if (!collectionBox.getDropBounds().intersects(molecule.getPositionBounds()) || !collectionBox.willAllowMoleculeDrop(molecule)) continue;
                            kit.moleculePutInCollectionBox(molecule, collectionBox);
                            bl = true;
                            break;
                        }
                    }
                    if (!bl) {
                        kit.atomDropped(atom2D);
                    }
                }
            });
        }
        kit.addMoleculeListener(new Kit.MoleculeAdapter(){

            public void addedMolecule(Molecule molecule) {
                for (CollectionBox collectionBox : KitCollection.this.getCollectionBoxes()) {
                    if (!collectionBox.willAllowMoleculeDrop(molecule)) continue;
                    collectionBox.onAcceptedMoleculeCreation(molecule);
                }
            }
        });
    }

    public CollectionBox getFirstTargetBox(Molecule molecule) {
        for (CollectionBox collectionBox : this.boxes) {
            if (!collectionBox.willAllowMoleculeDrop(molecule)) continue;
            return collectionBox;
        }
        return null;
    }

    public void addCollectionBox(CollectionBox collectionBox) {
        this.boxes.add(collectionBox);
        collectionBox.quantity.addObserver(new SimpleObserver(){

            public void update() {
                boolean bl = true;
                for (CollectionBox collectionBox : KitCollection.this.boxes) {
                    if (collectionBox.isFull()) continue;
                    bl = false;
                }
                KitCollection.this.allCollectionBoxesFilled.set(!KitCollection.this.boxes.isEmpty() && bl);
            }
        });
    }

    public List<Kit> getKits() {
        return this.kits;
    }

    public List<CollectionBox> getCollectionBoxes() {
        return this.boxes;
    }

    public Kit getCurrentKit() {
        return this.currentKit.get();
    }

    public Property<Kit> getCurrentKitProperty() {
        return this.currentKit;
    }

    public int getCurrentKitIndex() {
        int n = this.kits.indexOf(this.currentKit.get());
        if (n < 0) {
            throw new RuntimeException("Could not find current kit index");
        }
        return n;
    }

    public boolean hasNextKit() {
        return this.getCurrentKitIndex() + 1 < this.kits.size();
    }

    public boolean hasPreviousKit() {
        return this.getCurrentKitIndex() - 1 >= 0;
    }

    public void goToNextKit() {
        if (this.hasNextKit()) {
            this.currentKit.set(this.kits.get(this.getCurrentKitIndex() + 1));
        }
    }

    public void goToPreviousKit() {
        if (this.hasPreviousKit()) {
            this.currentKit.set(this.kits.get(this.getCurrentKitIndex() - 1));
        }
    }

    public void resetAll() {
        for (CollectionBox object : this.boxes) {
            object.clear();
        }
        for (Kit kit : this.kits) {
            kit.resetKit();
        }
        while (this.hasPreviousKit()) {
            this.goToPreviousKit();
        }
    }
}

