/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildamolecule.model;

import edu.colorado.phet.chemistry.model.Atom;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.util.Option;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LewisDotModel {
    private Map<Atom, LewisDotAtom> atomMap = new HashMap<Atom, LewisDotAtom>();

    public void addAtom(Atom atom) {
        LewisDotAtom lewisDotAtom = new LewisDotAtom(atom);
        this.atomMap.put(atom, lewisDotAtom);
    }

    public void breakBondsOfAtom(Atom atom) {
        LewisDotAtom lewisDotAtom = this.getLewisDotAtom(atom);
        for (Direction direction : Direction.values()) {
            if (!lewisDotAtom.hasConnection(direction)) continue;
            LewisDotAtom lewisDotAtom2 = lewisDotAtom.getLewisDotAtom(direction);
            this.breakBond(lewisDotAtom.getAtom(), lewisDotAtom2.getAtom());
        }
    }

    public void breakBond(Atom atom, Atom atom2) {
        LewisDotAtom lewisDotAtom = this.getLewisDotAtom(atom);
        LewisDotAtom lewisDotAtom2 = this.getLewisDotAtom(atom2);
        Direction direction = this.getBondDirection(atom, atom2);
        lewisDotAtom.disconnect(direction);
        lewisDotAtom2.disconnect(Direction.opposite(direction));
    }

    public void bond(Atom atom, Direction direction, Atom atom2) {
        LewisDotAtom lewisDotAtom = this.getLewisDotAtom(atom);
        LewisDotAtom lewisDotAtom2 = this.getLewisDotAtom(atom2);
        lewisDotAtom.connect(direction, lewisDotAtom2);
        lewisDotAtom2.connect(Direction.opposite(direction), lewisDotAtom);
    }

    public List<Direction> getOpenDirections(Atom atom) {
        LinkedList<Direction> linkedList = new LinkedList<Direction>();
        LewisDotAtom lewisDotAtom = this.getLewisDotAtom(atom);
        for (Direction direction : Direction.values()) {
            if (lewisDotAtom.hasConnection(direction)) continue;
            linkedList.add(direction);
        }
        return linkedList;
    }

    public Direction getBondDirection(Atom atom, Atom atom2) {
        LewisDotAtom lewisDotAtom = this.getLewisDotAtom(atom);
        for (Direction direction : Direction.values()) {
            if (!lewisDotAtom.hasConnection(direction) || lewisDotAtom.getLewisDotAtom(direction).atom != atom2) continue;
            return direction;
        }
        throw new RuntimeException("Bond not found");
    }

    public boolean willAllowBond(Atom atom, Direction direction, Atom atom2) {
        HashMap<Point2D, Atom> hashMap = new HashMap<Point2D, Atom>();
        boolean bl = this.mapMolecule(new Vector2D(), atom, null, hashMap);
        bl = bl && this.mapMolecule(direction.getVector(), atom2, null, hashMap);
        return bl;
    }

    private boolean mapMolecule(Vector2D vector2D, Atom atom, Atom atom2, Map<Point2D, Atom> map) {
        LewisDotAtom lewisDotAtom = this.getLewisDotAtom(atom);
        Point2D.Double double_ = new Point2D.Double(Math.round(vector2D.getX()), Math.round(vector2D.getY()));
        if (map.containsKey(double_)) {
            if (!atom.isHydrogen() || !map.get(double_).isHydrogen()) {
                return false;
            }
        } else {
            map.put(double_, atom);
        }
        boolean bl = true;
        for (Direction direction : Direction.values()) {
            LewisDotAtom lewisDotAtom2;
            if (!lewisDotAtom.hasConnection(direction) || (lewisDotAtom2 = lewisDotAtom.getLewisDotAtom(direction)).atom == atom2 || (bl = this.mapMolecule(vector2D.plus(direction.getVector()), lewisDotAtom2.atom, atom, map))) continue;
            return false;
        }
        return bl;
    }

    private LewisDotAtom getLewisDotAtom(Atom atom) {
        return this.atomMap.get(atom);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Direction
    extends Enum<Direction> {
        public static final /* enum */ Direction North = new Direction(new Vector2D(0.0, 1.0));
        public static final /* enum */ Direction East = new Direction(new Vector2D(1.0, 0.0));
        public static final /* enum */ Direction South = new Direction(new Vector2D(0.0, -1.0));
        public static final /* enum */ Direction West = new Direction(new Vector2D(-1.0, 0.0));
        private Vector2D vector;
        private static final /* synthetic */ Direction[] $VALUES;

        public static Direction[] values() {
            return (Direction[])$VALUES.clone();
        }

        private Direction(Vector2D vector2D) {
            this.vector = vector2D;
        }

        public Vector2D getVector() {
            return this.vector;
        }

        public static Direction opposite(Direction direction) {
            switch (direction) {
                case North: {
                    return South;
                }
                case East: {
                    return West;
                }
                case South: {
                    return North;
                }
                case West: {
                    return East;
                }
            }
            throw new RuntimeException("Could not find opposite direction");
        }

        static {
            $VALUES = new Direction[]{North, East, South, West};
        }
    }

    private static class LewisDotAtom {
        private Atom atom;
        private Map<Direction, Option<LewisDotAtom>> connections = new HashMap<Direction, Option<LewisDotAtom>>();

        public LewisDotAtom(Atom atom) {
            this.atom = atom;
            for (Direction direction : Direction.values()) {
                this.connections.put(direction, new Option.None());
            }
        }

        public boolean hasConnection(Direction direction) {
            return this.connections.get((Object)direction).isSome();
        }

        public LewisDotAtom getLewisDotAtom(Direction direction) {
            return this.connections.get((Object)direction).get();
        }

        public void connect(Direction direction, LewisDotAtom lewisDotAtom) {
            this.connections.put(direction, new Option.Some<LewisDotAtom>(lewisDotAtom));
        }

        public void disconnect(Direction direction) {
            this.connections.put(direction, new Option.None());
        }

        public Atom getAtom() {
            return this.atom;
        }
    }
}

