/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildamolecule.model;

import edu.colorado.phet.buildamolecule.BuildAMoleculeResources;
import edu.colorado.phet.buildamolecule.model.CompleteMolecule;
import edu.colorado.phet.buildamolecule.model.MoleculeStructure;
import edu.colorado.phet.buildamolecule.model.StrippedMolecule;
import edu.colorado.phet.chemistry.model.Atom;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoleculeList {
    private List<CompleteMolecule> completeMolecules = new ArrayList<CompleteMolecule>();
    private Map<String, CompleteMolecule> moleculeNameMap = new HashMap<String, CompleteMolecule>();
    private Map<String, List<StrippedMolecule<Atom>>> allowedStructureFormulaMap = new HashMap<String, List<StrippedMolecule<Atom>>>();
    private static volatile MoleculeList masterInstance = null;
    private static volatile boolean initialized = false;
    private static Thread computeThread = null;
    public static Random random = new Random(System.currentTimeMillis());
    private static final MoleculeList initialList = new MoleculeList(){
        {
            this.loadInitialData();
        }
    };
    public static final CompleteMolecule CO2 = MoleculeList.getMoleculeByName("Carbon Dioxide");
    public static final CompleteMolecule H2O = MoleculeList.getMoleculeByName("Water");
    public static final CompleteMolecule N2 = MoleculeList.getMoleculeByName("Nitrogen");
    public static final CompleteMolecule CO = MoleculeList.getMoleculeByName("Carbon Monoxide");
    public static final CompleteMolecule NO = MoleculeList.getMoleculeByName("Nitric Oxide");
    public static final CompleteMolecule O2 = MoleculeList.getMoleculeByName("Oxygen");
    public static final CompleteMolecule H2 = MoleculeList.getMoleculeByName("Hydrogen");
    public static final CompleteMolecule Cl2 = MoleculeList.getMoleculeByName("Chlorine");
    public static final CompleteMolecule NH3 = MoleculeList.getMoleculeByName("Ammonia");
    public static final CompleteMolecule[] COLLECTION_BOX_MOLECULES;

    public static synchronized void startInitialization() {
        final long l = System.currentTimeMillis();
        computeThread = new Thread(){

            public void run() {
                masterInstance = new MoleculeList(){
                    {
                        this.loadMasterData();
                    }
                };
                initialized = true;
                long l2 = System.currentTimeMillis();
                System.out.println("completed MoleculeList initialization in " + (l2 - l) + "ms");
            }
        };
        System.out.println("starting MoleculeList initialization");
        computeThread.start();
    }

    public static synchronized MoleculeList getMasterInstance() {
        if (!initialized) {
            if (computeThread == null) {
                MoleculeList.startInitialization();
            }
            try {
                computeThread.join();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("interrupted", interruptedException);
            }
        }
        return masterInstance;
    }

    public static void testLoadingForProfiling() {
        new MoleculeList(){
            {
                this.loadMasterData();
            }
        };
    }

    public static synchronized CompleteMolecule getMoleculeByName(String string) {
        CompleteMolecule completeMolecule = MoleculeList.initialList.moleculeNameMap.get(string);
        if (completeMolecule == null) {
            System.out.println("WARNING: looking up " + string + " in master instance.");
            completeMolecule = MoleculeList.getMasterInstance().moleculeNameMap.get(string);
        }
        return completeMolecule;
    }

    protected void loadInitialData() {
        List<CompleteMolecule> list = MoleculeList.readCompleteMoleculesFromFilename("collection-molecules.txt");
        for (CompleteMolecule completeMolecule : list) {
            this.addCompleteMolecule(completeMolecule);
        }
    }

    protected void loadMasterData() {
        for (CompleteMolecule list2 : initialList.getAllCompleteMolecules()) {
            this.addCompleteMolecule(list2);
        }
        List<CompleteMolecule> list3 = MoleculeList.readCompleteMoleculesFromFilename("other-molecules.txt");
        Iterator iterator = list3.iterator();
        while (iterator.hasNext()) {
            Object object = (CompleteMolecule)iterator.next();
            CompleteMolecule completeMolecule = MoleculeList.initialList.moleculeNameMap.get(((CompleteMolecule)object).getCommonName());
            if (completeMolecule != null && ((MoleculeStructure)object).isEquivalent(completeMolecule)) {
                object = completeMolecule;
            }
            this.addCompleteMolecule((CompleteMolecule)object);
        }
        List<MoleculeStructure<Atom>> list = MoleculeList.readMoleculeStructuresFromFilename("structures.txt");
        for (MoleculeStructure moleculeStructure : list) {
            this.addAllowedStructure(moleculeStructure);
        }
    }

    public <AtomT extends Atom> boolean isAllowedStructure(MoleculeStructure<AtomT> moleculeStructure) {
        List<StrippedMolecule<Atom>> list;
        StrippedMolecule<AtomT> strippedMolecule = new StrippedMolecule<AtomT>(moleculeStructure);
        String string = strippedMolecule.stripped.getHistogram().getHashString();
        if (strippedMolecule.stripped.getAtoms().isEmpty() && moleculeStructure.getAtoms().size() <= 2) {
            return true;
        }
        if (!moleculeStructure.isValid()) {
            return false;
        }
        if (this.allowedStructureFormulaMap.containsKey(string) && (list = this.allowedStructureFormulaMap.get(string)) != null) {
            for (StrippedMolecule<Atom> strippedMolecule2 : list) {
                if (!strippedMolecule2.isHydrogenSubmolecule(strippedMolecule)) continue;
                return true;
            }
        }
        return false;
    }

    public <AtomT extends Atom> CompleteMolecule findMatchingCompleteMolecule(MoleculeStructure<AtomT> moleculeStructure) {
        for (CompleteMolecule completeMolecule : this.completeMolecules) {
            if (!moleculeStructure.isEquivalent(completeMolecule)) continue;
            return completeMolecule;
        }
        return null;
    }

    public List<CompleteMolecule> getAllCompleteMolecules() {
        return new LinkedList<CompleteMolecule>(this.completeMolecules);
    }

    private void addCompleteMolecule(CompleteMolecule completeMolecule) {
        this.completeMolecules.add(completeMolecule);
        this.moleculeNameMap.put(completeMolecule.getCommonName(), completeMolecule);
    }

    private void addAllowedStructure(MoleculeStructure<Atom> moleculeStructure) {
        final StrippedMolecule<Atom> strippedMolecule = new StrippedMolecule<Atom>(moleculeStructure);
        String string = strippedMolecule.stripped.getHistogram().getHashString();
        if (this.allowedStructureFormulaMap.containsKey(string)) {
            this.allowedStructureFormulaMap.get(string).add(strippedMolecule);
        } else {
            this.allowedStructureFormulaMap.put(string, (List<StrippedMolecule<Atom>>)new LinkedList<StrippedMolecule<Atom>>(){
                {
                    this.add(strippedMolecule);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CompleteMolecule> readCompleteMoleculesFromFilename(String string) {
        ArrayList<CompleteMolecule> arrayList = new ArrayList<CompleteMolecule>();
        try {
            long l = System.currentTimeMillis();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(BuildAMoleculeResources.getResourceLoader().getResourceAsStream(string)));
            try {
                while (bufferedReader.ready()) {
                    String string2 = bufferedReader.readLine();
                    CompleteMolecule completeMolecule = CompleteMolecule.fromSerial2(string2);
                    if (completeMolecule.hasLoopsOrIsDisconnected()) {
                        System.out.println("ignoring molecule: " + completeMolecule.getCommonName());
                        continue;
                    }
                    if (completeMolecule.hasWeirdHydrogenProperties()) {
                        System.out.println("weird hydrogen pattern in: " + completeMolecule.getCommonName());
                        continue;
                    }
                    arrayList.add(completeMolecule);
                }
            }
            finally {
                bufferedReader.close();
            }
            long l2 = System.currentTimeMillis();
            System.out.println(string + " read in: " + (l2 - l) + "ms");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<MoleculeStructure<Atom>> readMoleculeStructuresFromFilename(String string) {
        ArrayList<MoleculeStructure<Atom>> arrayList = new ArrayList<MoleculeStructure<Atom>>();
        try {
            long l = System.currentTimeMillis();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(BuildAMoleculeResources.getResourceLoader().getResourceAsStream("structures.txt")));
            try {
                while (bufferedReader.ready()) {
                    String string2 = bufferedReader.readLine();
                    MoleculeStructure<Atom> moleculeStructure = MoleculeStructure.fromSerial2Basic(string2);
                    if (moleculeStructure.hasWeirdHydrogenProperties()) {
                        System.out.println("weird hydrogen pattern in structure: " + string2);
                        continue;
                    }
                    arrayList.add(moleculeStructure);
                }
            }
            finally {
                bufferedReader.close();
            }
            long l2 = System.currentTimeMillis();
            System.out.println(string + " read in: " + (l2 - l) + "ms");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return arrayList;
    }

    static {
        for (CompleteMolecule completeMolecule : COLLECTION_BOX_MOLECULES = new CompleteMolecule[]{CO2, H2O, N2, CO, O2, H2, NH3, Cl2, NO, MoleculeList.getMoleculeByName("Acetylene"), MoleculeList.getMoleculeByName("Borane"), MoleculeList.getMoleculeByName("Trifluoroborane"), MoleculeList.getMoleculeByName("Chloromethane"), MoleculeList.getMoleculeByName("Ethylene"), MoleculeList.getMoleculeByName("Fluorine"), MoleculeList.getMoleculeByName("Fluoromethane"), MoleculeList.getMoleculeByName("Formaldehyde"), MoleculeList.getMoleculeByName("Hydrogen Cyanide"), MoleculeList.getMoleculeByName("Hydrogen Peroxide"), MoleculeList.getMoleculeByName("Hydrogen Sulfide"), MoleculeList.getMoleculeByName("Methane"), MoleculeList.getMoleculeByName("Nitrous Oxide"), MoleculeList.getMoleculeByName("Ozone"), MoleculeList.getMoleculeByName("Phosphine"), MoleculeList.getMoleculeByName("Silane"), MoleculeList.getMoleculeByName("Sulfur Dioxide")}) {
            assert (completeMolecule != null);
        }
    }
}

