/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildamolecule.module;

import edu.colorado.phet.buildamolecule.BuildAMoleculeStrings;
import edu.colorado.phet.buildamolecule.control.CollectionPanel;
import edu.colorado.phet.buildamolecule.model.Bucket;
import edu.colorado.phet.buildamolecule.model.CollectionBox;
import edu.colorado.phet.buildamolecule.model.CollectionList;
import edu.colorado.phet.buildamolecule.model.Kit;
import edu.colorado.phet.buildamolecule.model.KitCollection;
import edu.colorado.phet.buildamolecule.model.LayoutBounds;
import edu.colorado.phet.buildamolecule.model.MoleculeList;
import edu.colorado.phet.buildamolecule.module.AbstractBuildAMoleculeModule;
import edu.colorado.phet.buildamolecule.view.BuildAMoleculeCanvas;
import edu.colorado.phet.buildamolecule.view.MoleculeCollectingCanvas;
import edu.colorado.phet.chemistry.model.Element;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Frame;

public class CollectMultipleModule
extends AbstractBuildAMoleculeModule {
    public CollectMultipleModule(Frame frame) {
        super(frame, BuildAMoleculeStrings.TITLE_COLLECT_MULTIPLE, new LayoutBounds(false, CollectionPanel.getCollectionPanelModelWidth(false)));
        KitCollection kitCollection = new KitCollection(){
            {
                this.addKit(new Kit(CollectMultipleModule.this.bounds, new Bucket(new PDimension(400.0, 200.0), CollectMultipleModule.this.getClock(), Element.H, 2), new Bucket(new PDimension(450.0, 200.0), CollectMultipleModule.this.getClock(), Element.O, 2)));
                this.addKit(new Kit(CollectMultipleModule.this.bounds, new Bucket(new PDimension(500.0, 200.0), CollectMultipleModule.this.getClock(), Element.C, 2), new Bucket(new PDimension(600.0, 200.0), CollectMultipleModule.this.getClock(), Element.O, 4), new Bucket(new PDimension(500.0, 200.0), CollectMultipleModule.this.getClock(), Element.N, 2)));
                this.addKit(new Kit(CollectMultipleModule.this.bounds, new Bucket(new PDimension(600.0, 200.0), CollectMultipleModule.this.getClock(), Element.H, 12), new Bucket(new PDimension(600.0, 200.0), CollectMultipleModule.this.getClock(), Element.O, 4), new Bucket(new PDimension(500.0, 200.0), CollectMultipleModule.this.getClock(), Element.N, 2)));
                this.addCollectionBox(new CollectionBox(MoleculeList.CO2, 2));
                this.addCollectionBox(new CollectionBox(MoleculeList.O2, 2));
                this.addCollectionBox(new CollectionBox(MoleculeList.H2, 4));
                this.addCollectionBox(new CollectionBox(MoleculeList.NH3, 2));
            }
        };
        this.setInitialCollection(kitCollection);
    }

    protected BuildAMoleculeCanvas buildCanvas(CollectionList collectionList) {
        return new MoleculeCollectingCanvas(collectionList, false, new VoidFunction0(){

            public void apply() {
                CollectMultipleModule.this.addGeneratedCollection();
            }
        });
    }

    protected KitCollection generateModel() {
        return this.generateModel(true, 4);
    }
}

