/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildamolecule.module;

import edu.colorado.phet.buildamolecule.BuildAMoleculeStrings;
import edu.colorado.phet.buildamolecule.control.CollectionPanel;
import edu.colorado.phet.buildamolecule.model.Bucket;
import edu.colorado.phet.buildamolecule.model.CollectionBox;
import edu.colorado.phet.buildamolecule.model.CollectionList;
import edu.colorado.phet.buildamolecule.model.Kit;
import edu.colorado.phet.buildamolecule.model.KitCollection;
import edu.colorado.phet.buildamolecule.model.LayoutBounds;
import edu.colorado.phet.buildamolecule.model.MoleculeList;
import edu.colorado.phet.buildamolecule.module.AbstractBuildAMoleculeModule;
import edu.colorado.phet.buildamolecule.view.BuildAMoleculeCanvas;
import edu.colorado.phet.buildamolecule.view.MoleculeCollectingCanvas;
import edu.colorado.phet.chemistry.model.Element;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Frame;

public class MakeMoleculeModule
extends AbstractBuildAMoleculeModule {
    public MakeMoleculeModule(Frame frame) {
        super(frame, BuildAMoleculeStrings.TITLE_MAKE_MOLECULE, new LayoutBounds(false, CollectionPanel.getCollectionPanelModelWidth(true)));
        KitCollection kitCollection = new KitCollection(){
            {
                this.addKit(new Kit(MakeMoleculeModule.this.bounds, new Bucket(new PDimension(400.0, 200.0), MakeMoleculeModule.this.getClock(), Element.H, 2), new Bucket(new PDimension(350.0, 200.0), MakeMoleculeModule.this.getClock(), Element.O, 1)));
                this.addKit(new Kit(MakeMoleculeModule.this.bounds, new Bucket(new PDimension(400.0, 200.0), MakeMoleculeModule.this.getClock(), Element.H, 2), new Bucket(new PDimension(450.0, 200.0), MakeMoleculeModule.this.getClock(), Element.O, 2)));
                this.addKit(new Kit(MakeMoleculeModule.this.bounds, new Bucket(new PDimension(350.0, 200.0), MakeMoleculeModule.this.getClock(), Element.C, 1), new Bucket(new PDimension(450.0, 200.0), MakeMoleculeModule.this.getClock(), Element.O, 2), new Bucket(new PDimension(500.0, 200.0), MakeMoleculeModule.this.getClock(), Element.N, 2)));
                this.addCollectionBox(new CollectionBox(MoleculeList.H2O, 1));
                this.addCollectionBox(new CollectionBox(MoleculeList.O2, 1));
                this.addCollectionBox(new CollectionBox(MoleculeList.H2, 1));
                this.addCollectionBox(new CollectionBox(MoleculeList.CO2, 1));
                this.addCollectionBox(new CollectionBox(MoleculeList.N2, 1));
            }
        };
        this.setInitialCollection(kitCollection);
    }

    protected BuildAMoleculeCanvas buildCanvas(CollectionList collectionList) {
        return new MoleculeCollectingCanvas(collectionList, true, new VoidFunction0(){

            public void apply() {
                MakeMoleculeModule.this.addGeneratedCollection();
            }
        });
    }

    protected KitCollection generateModel() {
        return this.generateModel(false, 5);
    }
}

