/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildamolecule.view;

import edu.colorado.phet.buildamolecule.BuildAMoleculeConstants;
import edu.colorado.phet.buildamolecule.model.Atom2D;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.ShadedSphereNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;

public class AtomNode
extends PNode {
    private final ShadedSphereNode sphericalNode;

    public AtomNode(final Atom2D atom2D) {
        double d = BuildAMoleculeConstants.MODEL_VIEW_TRANSFORM.modelToViewDeltaX(atom2D.getRadius());
        this.sphericalNode = new ShadedSphereNode(2.0 * d, atom2D.getColor());
        this.addChild(this.sphericalNode);
        PText pText = new PText(){
            {
                this.setText(atom2D.getSymbol());
                this.setFont(new PhetFont(10, true));
                this.setScale(((AtomNode)AtomNode.this).sphericalNode.getFullBoundsReference().width * 0.65 / this.getFullBoundsReference().width);
                if (0.3 * (double)atom2D.getColor().getRed() + 0.59 * (double)atom2D.getColor().getGreen() + 0.11 * (double)atom2D.getColor().getBlue() < 125.0) {
                    this.setTextPaint(Color.WHITE);
                }
                this.setOffset(-this.getFullBoundsReference().width / 2.0, -this.getFullBoundsReference().height / 2.0);
            }
        };
        this.sphericalNode.addChild(pText);
        atom2D.addPositionListener(new SimpleObserver(){

            public void update() {
                AtomNode.this.sphericalNode.setOffset(BuildAMoleculeConstants.MODEL_VIEW_TRANSFORM.modelToView(atom2D.getPosition()).toPoint2D());
            }
        });
        this.addInputEventListener(new CursorHandler());
        atom2D.visible.addObserver(new SimpleObserver(){

            public void update() {
                AtomNode.this.setVisible(atom2D.visible.get());
            }
        });
        atom2D.addListener(new Atom2D.Adapter(){});
    }
}

