/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildamolecule.view;

import edu.colorado.phet.buildamolecule.BuildAMoleculeConstants;
import edu.colorado.phet.buildamolecule.model.CollectionList;
import edu.colorado.phet.buildamolecule.model.KitCollection;
import edu.colorado.phet.buildamolecule.view.KitCollectionNode;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class BuildAMoleculeCanvas
extends PhetPCanvas {
    public final CollectionList collectionList;
    private PNode baseLayer = new PNode();
    public final Function1<PNode, Rectangle2D> toModelBounds = new Function1<PNode, Rectangle2D>(){

        @Override
        public Rectangle2D apply(PNode pNode) {
            Rectangle2D rectangle2D = pNode.getParent().localToGlobal(pNode.getFullBounds());
            Point2D.Double double_ = new Point2D.Double(rectangle2D.getX(), rectangle2D.getY());
            PDimension pDimension = new PDimension(rectangle2D.getWidth(), rectangle2D.getHeight());
            BuildAMoleculeCanvas.this.getPhetRootNode().globalToWorld(double_);
            BuildAMoleculeCanvas.this.getPhetRootNode().globalToWorld(pDimension);
            Rectangle2D.Double double_2 = new Rectangle2D.Double(((Point2D)double_).getX(), ((Point2D)double_).getY(), pDimension.getWidth(), pDimension.getHeight());
            return BuildAMoleculeConstants.MODEL_VIEW_TRANSFORM.viewToModel(double_2).getBounds2D();
        }
    };

    public BuildAMoleculeCanvas(CollectionList collectionList) {
        this.collectionList = collectionList;
        this.setWorldTransformStrategy(new PhetPCanvas.CenteredStage(this, BuildAMoleculeConstants.STAGE_SIZE));
        this.setBackground(BuildAMoleculeConstants.CANVAS_BACKGROUND_COLOR);
        this.addWorldChild(this.baseLayer);
        KitCollection kitCollection = collectionList.currentCollection.get();
        this.addCollection(kitCollection);
        collectionList.addListener(new CollectionList.Adapter(){

            public void addedCollection(KitCollection kitCollection) {
                BuildAMoleculeCanvas.this.addCollection(kitCollection);
            }
        });
    }

    protected KitCollectionNode addCollection(KitCollection kitCollection) {
        KitCollectionNode kitCollectionNode = new KitCollectionNode(this.collectionList, kitCollection, this);
        this.addWorldChild(kitCollectionNode);
        return kitCollectionNode;
    }

    public KitCollection getCurrentCollection() {
        return this.collectionList.currentCollection.get();
    }

    protected void updateLayout() {
        Dimension2D dimension2D = this.getWorldSize();
        if (dimension2D.getWidth() <= 0.0 || dimension2D.getHeight() <= 0.0) {
            return;
        }
    }

    public PNode getBaseLayer() {
        return this.baseLayer;
    }
}

