/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildamolecule.view;

import edu.colorado.phet.buildamolecule.BuildAMoleculeConstants;
import edu.colorado.phet.buildamolecule.BuildAMoleculeStrings;
import edu.colorado.phet.buildamolecule.model.Atom2D;
import edu.colorado.phet.buildamolecule.model.CollectionBox;
import edu.colorado.phet.buildamolecule.model.Molecule;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.ArrowNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

public class CollectionBoxHintNode
extends PNode {
    public CollectionBoxHintNode(final Molecule molecule, CollectionBox collectionBox) {
        PBounds pBounds = molecule.getDestinationBounds();
        Vector2D vector2D = BuildAMoleculeConstants.MODEL_VIEW_TRANSFORM.modelToView(new Vector2D(collectionBox.getDropBounds().getMinX() - 20.0, collectionBox.getDropBounds().getCenterY()));
        final Rectangle2D rectangle2D = BuildAMoleculeConstants.MODEL_VIEW_TRANSFORM.modelToViewRectangle(pBounds);
        PNode pNode = new PNode(){
            {
                PText pText = new PText(BuildAMoleculeStrings.COLLECTION_HINT){
                    {
                        this.setFont(new PhetFont(16, true));
                        this.setTextPaint(Color.BLACK);
                    }
                };
                double d = 5.0;
                double d2 = 5.0;
                PBounds pBounds = pText.getFullBounds();
                this.addChild(new PhetPPath(new RoundRectangle2D.Double(pBounds.x - d2, pBounds.y - d, pBounds.getWidth() + d2 * 2.0, pBounds.getHeight() + d * 2.0, 15.0, 15.0)){
                    {
                        this.setPaint(Color.WHITE);
                        this.setStrokePaint(Color.BLACK);
                    }
                });
                this.addChild(pText);
                this.centerFullBoundsOnPoint(rectangle2D.getCenterX(), rectangle2D.getMaxY() + 5.0 + this.getFullBounds().getHeight() / 2.0);
            }
        };
        this.addChild(pNode);
        Vector2D vector2D2 = new Vector2D(pNode.getFullBounds().getMaxX() - 5.0, pNode.getFullBounds().getCenterY());
        Vector2D vector2D3 = vector2D.minus(vector2D2).normalized();
        ArrowNode arrowNode = new ArrowNode(vector2D2.plus(vector2D3.times(15.0)).toPoint2D(), vector2D.toPoint2D(), 30.0, 40.0, 20.0){
            {
                this.setPaint(Color.BLUE);
            }
        };
        this.addChild(arrowNode);
        Atom2D.Adapter adapter = new Atom2D.Adapter(){

            public void grabbedByUser(Atom2D atom2D) {
                CollectionBoxHintNode.this.disperse();
                for (Atom2D atom2D2 : molecule.getAtoms()) {
                    atom2D2.removeListener(this);
                }
            }
        };
        for (Atom2D atom2D : molecule.getAtoms()) {
            atom2D.addListener(adapter);
        }
    }

    public void disperse() {
        this.setVisible(false);
    }
}

