/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildamolecule.view;

import edu.colorado.phet.buildamolecule.BuildAMoleculeConstants;
import edu.colorado.phet.buildamolecule.control.AllFilledDialogNode;
import edu.colorado.phet.buildamolecule.control.CollectionPanel;
import edu.colorado.phet.buildamolecule.model.CollectionBox;
import edu.colorado.phet.buildamolecule.model.CollectionList;
import edu.colorado.phet.buildamolecule.model.Kit;
import edu.colorado.phet.buildamolecule.model.KitCollection;
import edu.colorado.phet.buildamolecule.model.Molecule;
import edu.colorado.phet.buildamolecule.view.BuildAMoleculeCanvas;
import edu.colorado.phet.buildamolecule.view.CollectionBoxHintNode;
import edu.colorado.phet.buildamolecule.view.KitCollectionNode;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import java.util.LinkedList;
import java.util.List;

public class MoleculeCollectingCanvas
extends BuildAMoleculeCanvas {
    private CollectionBoxHintNode collectionBoxHintNode = null;
    private VoidFunction0 regenerateCallback;
    protected List<SimpleObserver> collectionAttachmentListeners = new LinkedList<SimpleObserver>();

    public MoleculeCollectingCanvas(CollectionList collectionList, boolean bl, VoidFunction0 voidFunction0) {
        super(collectionList);
        this.regenerateCallback = voidFunction0;
        this.getBaseLayer().addChild(new CollectionPanel(collectionList, bl, new VoidFunction1<SimpleObserver>(){

            @Override
            public void apply(SimpleObserver simpleObserver) {
                MoleculeCollectingCanvas.this.collectionAttachmentListeners.add(simpleObserver);
            }
        }, this.toModelBounds){
            {
                this.setOffset(BuildAMoleculeConstants.STAGE_SIZE.width - this.getFullBounds().getWidth() - 18.0, 18.0);
            }
        });
        for (SimpleObserver object : this.collectionAttachmentListeners) {
            object.update();
        }
        final KitCollection kitCollection = collectionList.currentCollection.get();
        for (Kit kit : kitCollection.getKits()) {
            kit.addMoleculeListener(new Kit.MoleculeAdapter(){

                public void addedMolecule(Molecule molecule) {
                    CollectionBox collectionBox = kitCollection.getFirstTargetBox(molecule);
                    if (MoleculeCollectingCanvas.this.collectionBoxHintNode == null && collectionBox != null) {
                        MoleculeCollectingCanvas.this.collectionBoxHintNode = new CollectionBoxHintNode(molecule, collectionBox);
                        MoleculeCollectingCanvas.this.addWorldChild(MoleculeCollectingCanvas.this.collectionBoxHintNode);
                    } else if (MoleculeCollectingCanvas.this.collectionBoxHintNode != null) {
                        MoleculeCollectingCanvas.this.collectionBoxHintNode.disperse();
                    }
                }

                public void removedMolecule(Molecule molecule) {
                    if (MoleculeCollectingCanvas.this.collectionBoxHintNode != null) {
                        MoleculeCollectingCanvas.this.collectionBoxHintNode.disperse();
                    }
                }
            });
            kit.visible.addObserver(new SimpleObserver(){

                public void update() {
                    if (MoleculeCollectingCanvas.this.collectionBoxHintNode != null) {
                        MoleculeCollectingCanvas.this.collectionBoxHintNode.disperse();
                    }
                }
            });
        }
    }

    public KitCollectionNode addCollection(final KitCollection kitCollection) {
        final KitCollectionNode kitCollectionNode = super.addCollection(kitCollection);
        kitCollection.allCollectionBoxesFilled.addObserver(new SimpleObserver(){
            private boolean hasShownOnce = false;
            private AllFilledDialogNode allFilledDialogNode;

            public void update() {
                if (kitCollection.allCollectionBoxesFilled.get().booleanValue()) {
                    if (!this.hasShownOnce) {
                        this.allFilledDialogNode = new AllFilledDialogNode(MoleculeCollectingCanvas.this.collectionList.getAvailablePlayAreaBounds(), MoleculeCollectingCanvas.this.regenerateCallback);
                        this.hasShownOnce = true;
                    }
                    kitCollectionNode.addChild(this.allFilledDialogNode);
                } else if (this.allFilledDialogNode != null) {
                    kitCollectionNode.removeChild(this.allFilledDialogNode);
                }
            }
        });
        return kitCollectionNode;
    }
}

