/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildamolecule.view.view3d;

import edu.colorado.phet.buildamolecule.BuildAMoleculeResources;
import edu.colorado.phet.buildamolecule.BuildAMoleculeStrings;
import edu.colorado.phet.buildamolecule.model.CompleteMolecule;
import edu.colorado.phet.buildamolecule.view.view3d.JmolDialogProperty;
import edu.colorado.phet.common.jmolphet.JmolDialog;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.Option;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PAffineTransform;
import java.awt.Color;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;

public class ShowMolecule3DButtonNode
extends PNode {
    public final Property<Option<JmolDialog>> dialog;

    public ShowMolecule3DButtonNode(final JmolDialogProperty jmolDialogProperty, final CompleteMolecule completeMolecule) {
        this.dialog = jmolDialogProperty;
        PText pText = new PText(BuildAMoleculeStrings.ICON_3D){
            {
                this.setFont(new PhetFont(12, true));
                this.setTextPaint(Color.WHITE);
            }
        };
        if (pText.getWidth() > 35.0) {
            pText.setText("3D");
        }
        PImage pImage = new PImage(BuildAMoleculeResources.getImage("green-left.png"));
        PImage pImage2 = new PImage(BuildAMoleculeResources.getImage("green-middle.png"));
        PImage pImage3 = new PImage(BuildAMoleculeResources.getImage("green-right.png"));
        double d = pImage.getWidth() + pImage2.getWidth() + pImage3.getWidth();
        double d2 = 2.0;
        double d3 = pText.getFullBounds().getWidth() + 2.0 * d2;
        if (d3 < d) {
            d3 = d;
        }
        d3 = Math.ceil(d3);
        pText.setOffset((d3 - pText.getFullBounds().getWidth()) / 2.0, (pImage.getFullBounds().getHeight() - pText.getFullBounds().getHeight()) / 2.0);
        double d4 = d3 - d + 1.0;
        pImage2.setTransform(new PAffineTransform(d4, 0.0, 0.0, 1.0, pImage.getWidth(), 0.0));
        pImage3.setOffset(pImage.getWidth() + pImage2.getFullBounds().getWidth(), 0.0);
        this.addChild(pImage);
        this.addChild(pImage2);
        this.addChild(pImage3);
        this.addChild(pText);
        this.addInputEventListener(new CursorHandler(){

            public void mouseClicked(PInputEvent pInputEvent) {
                if (((Option)jmolDialogProperty.get()).isNone()) {
                    jmolDialogProperty.set(new Option.Some<JmolDialog>(JmolDialog.displayMolecule3D(PhetApplication.getInstance().getPhetFrame(), completeMolecule, BuildAMoleculeStrings.JMOL_3D_SPACE_FILLING, BuildAMoleculeStrings.JMOL_3D_BALL_AND_STICK, BuildAMoleculeStrings.JMOL_3D_LOADING)));
                    System.out.println("Showing 3D dialog for " + completeMolecule.getDisplayName() + " PubChem CID #" + completeMolecule.getCID());
                    ((JmolDialog)((Option)jmolDialogProperty.get()).get()).addWindowListener(new WindowAdapter(){

                        public void windowClosed(WindowEvent windowEvent) {
                            jmolDialogProperty.set(new Option.None());
                        }
                    });
                } else {
                    ((JmolDialog)((Option)jmolDialogProperty.get()).get()).requestFocus();
                }
            }
        });
        jmolDialogProperty.addObserver(new SimpleObserver(){

            public void update() {
                ShowMolecule3DButtonNode.this.setTransparency(((Option)jmolDialogProperty.get()).isSome() ? 0.5f : 1.0f);
            }
        });
        this.addChild(new PhetPPath(new Rectangle2D.Double(0.0, 0.0, this.getFullBounds().getWidth(), this.getFullBounds().getHeight())){
            {
                super(shape);
                this.setPaint(new Color(128, 128, 128, 64));
                this.setStroke(null);
                jmolDialogProperty.addObserver(new SimpleObserver(){

                    public void update() {
                        this.setVisible(((Option)jmolDialogProperty.get()).isSome());
                    }
                });
            }
        });
    }
}

