/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.chemistry.utils;

import edu.colorado.phet.chemistry.model.Element;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChemUtils {
    public static String createSymbol(Element[] elementArray) {
        return ChemUtils.toSubscript(ChemUtils.createSymbolWithoutSubscripts(elementArray));
    }

    public static String createSymbolWithoutSubscripts(Element[] elementArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        for (int i = 0; i < elementArray.length; ++i) {
            if (i == 0) {
                stringBuffer.append(elementArray[i].getSymbol());
                continue;
            }
            if (elementArray[i].equals(elementArray[i - 1])) {
                ++n;
                continue;
            }
            if (n > 1) {
                stringBuffer.append(String.valueOf(n));
            }
            n = 1;
            stringBuffer.append(elementArray[i].getSymbol());
        }
        if (n > 1) {
            stringBuffer.append(String.valueOf(n));
        }
        return stringBuffer.toString();
    }

    private static int nonCarbonHillSortValue(Element element) {
        int n = 1000 * element.getSymbol().charAt(0);
        if (element.getSymbol().length() > 1) {
            n += element.getSymbol().charAt(1);
        }
        return n;
    }

    private static int carbonHillSortValue(Element element) {
        if (element.isCarbon()) {
            return 0;
        }
        if (element.isHydrogen()) {
            return 1;
        }
        return ChemUtils.nonCarbonHillSortValue(element);
    }

    public static String hillOrderedSymbol(Collection<Element> collection) {
        boolean bl = false;
        for (Element element : collection) {
            if (!element.isCarbon()) continue;
            bl = true;
            break;
        }
        LinkedList<Element> linkedList = new LinkedList<Element>(collection);
        if (bl) {
            Collections.sort(linkedList, new Comparator<Element>(){

                @Override
                public int compare(Element element, Element element2) {
                    return new Integer(ChemUtils.carbonHillSortValue(element)).compareTo(ChemUtils.carbonHillSortValue(element2));
                }
            });
        } else {
            Collections.sort(linkedList, new Comparator<Element>(){

                @Override
                public int compare(Element element, Element element2) {
                    return new Integer(ChemUtils.nonCarbonHillSortValue(element)).compareTo(ChemUtils.nonCarbonHillSortValue(element2));
                }
            });
        }
        return ChemUtils.createSymbol(linkedList.toArray(new Element[linkedList.size()]));
    }

    public static String toSubscript(String string) {
        String string2 = "";
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!bl && Character.isDigit(c)) {
                string2 = string2 + "<sub>";
                bl = true;
            } else if (bl && !Character.isDigit(c)) {
                string2 = string2 + "</sub>";
                bl = false;
            }
            string2 = string2 + c;
        }
        if (bl) {
            string2 = string2 + "</sub>";
            bl = false;
        }
        return string2;
    }
}

