/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.swing;

import edu.umd.cs.piccolo.PNode;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ListIterator;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class SwingLayoutNode
extends PNode {
    private static final Anchor DEFAULT_ANCHOR = Anchor.WEST;
    private final Container container;
    private final PropertyChangeListener propertyChangeListener;
    private Anchor defaultAnchor;

    public SwingLayoutNode(LayoutManager layoutManager) {
        this(new JPanel(layoutManager));
    }

    public SwingLayoutNode(Container container) {
        this.container = container;
        this.propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (SwingLayoutNode.this.isLayoutProperty(string)) {
                    SwingLayoutNode.this.updateContainerLayout();
                }
            }
        };
        this.defaultAnchor = DEFAULT_ANCHOR;
    }

    public void addChild(int n, PNode pNode, Object object, Anchor anchor) {
        super.addChild(n, pNode);
        this.addProxyComponent(pNode, object, anchor);
    }

    public void addChild(int n, PNode pNode) {
        this.addChild(n, pNode, null, this.defaultAnchor);
    }

    public void addChild(PNode pNode, Object object, Anchor anchor) {
        int n = this.getChildrenCount();
        if (pNode.getParent() == this) {
            --n;
        }
        this.addChild(n, pNode, object, anchor);
    }

    public void addChild(PNode pNode) {
        this.addChild(pNode, null, this.defaultAnchor);
    }

    public void addChild(PNode pNode, Object object) {
        this.addChild(pNode, object, this.defaultAnchor);
    }

    public PNode removeChild(int n) {
        PNode pNode = super.removeChild(n);
        this.removeProxyComponent(pNode);
        return pNode;
    }

    public void removeAllChildren() {
        ListIterator listIterator = this.getChildrenIterator();
        while (listIterator.hasNext()) {
            this.removeChild((PNode)listIterator.next());
        }
    }

    private void addProxyComponent(PNode pNode, Object object, Anchor anchor) {
        ProxyComponent proxyComponent = new ProxyComponent(pNode, anchor);
        this.container.add((Component)proxyComponent, object);
        pNode.addPropertyChangeListener(this.propertyChangeListener);
        this.updateContainerLayout();
    }

    private void removeProxyComponent(PNode pNode) {
        ProxyComponent proxyComponent;
        if (pNode != null && (proxyComponent = this.getComponentForNode(pNode)) != null) {
            this.container.remove(proxyComponent);
            pNode.removePropertyChangeListener(this.propertyChangeListener);
            this.updateContainerLayout();
        }
    }

    private ProxyComponent getComponentForNode(PNode pNode) {
        ProxyComponent proxyComponent = null;
        Component[] componentArray = this.container.getComponents();
        if (componentArray != null) {
            for (int i = 0; i < componentArray.length && proxyComponent == null; ++i) {
                ProxyComponent proxyComponent2;
                if (!(componentArray[i] instanceof ProxyComponent) || (proxyComponent2 = (ProxyComponent)componentArray[i]).getNode() != pNode) continue;
                proxyComponent = proxyComponent2;
            }
        }
        return proxyComponent;
    }

    private boolean isLayoutProperty(String string) {
        return string.equals("visible") || string.equals("fullBounds") || string.equals("bounds") || string.equals("transform");
    }

    private void updateContainerLayout() {
        this.container.invalidate();
        this.container.setSize(this.container.getPreferredSize());
        this.container.doLayout();
    }

    public static interface Anchor {
        public static final Anchor CENTER = new AbstractAnchor(){

            public void positionNode(PNode pNode, double d, double d2, double d3, double d4) {
                pNode.setOffset(1.centerX(pNode, d, d3), 1.centerY(pNode, d2, d4));
            }
        };
        public static final Anchor NORTH = new AbstractAnchor(){

            public void positionNode(PNode pNode, double d, double d2, double d3, double d4) {
                pNode.setOffset(2.centerX(pNode, d, d3), 2.north(pNode, d2, d4));
            }
        };
        public static final Anchor NORTHEAST = new AbstractAnchor(){

            public void positionNode(PNode pNode, double d, double d2, double d3, double d4) {
                pNode.setOffset(3.east(pNode, d, d3), 3.north(pNode, d2, d4));
            }
        };
        public static final Anchor EAST = new AbstractAnchor(){

            public void positionNode(PNode pNode, double d, double d2, double d3, double d4) {
                pNode.setOffset(4.east(pNode, d, d3), 4.centerY(pNode, d2, d4));
            }
        };
        public static final Anchor SOUTHEAST = new AbstractAnchor(){

            public void positionNode(PNode pNode, double d, double d2, double d3, double d4) {
                pNode.setOffset(5.east(pNode, d, d3), 5.south(pNode, d2, d4));
            }
        };
        public static final Anchor SOUTH = new AbstractAnchor(){

            public void positionNode(PNode pNode, double d, double d2, double d3, double d4) {
                pNode.setOffset(6.centerX(pNode, d, d3), 6.south(pNode, d2, d4));
            }
        };
        public static final Anchor SOUTHWEST = new AbstractAnchor(){

            public void positionNode(PNode pNode, double d, double d2, double d3, double d4) {
                pNode.setOffset(7.west(pNode, d, d3), 7.south(pNode, d2, d4));
            }
        };
        public static final Anchor WEST = new AbstractAnchor(){

            public void positionNode(PNode pNode, double d, double d2, double d3, double d4) {
                pNode.setOffset(8.west(pNode, d, d3), 8.centerY(pNode, d2, d4));
            }
        };
        public static final Anchor NORTHWEST = new AbstractAnchor(){

            public void positionNode(PNode pNode, double d, double d2, double d3, double d4) {
                pNode.setOffset(9.west(pNode, d, d3), 9.north(pNode, d2, d4));
            }
        };

        public void positionNode(PNode var1, double var2, double var4, double var6, double var8);

        public static abstract class AbstractAnchor
        implements Anchor {
            protected static double centerX(PNode pNode, double d, double d2) {
                return d + (d2 - pNode.getFullBoundsReference().getWidth()) / 2.0;
            }

            protected static double centerY(PNode pNode, double d, double d2) {
                return d + (d2 - pNode.getFullBoundsReference().getHeight()) / 2.0;
            }

            protected static double north(PNode pNode, double d, double d2) {
                return d;
            }

            protected static double south(PNode pNode, double d, double d2) {
                return d + d2 - pNode.getFullBoundsReference().getHeight();
            }

            protected static double east(PNode pNode, double d, double d2) {
                return d + d2 - pNode.getFullBoundsReference().getWidth();
            }

            protected static double west(PNode pNode, double d, double d2) {
                return d;
            }
        }
    }

    private static class ProxyComponent
    extends JComponent {
        private final PNode node;
        private final Anchor anchor;

        public ProxyComponent(PNode pNode, Anchor anchor) {
            this.node = pNode;
            this.anchor = anchor;
        }

        public PNode getNode() {
            return this.node;
        }

        public Dimension getPreferredSize() {
            double d = this.node.getFullBoundsReference().getWidth();
            double d2 = this.node.getFullBoundsReference().getHeight();
            return new Dimension(this.roundUp(d), this.roundUp(d2));
        }

        private int roundUp(double d) {
            return (int)Math.ceil(d);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            if (n != this.getX() || n2 != this.getY() || n3 != this.getWidth() || n4 != this.getHeight()) {
                super.setBounds(n, n2, n3, n4);
                this.anchor.positionNode(this.node, n, n2, n3, n4);
            }
        }
    }
}

