/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.bspt;

import javax.vecmath.Point3f;
import org.jmol.bspt.Bspt;
import org.jmol.bspt.Element;
import org.jmol.bspt.Leaf;
import org.jmol.util.Logger;

class Node
extends Element {
    int dim;
    float minLeft;
    float maxLeft;
    Element eleLeft;
    float minRight;
    float maxRight;
    Element eleRight;

    Node(Bspt bspt, int n, Leaf leaf) {
        this.bspt = bspt;
        if (n == bspt.treeDepth) {
            bspt.treeDepth = n + 1;
            if (bspt.treeDepth >= 100) {
                Logger.error("BSPT tree depth too great:" + bspt.treeDepth);
            }
        }
        if (leaf.count != 2) {
            throw new NullPointerException();
        }
        this.dim = n % bspt.dimMax;
        leaf.sort(this.dim);
        Leaf leaf2 = new Leaf(bspt, leaf, 1);
        this.minLeft = Node.getDimensionValue(leaf.tuples[0], this.dim);
        this.maxLeft = Node.getDimensionValue(leaf.tuples[leaf.count - 1], this.dim);
        this.minRight = Node.getDimensionValue(leaf2.tuples[0], this.dim);
        this.maxRight = Node.getDimensionValue(leaf2.tuples[leaf2.count - 1], this.dim);
        this.eleLeft = leaf;
        this.eleRight = leaf2;
        this.count = 2;
    }

    Element addTuple(int n, Point3f point3f) {
        float f = Node.getDimensionValue(point3f, this.dim);
        ++this.count;
        boolean bl = f < this.maxLeft ? true : (f > this.minRight ? false : (f == this.maxLeft ? (f == this.minRight ? this.eleLeft.count < this.eleRight.count : true) : (f == this.minRight ? false : this.eleLeft.count < this.eleRight.count)));
        if (bl) {
            if (f < this.minLeft) {
                this.minLeft = f;
            } else if (f > this.maxLeft) {
                this.maxLeft = f;
            }
            this.eleLeft = this.eleLeft.addTuple(n + 1, point3f);
        } else {
            if (f < this.minRight) {
                this.minRight = f;
            } else if (f > this.maxRight) {
                this.maxRight = f;
            }
            this.eleRight = this.eleRight.addTuple(n + 1, point3f);
        }
        return this;
    }

    public String toString() {
        return this.eleLeft.toString() + this.dim + ":" + "\n" + this.eleRight.toString();
    }

    static float getDimensionValue(Point3f point3f, int n) {
        return n == 0 ? point3f.x : (n == 1 ? point3f.y : point3f.z);
    }
}

