/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import org.jmol.api.JmolRendererInterface;
import org.jmol.export.___Exporter;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.Hermite3D;
import org.jmol.modelset.Atom;
import org.jmol.viewer.Viewer;

public final class Export3D
implements JmolRendererInterface {
    private ___Exporter exporter;
    private double privateKey;
    private Graphics3D g3d;
    private short colix;
    private Hermite3D hermite3d;
    private int width;
    private int height;
    private int slab;
    String exportName;
    private Point3f ptA = new Point3f();
    private Point3f ptB = new Point3f();
    private Point3f ptC = new Point3f();
    private Point3f ptD = new Point3f();
    private Point3i ptAi = new Point3i();
    private Point3i ptBi = new Point3i();

    public Export3D() {
        this.hermite3d = new Hermite3D(this);
    }

    public int getExportType() {
        return this.exporter.exportType;
    }

    public String getExportName() {
        return this.exportName;
    }

    public boolean initializeExporter(String string, Viewer viewer, double d, Graphics3D graphics3D, Object object) {
        this.exportName = string;
        try {
            String string2 = "org.jmol.export._" + string + "Exporter";
            Class<?> clazz = Class.forName(string2);
            this.exporter = (___Exporter)clazz.newInstance();
        }
        catch (Exception exception) {
            return false;
        }
        this.g3d = graphics3D;
        this.exporter.setRenderer(this);
        graphics3D.setNewWindowParametersForExport();
        this.slab = graphics3D.getSlab();
        this.width = graphics3D.getRenderWidth();
        this.height = graphics3D.getRenderHeight();
        this.privateKey = d;
        return this.exporter.initializeOutput(viewer, d, graphics3D, object);
    }

    public String finalizeOutput() {
        return this.exporter.finalizeOutput();
    }

    public void renderBackground() {
        if (this.exporter.exportType == 2) {
            this.g3d.renderBackground(this);
        }
    }

    public void drawAtom(Atom atom) {
        this.exporter.drawAtom(atom);
    }

    public void drawRect(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n4 != 0 && this.isClippedZ(n4)) {
            return;
        }
        int n7 = n5 - 1;
        int n8 = n6 - 1;
        int n9 = n + n7;
        int n10 = n2 + n8;
        if (n2 >= 0 && n2 < this.height) {
            this.drawHLine(n, n2, n3, n7);
        }
        if (n10 >= 0 && n10 < this.height) {
            this.drawHLine(n, n10, n3, n7);
        }
        if (n >= 0 && n < this.width) {
            this.drawVLine(n, n2, n3, n8);
        }
        if (n9 >= 0 && n9 < this.width) {
            this.drawVLine(n9, n2, n3, n8);
        }
    }

    private void drawHLine(int n, int n2, int n3, int n4) {
        int n5 = this.g3d.getColorArgbOrGray(this.colix);
        if (n4 < 0) {
            n += n4;
            n4 = -n4;
        }
        for (int i = 0; i <= n4; ++i) {
            this.exporter.drawTextPixel(n5, n + i, n2, n3);
        }
    }

    private void drawVLine(int n, int n2, int n3, int n4) {
        int n5 = this.g3d.getColorArgbOrGray(this.colix);
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        for (int i = 0; i <= n4; ++i) {
            this.exporter.drawTextPixel(n5, n, n2 + i, n3);
        }
    }

    public void fillRect(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.isClippedZ(n4)) {
            return;
        }
        this.ptA.set(n, n2, n3);
        this.ptB.set(n + n5, n2, n3);
        this.ptC.set(n + n5, n2 + n6, n3);
        this.ptD.set(n, n2 + n6, n3);
        this.fillQuadrilateral(this.ptA, this.ptB, this.ptC, this.ptD);
    }

    public void drawString(String string, Font3D font3D, int n, int n2, int n3, int n4) {
        if (string == null) {
            return;
        }
        if (this.isClippedZ(n4)) {
            return;
        }
        this.drawStringNoSlab(string, font3D, n, n2, n3);
    }

    public void drawStringNoSlab(String string, Font3D font3D, int n, int n2, int n3) {
        if (string == null) {
            return;
        }
        n3 = Math.max(this.slab, n3);
        if (font3D == null) {
            font3D = this.g3d.getFont3DCurrent();
        } else {
            this.g3d.setFont(font3D);
        }
        this.exporter.plotText(n, n2, n3, this.colix, string, font3D);
    }

    public void drawPixel(int n, int n2, int n3) {
        this.plotPixelClipped(n, n2, n3);
    }

    void plotPixelClipped(int n, int n2, int n3) {
        if (this.isClipped(n, n2, n3)) {
            return;
        }
        this.exporter.drawPixel(this.colix, n, n2, n3, 1);
    }

    public void plotPixelClippedNoSlab(int n, int n2, int n3, int n4) {
        n4 = Math.max(this.slab, n4);
        this.exporter.drawTextPixel(n, n2, n3, n4);
    }

    public void drawDashedLine(int n, int n2, Point3i point3i, Point3i point3i2) {
        this.drawLine(point3i, point3i2);
    }

    public void drawDottedLine(Point3i point3i, Point3i point3i2) {
        this.drawLine(point3i, point3i2);
    }

    public void drawLine(short s, short s2, int n, int n2, int n3, int n4, int n5, int n6) {
        this.fillCylinder(s, s2, (byte)2, this.exporter.lineWidthMad, n, n2, n3, n4, n5, n6);
    }

    public void drawLine(Point3i point3i, Point3i point3i2) {
        this.ptA.set(point3i.x, point3i.y, point3i.z);
        this.ptB.set(point3i2.x, point3i2.y, point3i2.z);
        this.exporter.fillCylinderScreenMad(this.colix, (byte)2, this.exporter.lineWidthMad, this.ptA, this.ptB);
    }

    public void drawBond(Atom atom, Atom atom2, short s, short s2, byte by, short s3) {
        if (s3 == 1) {
            s3 = this.exporter.lineWidthMad;
        }
        this.exporter.drawCylinder(atom, atom2, s, s2, by, s3, -1);
    }

    public void fillCylinder(short s, short s2, byte by, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.ptA.set(n2, n3, n4);
        this.ptB.set(n5, n6, n7);
        this.exporter.drawCylinder(this.ptA, this.ptB, s, s2, by, n, 1);
    }

    public void fillCylinder(byte by, int n, Point3i point3i, Point3i point3i2) {
        if (n <= 0) {
            return;
        }
        this.ptA.set(point3i.x, point3i.y, point3i.z);
        this.ptB.set(point3i2.x, point3i2.y, point3i2.z);
        this.exporter.fillCylinderScreenMad(this.colix, by, n, this.ptA, this.ptB);
    }

    public void fillQuadrilateral(Point3f point3f, Point3f point3f2, Point3f point3f3, Point3f point3f4) {
        this.exporter.fillTriangle(this.colix, point3f, point3f2, point3f3, false);
        this.exporter.fillTriangle(this.colix, point3f, point3f3, point3f4, false);
    }

    public boolean isAntialiased() {
        return false;
    }

    public boolean checkTranslucent(boolean bl) {
        return true;
    }

    public boolean haveTranslucentObjects() {
        return true;
    }

    public int getRenderWidth() {
        return this.g3d.getRenderWidth();
    }

    public int getRenderHeight() {
        return this.g3d.getRenderHeight();
    }

    public int getSlab() {
        return this.g3d.getSlab();
    }

    public int getDepth() {
        return this.g3d.getDepth();
    }

    public boolean setColix(short s) {
        this.colix = s;
        this.g3d.setColix(s);
        return true;
    }

    public void setFont(byte by) {
        this.g3d.setFont(by);
    }

    public boolean isInDisplayRange(int n, int n2) {
        if (this.exporter.exportType == 1) {
            return true;
        }
        return this.g3d.isInDisplayRange(n, n2);
    }

    public boolean isClippedZ(int n) {
        return this.g3d.isClippedZ(n);
    }

    public boolean isClipped(int n, int n2, int n3) {
        return this.g3d.isClippedZ(n3) || this.isClipped(n, n2);
    }

    protected boolean isClipped(int n, int n2) {
        if (this.exporter.exportType == 1) {
            return false;
        }
        return this.g3d.isClipped(n, n2);
    }

    public byte getFontFid(String string, float f) {
        return this.g3d.getFontFid(string, f);
    }

    public Font3D getFont3DScaled(Font3D font3D, float f) {
        return this.g3d.getFont3DScaled(font3D, f);
    }
}

