/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export.image;

import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jmol.export.image.ImageEncoder;

public class PpmEncoder
extends ImageEncoder {
    public static byte[] getBytes(Image image) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            PpmEncoder.write(image, byteArrayOutputStream);
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void write(Image image, OutputStream outputStream) throws IOException {
        new PpmEncoder(image, outputStream).encode();
    }

    public PpmEncoder(Image image, OutputStream outputStream) {
        super(image, outputStream);
    }

    void encodeStart(int n, int n2) throws IOException {
        PpmEncoder.writeString(this.out, "P6\n");
        PpmEncoder.writeString(this.out, n + " " + n2 + "\n");
        PpmEncoder.writeString(this.out, "255\n");
    }

    static void writeString(OutputStream outputStream, String string) throws IOException {
        byte[] byArray = string.getBytes();
        outputStream.write(byArray);
    }

    void encodePixels(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) throws IOException {
        byte[] byArray = new byte[n3 * 3];
        for (int i = 0; i < n4; ++i) {
            int n7 = n5 + i * n6;
            for (int j = 0; j < n3; ++j) {
                int n8 = n7 + j;
                int n9 = j * 3;
                byArray[n9] = (byte)((nArray[n8] & 0xFF0000) >> 16);
                byArray[n9 + 1] = (byte)((nArray[n8] & 0xFF00) >> 8);
                byArray[n9 + 2] = (byte)(nArray[n8] & 0xFF);
            }
            this.out.write(byArray);
        }
    }

    void encodeDone() throws IOException {
    }
}

