/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.Line3D;
import org.jmol.g3d.Shade3D;

class Cylinder3D {
    final Graphics3D g3d;
    final Line3D line3d;
    private short colixA;
    private short colixB;
    private int[] shadesA;
    private boolean isScreenedA;
    private int[] shadesB;
    private boolean isScreenedB;
    private int xA;
    private int yA;
    private int zA;
    private int dxB;
    private int dyB;
    private int dzB;
    private float dxBf;
    private float dyBf;
    private float dzBf;
    private boolean tEvenDiameter;
    private int diameter;
    private byte endcaps;
    private boolean tEndcapOpen;
    private int xEndcap;
    private int yEndcap;
    private int zEndcap;
    private int argbEndcap;
    private short colixEndcap;
    private int endcapShadeIndex;
    private float radius;
    private float radius2;
    private float cosTheta;
    private float cosPhi;
    private float sinPhi;
    boolean clipped;
    private boolean drawBackside;
    int rasterCount;
    float[] tRaster = new float[32];
    float[] txRaster = new float[32];
    float[] tyRaster = new float[32];
    float[] tzRaster = new float[32];
    int[] xRaster = new int[32];
    int[] yRaster = new int[32];
    int[] zRaster = new int[32];
    int[] fp8ShadeIndexUp = new int[32];
    int yMin;
    int yMax;
    int xMin;
    int xMax;
    int zXMin;
    int zXMax;

    Cylinder3D(Graphics3D graphics3D) {
        this.g3d = graphics3D;
        this.line3d = graphics3D.line3d;
    }

    void render(short s, short s2, boolean bl, boolean bl2, byte by, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        int n9;
        int n10;
        if (n > this.g3d.height * 3) {
            return;
        }
        this.isScreenedA = bl;
        this.isScreenedB = bl2;
        int n11 = n / 2 + 1;
        int n12 = this.g3d.clipCode(n2 - n11, n3 - n11, n4 - n11);
        boolean bl3 = this.clipped = (n12 | (n10 = this.g3d.clipCode(n2 + n11, n3 + n11, n4 + n11)) | (n9 = this.g3d.clipCode(n5 - n11, n6 - n11, n7 - n11)) | (n8 = this.g3d.clipCode(n5 + n11, n6 + n11, n7 + n11))) != 0;
        if ((n12 & n8 & n10 & n9) != 0) {
            return;
        }
        this.dxB = n5 - n2;
        this.dyB = n6 - n3;
        this.dzB = n7 - n4;
        if (n <= 1) {
            this.line3d.plotLineDelta(this.g3d.getColorArgbOrGray(s), bl, this.g3d.getColorArgbOrGray(s2), bl2, n2, n3, n4, this.dxB, this.dyB, this.dzB, this.clipped);
            return;
        }
        this.drawBackside = this.clipped || by == 2 || by == 0;
        this.diameter = n;
        this.xA = n2;
        this.yA = n3;
        this.zA = n4;
        this.endcaps = by;
        this.colixA = s;
        this.shadesA = this.g3d.getShades(this.colixA);
        this.colixB = s2;
        this.shadesB = this.g3d.getShades(this.colixB);
        this.calcArgbEndcap(true, false);
        this.generateBaseEllipse();
        if (by == 2 || by == 4) {
            this.renderFlatEndcap(true);
        }
        this.g3d.setZMargin(5);
        int n13 = this.rasterCount;
        while (--n13 >= 0) {
            this.plotRaster(n13);
        }
        this.g3d.setZMargin(0);
        if (by == 3) {
            this.renderSphericalEndcaps();
        }
    }

    private void generateBaseEllipse() {
        this.tEvenDiameter = (this.diameter & 1) == 0;
        this.radius = (float)this.diameter / 2.0f;
        this.radius2 = this.radius * this.radius;
        int n = this.dxB * this.dxB + this.dyB * this.dyB;
        if (n == 0) {
            this.cosTheta = 1.0f;
            this.cosPhi = 1.0f;
            this.sinPhi = 0.0f;
        } else {
            float f = (float)Math.sqrt(n);
            float f2 = (float)Math.sqrt(n + this.dzB * this.dzB);
            this.cosTheta = (float)this.dzB / f2;
            this.cosPhi = (float)this.dxB / f;
            this.sinPhi = (float)this.dyB / f;
        }
        this.calcRotatedPoint(0.0f, 0, false);
        this.calcRotatedPoint(0.5f, 1, false);
        this.calcRotatedPoint(1.0f, 2, false);
        this.rasterCount = 3;
        this.interpolate(0, 1);
        this.interpolate(1, 2);
    }

    private void calcRotatedPoint(float f, int n, boolean bl) {
        double d;
        double d2;
        double d3;
        this.tRaster[n] = f;
        double d4 = (double)f * Math.PI;
        double d5 = Math.sin(d4) * (double)this.cosTheta;
        double d6 = (double)this.radius * (d5 * (double)this.cosPhi - (d3 = Math.cos(d4)) * (double)this.sinPhi);
        double d7 = (double)this.radius2 - (d6 * d6 + (d2 = (double)this.radius * (d5 * (double)this.sinPhi + d3 * (double)this.cosPhi)) * d2);
        double d8 = d = d7 > 0.0 ? Math.sqrt(d7) : 0.0;
        if (bl) {
            this.txRaster[n] = (float)d6;
            this.tyRaster[n] = (float)d2;
            this.tzRaster[n] = (float)d;
        } else if (this.tEvenDiameter) {
            this.xRaster[n] = (int)(d6 - 0.5);
            this.yRaster[n] = (int)(d2 - 0.5);
            this.zRaster[n] = (int)(d + 0.5);
        } else {
            this.xRaster[n] = (int)d6;
            this.yRaster[n] = (int)d2;
            this.zRaster[n] = (int)(d + 0.5);
        }
        this.fp8ShadeIndexUp[n] = Shade3D.getFp8ShadeIndex((float)d6, (float)d2, (float)d);
    }

    private void interpolate(int n, int n2) {
        int n3;
        int n4 = this.xRaster[n2] - this.xRaster[n];
        if (n4 < 0) {
            n4 = -n4;
        }
        if ((n3 = this.yRaster[n2] - this.yRaster[n]) < 0) {
            n3 = -n3;
        }
        if (n4 + n3 <= 1) {
            return;
        }
        float f = this.tRaster[n];
        float f2 = this.tRaster[n2];
        int n5 = this.allocRaster(false);
        int n6 = 4;
        while (--n6 >= 0) {
            float f3 = (f + f2) / 2.0f;
            this.calcRotatedPoint(f3, n5, false);
            if (this.xRaster[n5] == this.xRaster[n] && this.yRaster[n5] == this.yRaster[n]) {
                this.fp8ShadeIndexUp[n] = this.fp8ShadeIndexUp[n] + this.fp8ShadeIndexUp[n5] >>> 1;
                f = f3;
                continue;
            }
            if (this.xRaster[n5] == this.xRaster[n2] && this.yRaster[n5] == this.yRaster[n2]) {
                this.fp8ShadeIndexUp[n2] = this.fp8ShadeIndexUp[n2] + this.fp8ShadeIndexUp[n5] >>> 1;
                f2 = f3;
                continue;
            }
            this.interpolate(n, n5);
            this.interpolate(n5, n2);
            return;
        }
        this.xRaster[n5] = this.xRaster[n];
        this.yRaster[n5] = this.yRaster[n2];
    }

    private void plotRaster(int n) {
        int n2 = this.fp8ShadeIndexUp[n] >> 8;
        int n3 = n2 >> 1;
        int n4 = this.xRaster[n];
        int n5 = this.yRaster[n];
        int n6 = this.zRaster[n];
        if (this.tEndcapOpen && this.argbEndcap != 0) {
            if (this.clipped) {
                this.g3d.plotPixelClipped(this.argbEndcap, this.xEndcap + n4, this.yEndcap + n5, this.zEndcap - n6 - 1);
                this.g3d.plotPixelClipped(this.argbEndcap, this.xEndcap - n4, this.yEndcap - n5, this.zEndcap + n6 - 1);
            } else {
                this.g3d.plotPixelUnclipped(this.argbEndcap, this.xEndcap + n4, this.yEndcap + n5, this.zEndcap - n6 - 1);
                this.g3d.plotPixelUnclipped(this.argbEndcap, this.xEndcap - n4, this.yEndcap - n5, this.zEndcap + n6 - 1);
            }
        }
        this.line3d.plotLineDelta(this.shadesA, this.isScreenedA, this.shadesB, this.isScreenedB, n2, this.xA + n4, this.yA + n5, this.zA - n6, this.dxB, this.dyB, this.dzB, this.clipped);
        if (this.drawBackside) {
            this.line3d.plotLineDelta(this.shadesA[n3], this.isScreenedA, this.shadesB[n3], this.isScreenedB, this.xA - n4, this.yA - n5, this.zA + n6, this.dxB, this.dyB, this.dzB, this.clipped);
        }
    }

    private int[] realloc(int[] nArray) {
        int[] nArray2 = new int[nArray.length * 2];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    private float[] realloc(float[] fArray) {
        float[] fArray2 = new float[fArray.length * 2];
        System.arraycopy(fArray, 0, fArray2, 0, fArray.length);
        return fArray2;
    }

    private int allocRaster(boolean bl) {
        while (this.rasterCount >= this.xRaster.length) {
            this.xRaster = this.realloc(this.xRaster);
            this.yRaster = this.realloc(this.yRaster);
            this.zRaster = this.realloc(this.zRaster);
            this.tRaster = this.realloc(this.tRaster);
        }
        while (this.rasterCount >= this.fp8ShadeIndexUp.length) {
            this.fp8ShadeIndexUp = this.realloc(this.fp8ShadeIndexUp);
        }
        if (bl) {
            while (this.rasterCount >= this.txRaster.length) {
                this.txRaster = this.realloc(this.txRaster);
                this.tyRaster = this.realloc(this.tyRaster);
                this.tzRaster = this.realloc(this.tzRaster);
            }
        }
        return this.rasterCount++;
    }

    private void findMinMaxY() {
        this.yMin = this.yMax = this.yRaster[0];
        int n = this.rasterCount;
        while (--n > 0) {
            int n2 = this.yRaster[n];
            if (n2 < this.yMin) {
                this.yMin = n2;
                continue;
            }
            if (n2 > this.yMax) {
                this.yMax = n2;
                continue;
            }
            if ((n2 = -n2) < this.yMin) {
                this.yMin = n2;
                continue;
            }
            if (n2 <= this.yMax) continue;
            this.yMax = n2;
        }
    }

    private void findMinMaxX(int n) {
        this.xMin = Integer.MAX_VALUE;
        this.xMax = Integer.MIN_VALUE;
        int n2 = this.rasterCount;
        while (--n2 >= 0) {
            int n3;
            if (this.yRaster[n2] == n) {
                n3 = this.xRaster[n2];
                if (n3 < this.xMin) {
                    this.xMin = n3;
                    this.zXMin = this.zRaster[n2];
                }
                if (n3 > this.xMax) {
                    this.xMax = n3;
                    this.zXMax = this.zRaster[n2];
                }
            }
            if (this.yRaster[n2] != -n) continue;
            n3 = -this.xRaster[n2];
            if (n3 < this.xMin) {
                this.xMin = n3;
                this.zXMin = -this.zRaster[n2];
            }
            if (n3 <= this.xMax) continue;
            this.xMax = n3;
            this.zXMax = -this.zRaster[n2];
        }
    }

    private void renderFlatEndcap(boolean bl) {
        if (this.dzB == 0 || !this.g3d.setColix(this.colixEndcap)) {
            return;
        }
        int n = this.xA;
        int n2 = this.yA;
        int n3 = this.zA;
        if (bl && this.dzB < 0) {
            if (this.endcaps == 4) {
                return;
            }
            n += this.dxB;
            n2 += this.dyB;
            n3 += this.dzB;
        }
        this.findMinMaxY();
        for (int i = this.yMin; i <= this.yMax; ++i) {
            this.findMinMaxX(i);
            int n4 = this.xMax - this.xMin + 1;
            this.g3d.setColorNoisy(this.endcapShadeIndex);
            this.g3d.plotPixelsClipped(n4, n + this.xMin, n2 + i, n3 - this.zXMin - 1, n3 - this.zXMax - 1, null, null);
        }
    }

    private void renderSphericalEndcaps() {
        if (this.colixA != 0 && this.g3d.setColix(this.colixA)) {
            this.g3d.fillSphere(this.diameter, this.xA, this.yA, this.zA + 1);
        }
        if (this.colixB != 0 && this.g3d.setColix(this.colixB)) {
            this.g3d.fillSphere(this.diameter, this.xA + this.dxB, this.yA + this.dyB, this.zA + this.dzB + 1);
        }
    }

    private void calcArgbEndcap(boolean bl, boolean bl2) {
        int[] nArray;
        float f;
        float f2;
        this.tEndcapOpen = false;
        float f3 = f2 = bl2 ? this.dzBf : (float)this.dzB;
        if (this.endcaps == 3 || f2 == 0.0f) {
            return;
        }
        this.xEndcap = this.xA;
        this.yEndcap = this.yA;
        this.zEndcap = this.zA;
        float f4 = bl2 ? this.dxBf : (float)this.dxB;
        float f5 = f = bl2 ? this.dyBf : (float)this.dyB;
        if (f2 >= 0.0f || !bl) {
            this.endcapShadeIndex = Shade3D.getShadeIndex(-f4, -f, f2);
            this.colixEndcap = this.colixA;
            nArray = this.shadesA;
        } else {
            this.endcapShadeIndex = Shade3D.getShadeIndex(f4, f, -f2);
            this.colixEndcap = this.colixB;
            nArray = this.shadesB;
            this.xEndcap += this.dxB;
            this.yEndcap += this.dyB;
            this.zEndcap += this.dzB;
        }
        if (this.endcapShadeIndex > 56) {
            this.endcapShadeIndex = 56;
        }
        this.argbEndcap = nArray[this.endcapShadeIndex];
        this.tEndcapOpen = this.endcaps == 1;
    }
}

