/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.Map;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProteinStructure {
    static int globalSerialID = 1000;
    AlphaPolymer apolymer;
    byte type;
    byte subtype;
    int monomerIndexFirst;
    int monomerIndexLast;
    int monomerCount;
    Point3f axisA;
    Point3f axisB;
    Vector3f axisUnitVector;
    final Vector3f vectorProjection = new Vector3f();
    Point3f[] segments;
    int uniqueID = ++globalSerialID;
    String structureID;
    int serialID;
    int strandCount;

    ProteinStructure(AlphaPolymer alphaPolymer, byte by, int n, int n2, int n3) {
        this.apolymer = alphaPolymer;
        this.type = by;
        this.monomerIndexFirst = n;
        this.addMonomer(n + n2 - 1);
        if (Logger.debugging) {
            Logger.debug("Creating ProteinStructure " + this.uniqueID + " " + JmolConstants.getProteinStructureName(by, false) + " from " + this.monomerIndexFirst + " through " + this.monomerIndexLast + " in polymer " + alphaPolymer);
        }
    }

    void addMonomer(int n) {
        this.monomerIndexFirst = Math.min(this.monomerIndexFirst, n);
        this.monomerIndexLast = Math.max(this.monomerIndexLast, n);
        this.monomerCount = this.monomerIndexLast - this.monomerIndexFirst + 1;
    }

    int removeMonomer(int n) {
        if (n > this.monomerIndexLast || n < this.monomerIndexFirst) {
            return 0;
        }
        int n2 = this.monomerIndexLast - n;
        this.monomerIndexLast = Math.max(this.monomerIndexFirst, n) - 1;
        this.monomerCount = this.monomerIndexLast - this.monomerIndexFirst + 1;
        return n2;
    }

    public void calcAxis() {
    }

    boolean lowerNeighborIsHelixOrSheet() {
        if (this.monomerIndexFirst == 0) {
            return false;
        }
        return this.apolymer.monomers[this.monomerIndexFirst - 1].isHelix() || this.apolymer.monomers[this.monomerIndexFirst - 1].isSheet();
    }

    boolean upperNeighborIsHelixOrSheet() {
        int n = this.monomerIndexFirst + this.monomerCount;
        if (n == this.apolymer.monomerCount) {
            return false;
        }
        return this.apolymer.monomers[n].isHelix() || this.apolymer.monomers[n].isSheet();
    }

    public boolean isWithin(int n) {
        return n > this.monomerIndexFirst && n < this.monomerIndexLast;
    }

    public void getInfo(Map<String, Object> map) {
        map.put("type", JmolConstants.getProteinStructureName(this.type, false));
        int[] nArray = this.apolymer.getLeadAtomIndices();
        int[] nArray2 = new int[this.monomerCount];
        System.arraycopy(nArray, this.monomerIndexFirst, nArray2, 0, this.monomerCount);
        map.put("leadAtomIndices", nArray2);
        this.calcAxis();
        if (this.axisA == null) {
            return;
        }
        map.put("axisA", this.axisA);
        map.put("axisB", this.axisB);
        map.put("axisUnitVector", this.axisUnitVector);
    }

    void resetAxes() {
        this.axisA = null;
        this.segments = null;
    }
}

