/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import java.util.Hashtable;
import org.jmol.atomdata.RadiusData;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.shape.Shape;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.viewer.JmolConstants;

public abstract class AtomShape
extends Shape {
    public short[] mads;
    public short[] colixes;
    public byte[] paletteIDs;
    protected BitSet bsSizeSet;
    protected BitSet bsColixSet;
    public int atomCount;
    public Atom[] atoms;
    public boolean isActive;

    protected void initModelSet() {
        this.atoms = this.modelSet.atoms;
        this.atomCount = this.modelSet.getAtomCount();
        if (this.mads != null) {
            this.mads = ArrayUtil.setLength(this.mads, this.atomCount);
        }
        if (this.colixes != null) {
            this.colixes = ArrayUtil.setLength(this.colixes, this.atomCount);
        }
        if (this.paletteIDs != null) {
            this.paletteIDs = ArrayUtil.setLength(this.paletteIDs, this.atomCount);
        }
    }

    public int getSize(int n) {
        return this.mads == null ? 0 : this.mads[n];
    }

    protected void setSize(int n, BitSet bitSet) {
        if (n == 0) {
            this.setSize(null, bitSet);
        } else {
            this.setSize(new RadiusData(n, 3, 0), bitSet);
        }
    }

    protected void setSize(RadiusData radiusData, BitSet bitSet) {
        int n;
        if (this.atoms == null) {
            return;
        }
        this.isActive = true;
        if (this.bsSizeSet == null) {
            this.bsSizeSet = new BitSet();
        }
        boolean bl = radiusData != null && radiusData.value != 0.0f;
        boolean bl2 = bitSet == null;
        int n2 = n = bl2 ? this.atomCount - 1 : bitSet.nextSetBit(0);
        if (this.mads == null && n >= 0) {
            this.mads = new short[this.atomCount];
        }
        int n3 = n;
        while (n3 >= 0) {
            Atom atom = this.atoms[n3];
            this.mads[n3] = atom.calculateMad(this.viewer, radiusData);
            this.bsSizeSet.set(n3, bl);
            atom.setShapeVisibility(this.myVisibilityFlag, bl);
            n3 = bl2 ? n3 - 1 : bitSet.nextSetBit(n3 + 1);
        }
    }

    public void setProperty(String string, Object object, BitSet bitSet) {
        if ("color" == string) {
            this.isActive = true;
            short s = Graphics3D.getColix(object);
            byte by = JmolConstants.pidOf(object);
            if (this.bsColixSet == null) {
                this.bsColixSet = new BitSet();
            }
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                this.setColixAndPalette(s, by, n);
                n = bitSet.nextSetBit(n + 1);
            }
            return;
        }
        if ("translucency" == string) {
            this.isActive = true;
            boolean bl = object.equals("translucent");
            if (this.bsColixSet == null) {
                this.bsColixSet = new BitSet();
            }
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                if (this.colixes == null) {
                    this.colixes = new short[this.atomCount];
                    this.paletteIDs = new byte[this.atomCount];
                }
                this.colixes[n] = Graphics3D.getColixTranslucent(this.colixes[n], bl, this.translucentLevel);
                if (bl) {
                    this.bsColixSet.set(n);
                }
                n = bitSet.nextSetBit(n + 1);
            }
            return;
        }
        if (string == "deleteModelAtoms") {
            this.atoms = (Atom[])((Object[])object)[1];
            int[] nArray = (int[])((Object[])object)[2];
            this.atomCount = this.modelSet.getAtomCount();
            int n = nArray[1];
            int n2 = nArray[2];
            this.mads = (short[])ArrayUtil.deleteElements(this.mads, n, n2);
            this.colixes = (short[])ArrayUtil.deleteElements(this.colixes, n, n2);
            this.paletteIDs = (byte[])ArrayUtil.deleteElements(this.paletteIDs, n, n2);
            BitSetUtil.deleteBits(this.bsSizeSet, bitSet);
            BitSetUtil.deleteBits(this.bsColixSet, bitSet);
            return;
        }
        super.setProperty(string, object, bitSet);
    }

    protected void setColixAndPalette(short s, byte by, int n) {
        if (this.colixes == null || n >= this.colixes.length) {
            if (s == 0) {
                return;
            }
            this.colixes = ArrayUtil.ensureLength(this.colixes, n + 1);
            this.paletteIDs = ArrayUtil.ensureLength(this.paletteIDs, n + 1);
        }
        if (this.bsColixSet == null) {
            this.bsColixSet = new BitSet();
        }
        this.colixes[n] = s = this.setColix(s, by, n);
        this.bsColixSet.set(n, s != 0);
        this.paletteIDs[n] = by;
    }

    public void setModelClickability() {
        if (!this.isActive) {
            return;
        }
        int n = this.atomCount;
        while (--n >= 0) {
            Atom atom = this.atoms[n];
            if ((atom.getShapeVisibilityFlags() & this.myVisibilityFlag) == 0 || this.modelSet.isAtomHidden(n)) continue;
            atom.setClickable(this.myVisibilityFlag);
        }
    }

    public String getShapeState() {
        int n;
        if (!this.isActive) {
            return "";
        }
        Hashtable<String, BitSet> hashtable = new Hashtable<String, BitSet>();
        Hashtable<String, BitSet> hashtable2 = new Hashtable<String, BitSet>();
        String string = JmolConstants.shapeClassBases[this.shapeID];
        if (this.bsSizeSet != null) {
            n = this.bsSizeSet.nextSetBit(0);
            while (n >= 0) {
                AtomShape.setStateInfo(hashtable, n, string + (this.mads[n] < 0 ? " on" : " " + (float)this.mads[n] / 2000.0f));
                n = this.bsSizeSet.nextSetBit(n + 1);
            }
        }
        if (this.bsColixSet != null) {
            n = this.bsColixSet.nextSetBit(0);
            while (n >= 0) {
                AtomShape.setStateInfo(hashtable2, n, this.getColorCommand(string, this.paletteIDs[n], this.colixes[n]));
                n = this.bsColixSet.nextSetBit(n + 1);
            }
        }
        return AtomShape.getShapeCommands(hashtable, hashtable2);
    }
}

