/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayUtil {
    public static Object ensureLength(Object object, int n) {
        if (object != null && Array.getLength(object) >= n) {
            return object;
        }
        return ArrayUtil.setLength(object, n);
    }

    public static float[] ensureLength(float[] fArray, int n) {
        if (fArray != null && fArray.length >= n) {
            return fArray;
        }
        return ArrayUtil.setLength(fArray, n);
    }

    public static short[] ensureLength(short[] sArray, int n) {
        if (sArray != null && sArray.length >= n) {
            return sArray;
        }
        return ArrayUtil.setLength(sArray, n);
    }

    public static byte[] ensureLength(byte[] byArray, int n) {
        if (byArray != null && byArray.length >= n) {
            return byArray;
        }
        return ArrayUtil.setLength(byArray, n);
    }

    public static Object doubleLength(Object object) {
        return ArrayUtil.setLength(object, object == null ? 16 : 2 * Array.getLength(object));
    }

    public static String[] doubleLength(String[] stringArray) {
        return ArrayUtil.setLength(stringArray, stringArray == null ? 16 : 2 * stringArray.length);
    }

    public static float[] doubleLength(float[] fArray) {
        return ArrayUtil.setLength(fArray, fArray == null ? 16 : 2 * fArray.length);
    }

    public static int[] doubleLength(int[] nArray) {
        return ArrayUtil.setLength(nArray, nArray == null ? 16 : 2 * nArray.length);
    }

    public static Object setLength(Object object, int n) {
        if (object == null) {
            return null;
        }
        int n2 = Array.getLength(object);
        if (n == n2) {
            return object;
        }
        Object object2 = Array.newInstance(object.getClass().getComponentType(), n);
        System.arraycopy(object, 0, object2, 0, n2 < n ? n2 : n);
        return object2;
    }

    public static Object deleteElements(Object object, int n, int n2) {
        if (n2 == 0 || object == null) {
            return object;
        }
        int n3 = Array.getLength(object);
        if (n >= n3) {
            return object;
        }
        int n4 = n3 - (n + n2);
        if (n4 < 0) {
            n4 = 0;
        }
        Object object2 = Array.newInstance(object.getClass().getComponentType(), n + n4);
        if (n > 0) {
            System.arraycopy(object, 0, object2, 0, n);
        }
        if (n4 > 0) {
            System.arraycopy(object, n + n2, object2, n, n4);
        }
        return object2;
    }

    public static String[] setLength(String[] stringArray, int n) {
        String[] stringArray2 = new String[n];
        if (stringArray != null) {
            int n2 = stringArray.length;
            System.arraycopy(stringArray, 0, stringArray2, 0, n2 < n ? n2 : n);
        }
        return stringArray2;
    }

    public static float[] setLength(float[] fArray, int n) {
        float[] fArray2 = new float[n];
        if (fArray != null) {
            int n2 = fArray.length;
            System.arraycopy(fArray, 0, fArray2, 0, n2 < n ? n2 : n);
        }
        return fArray2;
    }

    public static int[] setLength(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        if (nArray != null) {
            int n2 = nArray.length;
            System.arraycopy(nArray, 0, nArray2, 0, n2 < n ? n2 : n);
        }
        return nArray2;
    }

    public static int[] arrayCopy(int[] nArray, int n, int n2, boolean bl) {
        if (nArray == null) {
            return null;
        }
        int n3 = nArray.length;
        if (n2 == -1) {
            n2 = n3;
        }
        if (n2 == -2) {
            n2 = n3 / 2;
        }
        int[] nArray2 = new int[n2 -= n];
        System.arraycopy(nArray, n, nArray2, 0, n2);
        if (bl) {
            int n4 = n2 / 2;
            while (--n4 >= 0) {
                ArrayUtil.swap(nArray2, n4, n2 - 1 - n4);
            }
        }
        return nArray2;
    }

    public static short[] setLength(short[] sArray, int n) {
        short[] sArray2 = new short[n];
        if (sArray != null) {
            int n2 = sArray.length;
            System.arraycopy(sArray, 0, sArray2, 0, n2 < n ? n2 : n);
        }
        return sArray2;
    }

    public static byte[] setLength(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        if (byArray != null) {
            int n2 = byArray.length;
            System.arraycopy(byArray, 0, byArray2, 0, n2 < n ? n2 : n);
        }
        return byArray2;
    }

    public static void swap(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }

    public static <T> List<T>[] createArrayOfArrayList(int n) {
        return new ArrayList[n];
    }
}

