/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jmol.util.Logger;

public class BinaryDocument {
    protected DataInputStream stream;
    protected boolean isRandom = false;
    protected boolean isBigEndian = true;
    long nBytes;
    OutputStream os;

    public BinaryDocument() {
    }

    public BinaryDocument(BufferedInputStream bufferedInputStream) {
        this.setStream(bufferedInputStream, false);
    }

    public void close() {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.os != null) {
            try {
                this.os.flush();
                this.os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setStream(BufferedInputStream bufferedInputStream, boolean bl) {
        if (bufferedInputStream == null) {
            return;
        }
        this.stream = new DataInputStream(bufferedInputStream);
        this.isBigEndian = bl;
    }

    public byte readByte() throws Exception {
        ++this.nBytes;
        return this.ioReadByte();
    }

    private byte ioReadByte() throws Exception {
        byte by = this.stream.readByte();
        if (this.os != null) {
            this.os.write(by);
        }
        return by;
    }

    public void readByteArray(byte[] byArray) throws Exception {
        this.readByteArray(byArray, 0, byArray.length);
    }

    public int readByteArray(byte[] byArray, int n, int n2) throws Exception {
        int n3 = this.ioRead(byArray, n, n2);
        if (n3 > 0) {
            this.nBytes += (long)n3;
        }
        int n4 = n3;
        if (n3 > 0 && n3 < n2) {
            while (n4 < n2 && n3 > 0) {
                n3 = this.ioRead(byArray, n4, n2 - n4);
                if (n3 <= 0) continue;
                this.nBytes += (long)n3;
                n4 += n3;
            }
        }
        return n4;
    }

    private int ioRead(byte[] byArray, int n, int n2) throws Exception {
        int n3 = this.stream.read(byArray, n, n2);
        if (n3 > 0 && this.os != null) {
            this.writeBytes(byArray, n, n3);
        }
        return n3;
    }

    public void writeBytes(byte[] byArray, int n, int n2) throws Exception {
        this.os.write(byArray, n, n2);
    }

    public short readShort() throws Exception {
        this.nBytes += 2L;
        return this.isBigEndian ? this.ioReadShort() : (short)(this.ioReadByte() & 0xFF | (this.ioReadByte() & 0xFF) << 8);
    }

    private short ioReadShort() throws Exception {
        short s = this.stream.readShort();
        if (this.os != null) {
            this.writeShort(s);
        }
        return s;
    }

    public void writeShort(short s) throws Exception {
        this.os.write((byte)(s >> 8 & 0xFF));
        this.os.write((byte)(s & 0xFF));
    }

    public int readInt() throws Exception {
        this.nBytes += 4L;
        return this.isBigEndian ? this.ioReadInt() : this.readLEInt();
    }

    private int ioReadInt() throws Exception {
        int n = this.stream.readInt();
        if (this.os != null) {
            this.writeInt(n);
        }
        return n;
    }

    public void writeInt(int n) throws Exception {
        this.os.write((byte)(n >> 24 & 0xFF));
        this.os.write((byte)(n >> 16 & 0xFF));
        this.os.write((byte)(n >> 8 & 0xFF));
        this.os.write((byte)(n & 0xFF));
    }

    public long readLong() throws Exception {
        this.nBytes += 8L;
        return this.isBigEndian ? this.ioReadLong() : (long)this.ioReadByte() & 0xFFL | ((long)this.ioReadByte() & 0xFFL) << 8 | ((long)this.ioReadByte() & 0xFFL) << 16 | ((long)this.ioReadByte() & 0xFFL) << 24 | ((long)this.ioReadByte() & 0xFFL) << 32 | ((long)this.ioReadByte() & 0xFFL) << 40 | ((long)this.ioReadByte() & 0xFFL) << 48 | ((long)this.ioReadByte() & 0xFFL) << 54;
    }

    private long ioReadLong() throws Exception {
        long l = this.stream.readLong();
        if (this.os != null) {
            this.writeLong(l);
        }
        return l;
    }

    public void writeLong(long l) throws Exception {
        this.writeInt((int)(l >> 32 & 0xFFFFFFFFL));
        this.writeInt((int)(l & 0xFFFFFFFFL));
    }

    private int readLEInt() throws Exception {
        return this.ioReadByte() & 0xFF | (this.ioReadByte() & 0xFF) << 8 | (this.ioReadByte() & 0xFF) << 16 | (this.ioReadByte() & 0xFF) << 24;
    }

    public void seek(long l) {
        try {
            if (l == this.nBytes) {
                return;
            }
            if (l < this.nBytes) {
                this.stream.reset();
                this.nBytes = 0L;
            } else {
                l -= this.nBytes;
            }
            this.stream.skipBytes((int)l);
            this.nBytes += l;
        }
        catch (Exception exception) {
            Logger.error(null, exception);
        }
    }
}

