/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.BitSet;

public final class BitSetUtil {
    public static final BitSet bsNull = new BitSet();

    public static BitSet setBit(int n) {
        BitSet bitSet = new BitSet(n + 1);
        bitSet.set(n);
        return bitSet;
    }

    public static int cardinalityOf(BitSet bitSet) {
        return bitSet == null ? 0 : bitSet.cardinality();
    }

    public static BitSet newBitSet(int n, int n2) {
        BitSet bitSet = new BitSet(n2);
        bitSet.set(n, n2);
        return bitSet;
    }

    public static BitSet setAll(int n) {
        BitSet bitSet = new BitSet(n);
        bitSet.set(0, n);
        return bitSet;
    }

    public static BitSet andNot(BitSet bitSet, BitSet bitSet2) {
        if (bitSet2 != null) {
            bitSet.andNot(bitSet2);
        }
        return bitSet;
    }

    public static BitSet copy(BitSet bitSet) {
        return bitSet == null ? null : (BitSet)bitSet.clone();
    }

    public static BitSet copy(BitSet bitSet, BitSet bitSet2) {
        if (bitSet == null || bitSet2 == null) {
            return null;
        }
        bitSet2.clear();
        bitSet2.or(bitSet);
        return bitSet2;
    }

    public static BitSet copyInvert(BitSet bitSet, int n) {
        return bitSet == null ? null : BitSetUtil.andNot(BitSetUtil.setAll(n), bitSet);
    }

    public static BitSet invertInPlace(BitSet bitSet, int n) {
        return BitSetUtil.copy(BitSetUtil.copyInvert(bitSet, n), bitSet);
    }

    public static BitSet toggleInPlace(BitSet bitSet, BitSet bitSet2) {
        if (bitSet.equals(bitSet2)) {
            bitSet.clear();
        } else if (BitSetUtil.andNot(BitSetUtil.copy(bitSet2), bitSet).length() == 0) {
            BitSetUtil.andNot(bitSet, bitSet2);
        } else {
            bitSet.or(bitSet2);
        }
        return bitSet;
    }

    public static BitSet deleteBits(BitSet bitSet, BitSet bitSet2) {
        if (bitSet == null || bitSet2 == null) {
            return bitSet;
        }
        int n = bitSet2.nextSetBit(0);
        if (n < 0) {
            return bitSet;
        }
        int n2 = bitSet.length();
        int n3 = Math.min(n2, bitSet2.length());
        int n4 = bitSet2.nextClearBit(n);
        while (n4 < n3 && n4 >= 0) {
            bitSet.set(n++, bitSet.get(n4));
            n4 = bitSet2.nextClearBit(n4 + 1);
        }
        for (n4 = n3; n4 < n2; ++n4) {
            bitSet.set(n++, bitSet.get(n4));
        }
        if (n < n2) {
            bitSet.clear(n, n2);
        }
        return bitSet;
    }
}

