/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.BitSet;
import org.jmol.util.Escape;

public class FastBitSet
implements Cloneable {
    private int[] bitmap;
    private static final int[] emptyBitmap = new int[0];
    public static final FastBitSet emptySet = new FastBitSet();

    public FastBitSet() {
        this.bitmap = emptyBitmap;
    }

    private FastBitSet(int n) {
        this.bitmap = new int[FastBitSet.getWordCountFromBitCount(n)];
    }

    public FastBitSet(FastBitSet fastBitSet) {
        int n = FastBitSet.bitmapGetMinimumWordCount(fastBitSet.bitmap);
        if (n == 0) {
            this.bitmap = emptyBitmap;
        } else {
            this.bitmap = new int[n];
            System.arraycopy(fastBitSet.bitmap, 0, this.bitmap, 0, n);
        }
    }

    public static final FastBitSet getEmptySet() {
        return emptySet;
    }

    public static FastBitSet allocateBitmap(int n) {
        return new FastBitSet(n);
    }

    public int cardinality(int n) {
        int n2 = FastBitSet.bitmapGetCardinality(this.bitmap);
        int n3 = this.length();
        while (--n3 >= n) {
            if (!this.get(n3)) continue;
            --n2;
        }
        return n2;
    }

    public void clear() {
        FastBitSet.bitmapClear(this.bitmap);
    }

    public void clear(int n) {
        if (n >> 5 < this.bitmap.length) {
            FastBitSet.bitmapClearBit(this.bitmap, n);
        }
    }

    public Object clone() {
        int n = FastBitSet.bitmapGetSizeInBits(this.bitmap);
        FastBitSet fastBitSet = new FastBitSet(n);
        System.arraycopy(this.bitmap, 0, fastBitSet.bitmap, 0, this.bitmap.length);
        return fastBitSet;
    }

    public boolean equals(Object object) {
        return object instanceof FastBitSet && FastBitSet.bitmapIsEqual(this.bitmap, ((FastBitSet)object).bitmap);
    }

    public boolean get(int n) {
        return n < FastBitSet.bitmapGetSizeInBits(this.bitmap) && FastBitSet.bitmapGetBit(this.bitmap, n);
    }

    public boolean isEmpty() {
        return FastBitSet.bitmapIsEmpty(this.bitmap);
    }

    public int length() {
        int n = FastBitSet.bitmapGetMinimumWordCount(this.bitmap);
        return n == 0 ? 0 : (n << 5) - FastBitSet.numberOfLeadingZeros(this.bitmap[n - 1]);
    }

    public void set(int n) {
        this.bitmap = FastBitSet.ensureSufficientBits(this.bitmap, n + 1);
        FastBitSet.bitmapSetBit(this.bitmap, n);
    }

    public void set(int n, int n2) {
        this.bitmap = FastBitSet.ensureSufficientBits(this.bitmap, n2);
        FastBitSet.bitmapSetRange(this.bitmap, n, n2 - n);
    }

    public int size() {
        return FastBitSet.bitmapGetSizeInBits(this.bitmap);
    }

    public BitSet toBitSet() {
        BitSet bitSet = new BitSet();
        int n = FastBitSet.bitmapGetSizeInBits(this.bitmap);
        while (--n >= 0) {
            if (!this.get(n)) continue;
            bitSet.set(n);
        }
        return bitSet;
    }

    public String toString() {
        return Escape.escape(this.toBitSet());
    }

    public int hashCode() {
        long l = 1234L;
        int n = this.bitmap.length;
        while (--n >= 0) {
            l ^= (long)(this.bitmap[n] * (n + 1));
        }
        return (int)(l >> 32 ^ l);
    }

    private static final boolean bitmapGetBit(int[] nArray, int n) {
        return (nArray[n >> 5] >> (n & 0x1F) & 1) != 0;
    }

    private static final void bitmapSetBit(int[] nArray, int n) {
        int n2 = n >> 5;
        nArray[n2] = nArray[n2] | 1 << (n & 0x1F);
    }

    private static final void bitmapClearBit(int[] nArray, int n) {
        int n2 = n >> 5;
        nArray[n2] = nArray[n2] & ~(1 << (n & 0x1F));
    }

    private static final void bitmapSetRange(int[] nArray, int n, int n2) {
        while ((n & 0x1F) != 0) {
            FastBitSet.bitmapSetBit(nArray, n++);
            if (--n2 != 0) continue;
            return;
        }
        while ((n2 & 0x1F) != 0) {
            FastBitSet.bitmapSetBit(nArray, n + --n2);
        }
        int n3 = n >> 5;
        int n4 = n2 >> 5;
        while (--n4 >= 0) {
            nArray[n3++] = -1;
        }
    }

    private static final void bitmapClear(int[] nArray) {
        int n = nArray.length;
        while (--n >= 0) {
            nArray[n] = 0;
        }
    }

    private static final int bitmapGetMinimumWordCount(int[] nArray) {
        int n = nArray.length;
        while (--n >= 0 && nArray[n] == 0) {
        }
        return n + 1;
    }

    private static final int bitmapGetSizeInBits(int[] nArray) {
        return nArray.length << 5;
    }

    private static final int getWordCountFromBitCount(int n) {
        return n + 32 - 1 >> 5;
    }

    private static final int bitmapGetCardinality(int[] nArray) {
        int n = 0;
        int n2 = nArray.length;
        while (--n2 >= 0) {
            if (nArray[n2] == 0) continue;
            n += FastBitSet.countBitsInWord(nArray[n2]);
        }
        return n;
    }

    private static final int countBitsInWord(int n) {
        n = (n & 0x55555555) + (n >> 1 & 0x55555555);
        n = (n & 0x33333333) + (n >> 2 & 0x33333333);
        n = (n & 0xF0F0F0F) + (n >> 4 & 0xF0F0F0F);
        n = (n & 0xFF00FF) + (n >> 8 & 0xFF00FF);
        n = (n & 0xFFFF) + (n >> 16 & 0xFFFF);
        return n;
    }

    private static final boolean bitmapIsEqual(int[] nArray, int[] nArray2) {
        if (nArray == nArray2) {
            return true;
        }
        int n = FastBitSet.bitmapGetMinimumWordCount(nArray);
        if (n != FastBitSet.bitmapGetMinimumWordCount(nArray2)) {
            return false;
        }
        while (--n >= 0) {
            if (nArray[n] == nArray2[n]) continue;
            return false;
        }
        return true;
    }

    private static final boolean bitmapIsEmpty(int[] nArray) {
        int n = nArray.length;
        while (--n >= 0) {
            if (nArray[n] == 0) continue;
            return false;
        }
        return true;
    }

    private static final int numberOfLeadingZeros(int n) {
        if (n == 0) {
            return 32;
        }
        int n2 = 1;
        if (n >>> 16 == 0) {
            n2 += 16;
            n <<= 16;
        }
        if (n >>> 24 == 0) {
            n2 += 8;
            n <<= 8;
        }
        if (n >>> 28 == 0) {
            n2 += 4;
            n <<= 4;
        }
        if (n >>> 30 == 0) {
            n2 += 2;
            n <<= 2;
        }
        return n2 -= n >>> 31;
    }

    private static final int[] ensureSufficientBits(int[] nArray, int n) {
        return FastBitSet.ensureSufficientWords(nArray, n + 31 >> 5);
    }

    private static final int[] ensureSufficientWords(int[] nArray, int n) {
        if (n > nArray.length) {
            int[] nArray2 = new int[n];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            return nArray2;
        }
        return nArray;
    }
}

