/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.text.DecimalFormat;
import java.util.List;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import org.jmol.util.Parser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextFormat {
    private static final DecimalFormat[] formatters = new DecimalFormat[10];
    private static final String[] formattingStrings = new String[]{"0", "0.0", "0.00", "0.000", "0.0000", "0.00000", "0.000000", "0.0000000", "0.00000000", "0.000000000"};
    private static final Boolean[] useNumberLocalization = new Boolean[1];

    public static void setUseNumberLocalization(boolean bl) {
        TextFormat.useNumberLocalization[0] = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public static String formatDecimal(float f, int n) {
        DecimalFormat decimalFormat;
        if (n == Integer.MAX_VALUE) {
            return "" + f;
        }
        if (n < 0) {
            double d;
            if ((n = -n) > formattingStrings.length) {
                n = formattingStrings.length;
            }
            if (f == 0.0f) {
                return formattingStrings[n] + "E+0";
            }
            int n2 = 0;
            if (Math.abs(f) < 1.0f) {
                n2 = 10;
                d = (double)f * 1.0E-10;
            } else {
                n2 = -10;
                d = (double)f * 1.0E10;
            }
            String string = ("" + d).toUpperCase();
            int n3 = string.indexOf("E");
            n2 = Parser.parseInt(string.substring(n3 + 1)) + n2;
            return n3 < 0 ? "" + f : TextFormat.formatDecimal(Parser.parseFloat(string.substring(0, n3)), n - 1) + "E" + (n2 >= 0 ? "+" : "") + n2;
        }
        if (n >= formattingStrings.length) {
            n = formattingStrings.length - 1;
        }
        if ((decimalFormat = formatters[n]) == null) {
            decimalFormat = TextFormat.formatters[n] = new DecimalFormat(formattingStrings[n]);
        }
        String string = decimalFormat.format(f);
        return Boolean.TRUE.equals(useNumberLocalization[0]) ? string : string.replace(',', '.');
    }

    public static String format(float f, int n, int n2, boolean bl, boolean bl2) {
        return TextFormat.format(TextFormat.formatDecimal(f, n2), n, 0, bl, bl2);
    }

    public static String format(double d, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        return TextFormat.format(TextFormat.formatDecimal((float)d, -1 - n2), n, 0, bl, bl2);
    }

    public static String format(String string, int n, int n2, boolean bl, boolean bl2) {
        if (string == null) {
            return "";
        }
        int n3 = string.length();
        if (n2 != Integer.MAX_VALUE && n2 > 0 && n2 < n3) {
            string = string.substring(0, n2);
        } else if (n2 < 0 && n3 + n2 >= 0) {
            string = string.substring(n3 + n2 + 1);
        }
        int n4 = n - string.length();
        if (n4 <= 0) {
            return string;
        }
        boolean bl3 = bl2 && !bl && string.charAt(0) == '-';
        char c = bl2 ? (char)'0' : ' ';
        char c2 = bl3 ? (char)'-' : c;
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append(string);
        }
        stringBuffer.append(c2);
        int n5 = n4;
        while (--n5 > 0) {
            stringBuffer.append(c);
        }
        if (!bl) {
            stringBuffer.append(bl3 ? c + string.substring(1) : string);
        }
        return stringBuffer.toString();
    }

    public static String formatString(String string, String string2, String string3) {
        return TextFormat.formatString(string, string2, string3, Float.NaN, Double.NaN, false);
    }

    public static String formatString(String string, String string2, int n) {
        return TextFormat.formatString(string, string2, "" + n, Float.NaN, Double.NaN, false);
    }

    public static String sprintf(String string, Object[] objectArray) {
        if (objectArray == null) {
            return string;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            int n;
            Object[] objectArray2;
            if (objectArray[i] == null) continue;
            if (objectArray[i] instanceof String) {
                string = TextFormat.formatString(string, "s", (String)objectArray[i], Float.NaN, Double.NaN, true);
                continue;
            }
            if (objectArray[i] instanceof Float) {
                string = TextFormat.formatString(string, "f", null, ((Float)objectArray[i]).floatValue(), Double.NaN, true);
                continue;
            }
            if (objectArray[i] instanceof Integer) {
                string = TextFormat.formatString(string, "d", "" + objectArray[i], Float.NaN, Double.NaN, true);
                string = TextFormat.formatString(string, "i", "" + objectArray[i], Float.NaN, Double.NaN, true);
                continue;
            }
            if (objectArray[i] instanceof Double) {
                string = TextFormat.formatString(string, "e", null, Float.NaN, (Double)objectArray[i], true);
                continue;
            }
            if (objectArray[i] instanceof Point3f) {
                objectArray2 = (Point3f)objectArray[i];
                string = TextFormat.formatString(string, "p", null, objectArray2.x, Double.NaN, true);
                string = TextFormat.formatString(string, "p", null, objectArray2.y, Double.NaN, true);
                string = TextFormat.formatString(string, "p", null, objectArray2.z, Double.NaN, true);
                continue;
            }
            if (objectArray[i] instanceof Point4f) {
                objectArray2 = (Point4f)objectArray[i];
                string = TextFormat.formatString(string, "q", null, objectArray2.x, Double.NaN, true);
                string = TextFormat.formatString(string, "q", null, objectArray2.y, Double.NaN, true);
                string = TextFormat.formatString(string, "q", null, objectArray2.z, Double.NaN, true);
                string = TextFormat.formatString(string, "q", null, objectArray2.w, Double.NaN, true);
                continue;
            }
            if (objectArray[i] instanceof String[]) {
                objectArray2 = (String[])objectArray[i];
                for (n = 0; n < objectArray2.length; ++n) {
                    string = TextFormat.formatString(string, "s", objectArray2[n], Float.NaN, Double.NaN, true);
                }
                continue;
            }
            if (objectArray[i] instanceof float[]) {
                objectArray2 = (float[])objectArray[i];
                for (n = 0; n < objectArray2.length; ++n) {
                    string = TextFormat.formatString(string, "f", null, (float)objectArray2[n], Double.NaN, true);
                }
                continue;
            }
            if (objectArray[i] instanceof double[]) {
                objectArray2 = (double[])objectArray[i];
                for (n = 0; n < objectArray2.length; ++n) {
                    string = TextFormat.formatString(string, "e", null, Float.NaN, (double)objectArray2[n], true);
                }
                continue;
            }
            if (!(objectArray[i] instanceof int[])) continue;
            objectArray2 = (int[])objectArray[i];
            for (n = 0; n < objectArray2.length; ++n) {
                string = TextFormat.formatString(string, "d", "" + (int)objectArray2[n], Float.NaN, Double.NaN, true);
            }
            for (n = 0; n < objectArray2.length; ++n) {
                string = TextFormat.formatString(string, "i", "" + (int)objectArray2[n], Float.NaN, Double.NaN, true);
            }
        }
        return TextFormat.simpleReplace(string, "%%", "%");
    }

    private static String formatString(String string, String string2, String string3, float f, double d, boolean bl) {
        int n;
        int n2;
        if (string == null) {
            return null;
        }
        if ("".equals(string)) {
            return "";
        }
        int n3 = string2.length();
        if (string.indexOf("%") < 0 || n3 == 0 || string.indexOf(string2) < 0) {
            return string;
        }
        String string4 = "";
        int n4 = 0;
        while ((n2 = string.indexOf(37, n4)) >= 0 && (n = string.indexOf(string2, n2 + 1)) >= 0) {
            if (n4 != n2) {
                string4 = string4 + string.substring(n4, n2);
            }
            n4 = n2 + 1;
            if (n > n2 + 6) {
                string4 = string4 + '%';
                continue;
            }
            try {
                String string5;
                char c;
                boolean bl2 = false;
                if (string.charAt(n4) == '-') {
                    bl2 = true;
                    ++n4;
                }
                boolean bl3 = false;
                if (string.charAt(n4) == '0') {
                    bl3 = true;
                    ++n4;
                }
                int n5 = 0;
                while ((c = string.charAt(n4)) >= '0' && c <= '9') {
                    n5 = 10 * n5 + (c - 48);
                    ++n4;
                }
                int n6 = Integer.MAX_VALUE;
                boolean bl4 = false;
                if (string.charAt(n4) == '.') {
                    if ((c = string.charAt(++n4)) == '-') {
                        bl4 = true;
                        ++n4;
                    }
                    if ((c = string.charAt(n4)) >= '0' && c <= '9') {
                        n6 = c - 48;
                        ++n4;
                    }
                    if (bl4) {
                        n6 = -n6 - (string3 == null ? 1 : 0);
                    }
                }
                if (!(string5 = string.substring(n4, n4 + n3)).equals(string2)) {
                    n4 = n2 + 1;
                    string4 = string4 + '%';
                    continue;
                }
                n4 += n3;
                if (!Float.isNaN(f)) {
                    string4 = string4 + TextFormat.format(f, n5, n6, bl2, bl3);
                } else if (string3 != null) {
                    string4 = string4 + TextFormat.format(string3, n5, n6, bl2, bl3);
                } else if (!Double.isNaN(d)) {
                    string4 = string4 + TextFormat.format(d, n5, n6, bl2, bl3, true);
                }
                if (!bl) continue;
                break;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                n4 = n2;
                break;
            }
        }
        string4 = string4 + string.substring(n4);
        return string4;
    }

    public static String formatCheck(String string) {
        if (string == null || string.indexOf(112) < 0 && string.indexOf(113) < 0) {
            return string;
        }
        string = TextFormat.simpleReplace(string, "%%", "\u0001");
        string = TextFormat.simpleReplace(string, "%p", "%6.2p");
        string = TextFormat.simpleReplace(string, "%q", "%6.2q");
        String[] stringArray = TextFormat.split(string, '%');
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            String string2 = "%" + stringArray[i];
            if (string2.length() >= 3) {
                int n = string2.indexOf(112);
                if (n >= 0) {
                    string2 = TextFormat.fdup(string2, n, 3);
                }
                if ((n = string2.indexOf(113)) >= 0) {
                    string2 = TextFormat.fdup(string2, n, 4);
                }
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString().replace('\u0001', '%');
    }

    private static String fdup(String string, int n, int n2) {
        int n3 = 0;
        int n4 = n;
        block4: while (--n4 >= 1) {
            char c = string.charAt(n4);
            if (Character.isDigit(c)) continue;
            switch (c) {
                case '.': {
                    if (n3++ == 0) continue block4;
                    return string;
                }
                case '-': {
                    if (n4 == 1) continue block4;
                    return string;
                }
            }
            return string;
        }
        String string2 = string.substring(0, n + 1);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(string2);
        }
        stringBuffer.append(string.substring(n + 1));
        return stringBuffer.toString();
    }

    public static String[] split(String string, String string2) {
        if (string.length() == 0) {
            return new String[0];
        }
        int n = 1;
        int n2 = string.indexOf(string2);
        int n3 = string2.length();
        if (n2 < 0 || n3 == 0) {
            String[] stringArray = new String[]{string};
            return stringArray;
        }
        int n4 = string.length() - n3;
        while (n2 >= 0 && n2 < n4) {
            n2 = string.indexOf(string2, n2 + n3);
            ++n;
        }
        String[] stringArray = new String[n];
        n2 = 0;
        int n5 = 0;
        int n6 = 0;
        while ((n5 = string.indexOf(string2, n2)) >= 0 && n6 + 1 < n) {
            stringArray[n6++] = string.substring(n2, n5);
            n2 = n5 + n3;
        }
        if (string.indexOf(string2, n4) != n4) {
            n4 += n3;
        }
        stringArray[n6] = string.substring(n2, n4);
        return stringArray;
    }

    public static String replaceAllCharacters(String string, String string2, String string3) {
        int n = string2.length();
        while (--n >= 0) {
            String string4 = string2.substring(n, n + 1);
            string = TextFormat.simpleReplace(string, string4, string3);
        }
        return string;
    }

    public static String replaceAllCharacters(String string, String string2, char c) {
        int n = string2.length();
        while (--n >= 0) {
            string = string.replace(string2.charAt(n), c);
        }
        return string;
    }

    public static String simpleReplace(String string, String string2, String string3) {
        boolean bl;
        if (string == null || string.indexOf(string2) < 0 || string2.equals(string3)) {
            return string;
        }
        int n = string2.length();
        if (n == 0) {
            return string;
        }
        boolean bl2 = bl = string3.indexOf(string2) >= 0;
        while (string.indexOf(string2) >= 0) {
            int n2;
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            while ((n2 = string.indexOf(string2, n3)) >= 0) {
                stringBuffer.append(string.substring(n3, n2)).append(string3);
                n3 = n2 + n;
            }
            stringBuffer.append(string.substring(n3));
            string = stringBuffer.toString();
            if (!bl) continue;
            break;
        }
        return string;
    }

    public static String trim(String string, String string2) {
        int n;
        int n2;
        if (string2.length() == 0) {
            return string.trim();
        }
        int n3 = string.length();
        for (n2 = 0; n2 < n3 && string2.indexOf(string.charAt(n2)) >= 0; ++n2) {
        }
        for (n = string.length() - 1; n > n2 && string2.indexOf(string.charAt(n)) >= 0; --n) {
        }
        return string.substring(n2, n + 1);
    }

    public static String[] split(String string, char c) {
        return TextFormat.split(string, "" + c);
    }

    public static void lFill(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append(string2);
        int n = string.length() - string2.length();
        if (n > 0) {
            stringBuffer.append(string.substring(0, n));
        }
    }

    public static void rFill(StringBuffer stringBuffer, String string, String string2) {
        int n = string.length() - string2.length();
        if (n > 0) {
            stringBuffer.append(string.substring(0, n));
        }
        stringBuffer.append(string2);
    }

    public static boolean isWild(String string) {
        return string != null && (string.indexOf("*") >= 0 || string.indexOf("?") >= 0);
    }

    public static boolean isMatch(String string, String string2, boolean bl, boolean bl2) {
        boolean bl3;
        int n = 0;
        int n2 = string2.length();
        int n3 = string.length();
        if (n3 == 0 || n2 == 0) {
            return n3 == n2 || n2 == 1 && string2.charAt(0) == '*';
        }
        boolean bl4 = bl && bl2 ? string2.charAt(0) == '*' : (bl3 = false);
        if (bl3 && string2.charAt(n2 - 1) == '*') {
            return n2 < 3 || string.indexOf(string2.substring(1, n2 - 1)) >= 0;
        }
        String string3 = "????";
        while (string3.length() < string.length()) {
            string3 = string3 + string3;
        }
        if (bl) {
            if (bl2 && bl3) {
                string2 = string3 + string2.substring(1);
            }
            if (string2.charAt(n = string2.length() - 1) == '*') {
                string2 = string2.substring(0, n) + string3;
            }
            n2 = string2.length();
        }
        if (n2 < n3) {
            return false;
        }
        n = 0;
        while (n2 > n3) {
            if (bl2 && string2.charAt(n) == '?') {
                ++n;
            } else if (string2.charAt(n + n2 - 1) != '?') {
                return false;
            }
            --n2;
        }
        int n4 = n3;
        while (--n4 >= 0) {
            char c = string2.charAt(n + n4);
            if (c == '?' || c == string.charAt(n4) || c == '\u0001' && string.charAt(n4) == '?') continue;
            return false;
        }
        return true;
    }

    public static String join(Object[] objectArray, char c, int n) {
        if (objectArray.length < n) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(objectArray[n++]);
        for (int i = n; i < objectArray.length; ++i) {
            stringBuffer.append(c).append(objectArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String replaceQuotedStrings(String string, List<String> list, List<String> list2) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String string2 = list.get(i);
            String string3 = list2.get(i);
            if (string3.equals(string2)) continue;
            string = TextFormat.simpleReplace(string, "\"" + string2 + "\"", "\"" + string3 + "\"");
        }
        return string;
    }

    public static String replaceStrings(String string, List<String> list, List<String> list2) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String string2 = list.get(i);
            String string3 = list2.get(i);
            if (string3.equals(string2)) continue;
            string = TextFormat.simpleReplace(string, string2, string3);
        }
        return string;
    }
}

