/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix3f;
import org.jmol.script.ScriptEvaluator;
import org.jmol.script.ScriptVariable;
import org.jmol.script.Token;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.TextFormat;
import org.jmol.viewer.Viewer;

public class PropertyManager {
    private static final String[] propertyTypes = new String[]{"appletInfo", "", "", "fileName", "", "", "fileHeader", "", "", "fileContents", "<pathname>", "", "fileContents", "", "", "animationInfo", "", "", "modelInfo", "<atom selection>", "(*)", "X -vibrationInfo", "", "", "shapeInfo", "", "", "measurementInfo", "", "", "centerInfo", "", "", "orientationInfo", "", "", "transformInfo", "", "", "atomList", "<atom selection>", "(visible)", "atomInfo", "<atom selection>", "(visible)", "bondInfo", "<atom selection>", "(visible)", "chainInfo", "<atom selection>", "(visible)", "polymerInfo", "<atom selection>", "(visible)", "moleculeInfo", "<atom selection>", "(visible)", "stateInfo", "<state type>", "all", "extractModel", "<atom selection>", "(visible)", "jmolStatus", "statusNameList", "", "jmolViewer", "", "", "messageQueue", "", "", "auxiliaryInfo", "<atom selection>", "*", "boundBoxInfo", "", "", "dataInfo", "<data type>", "types", "image", "", "", "evaluate", "<expression>", "", "menu", "<type>", "current", "minimizationInfo", "", "", "pointGroupInfo", "<atom selection>", "(visible)", "fileInfo", "<type>", "", "errorMessage", "", "", "mouseInfo", "", ""};
    private static final String[] readableTypes = new String[]{"", "stateinfo", "extractmodel", "filecontents", "fileheader", "image", "menu"};

    public static int getPropertyNumber(String string) {
        if (string == null) {
            return -1;
        }
        for (int i = 0; i < 35; ++i) {
            if (!string.equalsIgnoreCase(PropertyManager.getPropertyName(i))) continue;
            return i;
        }
        return -1;
    }

    public static String getDefaultParam(int n) {
        if (n < 0) {
            return "";
        }
        return propertyTypes[n * 3 + 2];
    }

    public static boolean acceptsStringParameter(String string) {
        int n = PropertyManager.getPropertyNumber(string);
        String string2 = PropertyManager.getParamType(n);
        return string2.length() > 0 && string2 != "<atom selection>";
    }

    public static Object getProperty(Viewer viewer, String string, String string2, Object object) {
        if (propertyTypes.length != 105) {
            Logger.warn("propertyTypes is not the right length: " + propertyTypes.length + " != " + 105);
        }
        Object object2 = string2.indexOf(".") >= 0 || string2.indexOf("[") >= 0 ? PropertyManager.getModelProperty(viewer, string2, object) : PropertyManager.getPropertyAsObject(viewer, string2, object, string);
        if (string == null) {
            return object2;
        }
        boolean bl = string.equalsIgnoreCase("readable");
        if (bl) {
            String string3 = string = PropertyManager.isReadableAsString(string2) ? "String" : "JSON";
        }
        if (string.equalsIgnoreCase("String")) {
            return object2 == null ? "" : object2.toString();
        }
        if (bl) {
            return Escape.toReadable(string2, object2);
        }
        if (string.equalsIgnoreCase("JSON")) {
            return "{" + Escape.toJSON(string2, object2) + "}";
        }
        return object2;
    }

    static Object getModelProperty(Viewer viewer, String string, Object object) {
        string = string.replace(']', ' ').replace('[', ' ').replace('.', ' ');
        string = TextFormat.simpleReplace(string, "  ", " ");
        String[] stringArray = TextFormat.split(TextFormat.trim(string, " "), " ");
        ScriptVariable[] scriptVariableArray = new ScriptVariable[stringArray.length];
        string = stringArray[0];
        for (int i = 1; i < stringArray.length; ++i) {
            int n = Parser.parseInt(stringArray[i]);
            scriptVariableArray[i] = n != Integer.MIN_VALUE ? new ScriptVariable(2, n) : new ScriptVariable(4, stringArray[i]);
        }
        return PropertyManager.extractProperty(PropertyManager.getProperty(viewer, null, string, object), scriptVariableArray, 1);
    }

    public static Object extractProperty(Object object, ScriptVariable[] scriptVariableArray, int n) {
        if (n >= scriptVariableArray.length) {
            return object;
        }
        ScriptVariable scriptVariable = scriptVariableArray[n++];
        switch (scriptVariable.tok) {
            case 2: {
                int n2 = ScriptVariable.iValue(scriptVariable) - 1;
                if (object instanceof List) {
                    List list = (List)object;
                    if (n2 < 0) {
                        n2 += list.size();
                    }
                    if (n2 >= 0 && n2 < list.size()) {
                        return PropertyManager.extractProperty(list.get(n2), scriptVariableArray, n);
                    }
                    return "";
                }
                if (object instanceof String[]) {
                    String[] stringArray = (String[])object;
                    if (n2 < 0) {
                        n2 += stringArray.length;
                    }
                    if (n2 >= 0 && n2 < stringArray.length) {
                        return stringArray[n2];
                    }
                    return "";
                }
                if (object instanceof Matrix3f) {
                    Matrix3f matrix3f = (Matrix3f)object;
                    float[][] fArrayArray = new float[][]{{matrix3f.m00, matrix3f.m01, matrix3f.m02}, {matrix3f.m10, matrix3f.m11, matrix3f.m12}, {matrix3f.m20, matrix3f.m21, matrix3f.m22}};
                    if (n2 < 0) {
                        n2 += 3;
                    }
                    if (n2 >= 0 && n2 < 3) {
                        return PropertyManager.extractProperty(fArrayArray, scriptVariableArray, --n);
                    }
                    return "";
                }
                if (object instanceof float[]) {
                    float[] fArray = (float[])object;
                    if (n2 < 0) {
                        n2 += fArray.length;
                    }
                    if (n2 >= 0 && n2 < fArray.length) {
                        return new Float(fArray[n2]);
                    }
                    return "";
                }
                if (object instanceof int[]) {
                    int[] nArray = (int[])object;
                    if (n2 < 0) {
                        n2 += nArray.length;
                    }
                    if (n2 >= 0 && n2 < nArray.length) {
                        return nArray[n2];
                    }
                    return "";
                }
                if (object instanceof float[][]) {
                    float[][] fArray = (float[][])object;
                    if (n2 < 0) {
                        n2 += fArray.length;
                    }
                    if (n2 >= 0 && n2 < fArray.length) {
                        return PropertyManager.extractProperty(fArray[n2], scriptVariableArray, n);
                    }
                    return "";
                }
                if (object instanceof int[][]) {
                    int[][] nArray = (int[][])object;
                    if (n2 < 0) {
                        n2 += nArray.length;
                    }
                    if (n2 >= 0 && n2 < nArray.length) {
                        return PropertyManager.extractProperty(nArray[n2], scriptVariableArray, n);
                    }
                    return "";
                }
                if (!(object instanceof Object[])) break;
                Object[] objectArray = (Object[])object;
                if (n2 < 0) {
                    n2 += objectArray.length;
                }
                if (n2 >= 0 && n2 < objectArray.length) {
                    return objectArray[n2];
                }
                return "";
            }
            case 4: {
                String string = ScriptVariable.sValue(scriptVariable);
                if (object instanceof Map) {
                    Map map = (Map)object;
                    if (string.equalsIgnoreCase("keys")) {
                        ArrayList arrayList = new ArrayList();
                        Iterator iterator = map.keySet().iterator();
                        while (iterator.hasNext()) {
                            arrayList.add(iterator.next());
                        }
                        return PropertyManager.extractProperty(arrayList, scriptVariableArray, n);
                    }
                    if (!map.containsKey(string)) {
                        Iterator iterator = map.keySet().iterator();
                        String string2 = "";
                        while (iterator.hasNext()) {
                            string2 = (String)iterator.next();
                            if (!string2.equalsIgnoreCase(string)) continue;
                            string = string2;
                            break;
                        }
                    }
                    if (map.containsKey(string)) {
                        return PropertyManager.extractProperty(map.get(string), scriptVariableArray, n);
                    }
                    return "";
                }
                if (!(object instanceof List)) break;
                List list = (List)object;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                --n;
                for (int i = 0; i < list.size(); ++i) {
                    Object e = list.get(i);
                    if (!(e instanceof Map)) continue;
                    arrayList.add(PropertyManager.extractProperty(e, scriptVariableArray, n));
                }
                return arrayList;
            }
        }
        return object;
    }

    private static String getPropertyName(int n) {
        if (n < 0) {
            return "";
        }
        return propertyTypes[n * 3];
    }

    private static String getParamType(int n) {
        if (n < 0) {
            return "";
        }
        return propertyTypes[n * 3 + 1];
    }

    private static boolean isReadableAsString(String string) {
        int n = readableTypes.length;
        while (--n >= 0) {
            if (!string.equalsIgnoreCase(readableTypes[n])) continue;
            return true;
        }
        return false;
    }

    private static Object getPropertyAsObject(Viewer viewer, String string, Object object, String string2) {
        if (string.equals("tokenList")) {
            return Token.getTokensLike((String)object);
        }
        int n = PropertyManager.getPropertyNumber(string);
        boolean bl = object != null && object.toString().length() > 0;
        Object object2 = bl ? object : PropertyManager.getDefaultParam(n);
        switch (n) {
            case 0: {
                return viewer.getAppletInfo();
            }
            case 5: {
                return viewer.getAnimationInfo();
            }
            case 13: {
                return viewer.getAtomBitSetVector(object2);
            }
            case 14: {
                return viewer.getAllAtomInfo(object2);
            }
            case 24: {
                return viewer.getAuxiliaryInfo(object2);
            }
            case 15: {
                return viewer.getAllBondInfo(object2);
            }
            case 25: {
                return viewer.getBoundBoxInfo();
            }
            case 10: {
                return viewer.getRotationCenter();
            }
            case 16: {
                return viewer.getAllChainInfo(object2);
            }
            case 20: {
                return viewer.getModelExtract(object2, true, "MOL");
            }
            case 1: {
                return viewer.getFullPathName();
            }
            case 2: {
                return viewer.getFileHeader();
            }
            case 3: 
            case 4: {
                if (bl) {
                    return viewer.getFileAsString(object2.toString());
                }
                return viewer.getCurrentFileAsString();
            }
            case 21: {
                return viewer.getStatusChanged(object2.toString());
            }
            case 22: {
                return viewer;
            }
            case 9: {
                return viewer.getMeasurementInfo();
            }
            case 29: {
                return viewer.getMenu(object2.toString());
            }
            case 23: {
                return viewer.getMessageQueue();
            }
            case 30: {
                return viewer.getMinimizationInfo();
            }
            case 6: {
                return viewer.getModelInfo(object2);
            }
            case 18: {
                return viewer.getMoleculeInfo(object2);
            }
            case 11: {
                return viewer.getOrientationInfo();
            }
            case 17: {
                return viewer.getAllPolymerInfo(object2);
            }
            case 8: {
                return viewer.getShapeInfo();
            }
            case 19: {
                return viewer.getStateInfo(object2.toString());
            }
            case 31: {
                return viewer.getPointGroupInfo(object2);
            }
            case 32: {
                return PropertyManager.getFileInfo(viewer.getFileData(), object2.toString());
            }
            case 33: {
                return viewer.getErrorMessageUntranslated();
            }
            case 12: {
                return viewer.getMatrixRotate();
            }
            case 26: {
                return viewer.getData(object2.toString());
            }
            case 34: {
                return viewer.getMouseInfo();
            }
            case 28: {
                return ScriptEvaluator.evaluateExpression(viewer, object2.toString());
            }
            case 27: {
                String string3 = object2.toString();
                int n2 = -1;
                int n3 = -1;
                int n4 = string3.indexOf("height=");
                if (n4 >= 0) {
                    n2 = Parser.parseInt(string3.substring(n4 + 7));
                }
                if ((n4 = string3.indexOf("width=")) >= 0) {
                    n3 = Parser.parseInt(string3.substring(n4 + 6));
                }
                if (n3 < 0 && n2 < 0) {
                    n3 = -1;
                    n2 = -1;
                } else if (n3 < 0) {
                    n3 = n2;
                } else {
                    n2 = n3;
                }
                return viewer.getImageAs(string2 == null ? "JPEG" : "JPG64", -1, n3, n2, null, null);
            }
        }
        Object[] objectArray = new String[35];
        for (int i = 0; i < 35; ++i) {
            String string4 = PropertyManager.getParamType(i);
            String string5 = PropertyManager.getDefaultParam(i);
            String string6 = PropertyManager.getPropertyName(i);
            objectArray[i] = string6.charAt(0) == 'X' ? "" : string6 + (string4 != "" ? " " + PropertyManager.getParamType(i) + (string5 != "" ? " #default: " + PropertyManager.getDefaultParam(i) : "") : "");
        }
        Arrays.sort(objectArray);
        StringBuffer stringBuffer = new StringBuffer("getProperty ERROR\n" + string + "?\nOptions include:\n");
        for (int i = 0; i < 35; ++i) {
            if (((String)objectArray[i]).length() <= 0) continue;
            stringBuffer.append("\n getProperty ").append((String)objectArray[i]);
        }
        return stringBuffer.toString();
    }

    static Object getFileInfo(Object object, String string) {
        boolean bl;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (object == null) {
            return hashtable;
        }
        boolean bl2 = bl = string != null && string.length() > 0;
        if (object instanceof Map) {
            return bl ? ((Map)object).get(string) : object;
        }
        String[] stringArray = TextFormat.split((String)object, '\n');
        String string2 = "";
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            string = string.toUpperCase();
        }
        String string3 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = stringArray[i];
            if (string4.length() < 12) continue;
            string3 = string4.substring(0, 6).trim();
            String string5 = string4.substring(7, 10).trim();
            if (string3.equals("REMARK")) {
                string3 = string3 + string5;
            }
            if (!string3.equals(string2)) {
                if (bl && string2.equals(string)) {
                    return stringBuilder.toString();
                }
                if (stringBuilder != null && !bl) {
                    hashtable.put(string2, stringBuilder.toString());
                    stringBuilder = new StringBuilder();
                }
                string2 = string3;
            }
            if (bl && !string3.equals(string)) continue;
            stringBuilder.append(string4.substring(10).trim()).append('\n');
        }
        if (stringBuilder != null && !bl) {
            hashtable.put(string2, stringBuilder.toString());
        }
        if (bl) {
            return string3.equals(string) ? stringBuilder.toString() : "";
        }
        return hashtable;
    }
}

