/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.Bytes;
import com.mongodb.DB;
import com.mongodb.DBApiLayer;
import com.mongodb.DBTCPConnector;
import com.mongodb.MongoException;
import com.mongodb.MongoOptions;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.bson.io.PoolOutputBuffer;
import org.bson.util.SimplePool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mongo {
    static int cleanerIntervalMS = Integer.parseInt(System.getProperty("com.mongodb.cleanerIntervalMS", "1000"));
    final ServerAddress _addr;
    final List<ServerAddress> _addrs;
    final MongoOptions _options;
    final DBTCPConnector _connector;
    final ConcurrentMap<String, DB> _dbs = new ConcurrentHashMap<String, DB>();
    private WriteConcern _concern = WriteConcern.NORMAL;
    private ReadPreference _readPref = ReadPreference.PRIMARY;
    final Bytes.OptionHolder _netOptions = new Bytes.OptionHolder(null);
    final DBCleanerThread _cleaner;
    SimplePool<PoolOutputBuffer> _bufferPool = new SimplePool<PoolOutputBuffer>(1000){

        @Override
        protected PoolOutputBuffer createNew() {
            return new PoolOutputBuffer();
        }
    };

    public Mongo() throws UnknownHostException, MongoException {
        this(new ServerAddress());
    }

    public Mongo(String host, int port) throws UnknownHostException, MongoException {
        this(new ServerAddress(host, port));
    }

    public Mongo(ServerAddress addr) throws MongoException {
        this(addr, new MongoOptions());
    }

    public Mongo(ServerAddress addr, MongoOptions options) throws MongoException {
        this._addr = addr;
        this._addrs = null;
        this._options = options;
        this._applyMongoOptions();
        this._connector = new DBTCPConnector(this, this._addr);
        this._connector.start();
        this._cleaner = new DBCleanerThread();
        this._cleaner.start();
    }

    public DB getDB(String dbname) {
        DB db = (DB)this._dbs.get(dbname);
        if (db != null) {
            return db;
        }
        db = new DBApiLayer(this, dbname, this._connector);
        DB temp = this._dbs.putIfAbsent(dbname, db);
        if (temp != null) {
            return temp;
        }
        return db;
    }

    public DBTCPConnector getConnector() {
        return this._connector;
    }

    public ServerAddress getAddress() {
        return this._connector.getAddress();
    }

    public List<ServerAddress> getServerAddressList() {
        return this._connector.getServerAddressList();
    }

    public void setWriteConcern(WriteConcern concern) {
        this._concern = concern;
    }

    public WriteConcern getWriteConcern() {
        return this._concern;
    }

    @Deprecated
    public void slaveOk() {
        this.addOption(4);
    }

    public void addOption(int option) {
        this._netOptions.add(option);
    }

    void _applyMongoOptions() {
        if (this._options.slaveOk) {
            this.slaveOk();
        }
        this.setWriteConcern(this._options.getWriteConcern());
    }

    public MongoOptions getMongoOptions() {
        return this._options;
    }

    public int getMaxBsonObjectSize() {
        int maxsize = this._connector.getMaxBsonObjectSize();
        if (maxsize == 0) {
            maxsize = this._connector.fetchMaxBsonObjectSize();
        }
        return maxsize > 0 ? maxsize : 0x400000;
    }

    public String toString() {
        StringBuilder str = new StringBuilder("Mongo: ");
        List<ServerAddress> list = this.getServerAddressList();
        if (list == null || list.size() == 0) {
            str.append("null");
        } else {
            for (ServerAddress addr : list) {
                str.append(addr.toString()).append(',');
            }
            str.deleteCharAt(str.length() - 1);
        }
        return str.toString();
    }

    class DBCleanerThread
    extends Thread {
        DBCleanerThread() {
            this.setDaemon(true);
            this.setName("MongoCleaner" + this.hashCode());
        }

        public void run() {
            while (Mongo.this._connector.isOpen()) {
                try {
                    try {
                        Thread.sleep(cleanerIntervalMS);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    for (DB db : Mongo.this._dbs.values()) {
                        db.cleanCursors(true);
                    }
                }
                catch (Throwable throwable) {
                }
            }
        }
    }
}

