/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom;

import edu.colorado.phet.buildanatom.developer.DeveloperConfiguration;
import edu.colorado.phet.buildanatom.developer.ProblemTypeSelectionDialog;
import edu.colorado.phet.buildanatom.modules.buildatom.BuildAnAtomModule;
import edu.colorado.phet.buildanatom.modules.game.BuildAnAtomGameModule;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.menu.OptionsMenu;
import edu.colorado.phet.common.piccolophet.PiccoloPhetApplication;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;

public class BuildAnAtomApplication
extends PiccoloPhetApplication {
    private JCheckBoxMenuItem problemDialogVisibleControl;
    ProblemTypeSelectionDialog problemTypeSelectionDialog = ProblemTypeSelectionDialog.createInstance(this.getPhetFrame());

    public BuildAnAtomApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        this.initModules();
        this.initMenubar();
    }

    private void initModules() {
        this.addModule(new BuildAnAtomModule());
        this.addModule(new BuildAnAtomGameModule());
    }

    private void initMenubar() {
        PhetFrame phetFrame = this.getPhetFrame();
        OptionsMenu optionsMenu = new OptionsMenu();
        if (optionsMenu.getMenuComponentCount() > 0) {
            phetFrame.addMenu(optionsMenu);
        }
        JMenu jMenu = phetFrame.getDeveloperMenu();
        this.problemDialogVisibleControl = new JCheckBoxMenuItem("Show Problem Type Dialog");
        jMenu.add(this.problemDialogVisibleControl);
        this.problemDialogVisibleControl.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BuildAnAtomApplication.this.setProblemTypeDialogVisible(BuildAnAtomApplication.this.problemDialogVisibleControl.isSelected());
            }
        });
        this.problemTypeSelectionDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                BuildAnAtomApplication.this.problemDialogVisibleControl.setSelected(false);
            }
        });
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Animate Unstable Nucleus"){
            {
                this.setSelected((Boolean)DeveloperConfiguration.ANIMATE_UNSTABLE_NUCLEUS_PROPERTY.get());
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        DeveloperConfiguration.ANIMATE_UNSTABLE_NUCLEUS_PROPERTY.set(this.isSelected());
                    }
                });
            }
        };
        jMenu.add(jCheckBoxMenuItem);
    }

    protected void setProblemTypeDialogVisible(boolean bl) {
        this.problemTypeSelectionDialog.setVisible(bl);
    }

    public static void main(String[] stringArray) throws ClassNotFoundException {
        new PhetApplicationLauncher().launchSim(stringArray, "build-an-atom", "build-an-atom", BuildAnAtomApplication.class);
    }
}

