/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.model;

import edu.colorado.phet.buildanatom.developer.DeveloperConfiguration;
import edu.colorado.phet.buildanatom.model.AtomIdentifier;
import edu.colorado.phet.buildanatom.model.AtomListener;
import edu.colorado.phet.buildanatom.model.BuildAnAtomClock;
import edu.colorado.phet.buildanatom.model.BuildAnAtomModel;
import edu.colorado.phet.buildanatom.model.Electron;
import edu.colorado.phet.buildanatom.model.ElectronShell;
import edu.colorado.phet.buildanatom.model.IAtom;
import edu.colorado.phet.buildanatom.model.IDynamicAtom;
import edu.colorado.phet.buildanatom.model.ImmutableAtom;
import edu.colorado.phet.buildanatom.model.Neutron;
import edu.colorado.phet.buildanatom.model.Proton;
import edu.colorado.phet.buildanatom.model.SphericalParticle;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Atom
implements IDynamicAtom {
    private static Random RAND = new Random();
    public static final Point2D DEFAULT_POSITION = new Point2D.Double(0.0, 0.0);
    private final Point2D position = new Point2D.Double(DEFAULT_POSITION.getX(), DEFAULT_POSITION.getY());
    private Vector2D unstableNucleusJitterVector = new Vector2D(0.0, 0.0);
    public final ArrayList<Proton> protons = new ArrayList();
    public final ArrayList<Neutron> neutrons = new ArrayList();
    private final ElectronShell electronShell1 = new ElectronShell(34.0, 2, DEFAULT_POSITION);
    private final ElectronShell electronShell2 = new ElectronShell(102.0, 8, DEFAULT_POSITION);
    private int animationCount = 0;
    private boolean isAway = false;
    private final SphericalParticle.Adapter nucleonGrabbedListener = new SphericalParticle.Adapter(){

        public void grabbedByUser(SphericalParticle sphericalParticle) {
            Atom.this.removeNucleon(sphericalParticle);
        }
    };
    private final HashSet<AtomListener> listeners = new HashSet();

    public Atom(Point2D point2D, BuildAnAtomClock buildAnAtomClock) {
        this.position.setLocation(point2D);
        this.electronShell1.addObserver(new SimpleObserver(){

            public void update() {
                Atom.this.checkAndReconfigureShells();
                Atom.this.notifyConfigurationChanged();
            }
        });
        this.electronShell2.addObserver(new SimpleObserver(){

            public void update() {
                Atom.this.notifyConfigurationChanged();
            }
        });
        buildAnAtomClock.addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                Atom.this.stepInTime();
            }
        });
    }

    private void stepInTime() {
        boolean bl;
        ++this.animationCount;
        boolean bl2 = bl = (Boolean)DeveloperConfiguration.ANIMATE_UNSTABLE_NUCLEUS_PROPERTY.get() != false && !this.isStable() && !this.isAway && this.animationCount % 2 == 0;
        if (bl) {
            this.unstableNucleusJitterVector = Vector2D.createPolar(RAND.nextDouble() * 5.0, RAND.nextDouble() * Math.PI * 2.0);
            this.jumpAway();
        } else if (this.animationCount % 2 == 0 && this.isAway || this.isStable() && this.isAway) {
            this.jumpBack();
        }
    }

    private void jumpAway() {
        this.translateNucleons(this.unstableNucleusJitterVector, true);
    }

    private void jumpBack() {
        this.translateNucleons(this.unstableNucleusJitterVector.times(-1.0), false);
    }

    private void translateNucleons(Vector2D vector2D, boolean bl) {
        for (SphericalParticle sphericalParticle : this.getNucleons()) {
            sphericalParticle.setPositionAndDestination(vector2D.getDestination(sphericalParticle.getDestination().toPoint2D()));
        }
        this.isAway = bl;
    }

    public SphericalParticle removeNucleon(SphericalParticle sphericalParticle) {
        assert (!(sphericalParticle instanceof Electron));
        boolean bl = false;
        if (sphericalParticle instanceof Proton && this.protons.contains(sphericalParticle)) {
            this.removeProton((Proton)sphericalParticle);
            bl = true;
        } else if (sphericalParticle instanceof Neutron && this.neutrons.contains(sphericalParticle)) {
            this.removeNeutron((Neutron)sphericalParticle);
            bl = true;
        }
        return bl ? sphericalParticle : null;
    }

    public SphericalParticle removeProton(Proton proton) {
        boolean bl = this.protons.remove(proton);
        proton.removeListener(this.nucleonGrabbedListener);
        this.reconfigureNucleus(false);
        this.notifyConfigurationChanged();
        return bl ? proton : null;
    }

    public SphericalParticle removeProton() {
        assert (this.protons.size() > 0);
        return this.removeProton(this.protons.get(0));
    }

    public SphericalParticle removeNeutron(Neutron neutron) {
        boolean bl = this.neutrons.remove(neutron);
        neutron.removeListener(this.nucleonGrabbedListener);
        this.reconfigureNucleus(false);
        this.notifyConfigurationChanged();
        return bl ? neutron : null;
    }

    public SphericalParticle removeNeutron() {
        assert (this.neutrons.size() > 0);
        return this.removeNeutron(this.neutrons.get(0));
    }

    public Electron removeElectron(Electron electron) {
        Electron electron2 = null;
        if (this.electronShell1.containsElectron(electron)) {
            electron2 = this.electronShell1.removeElectron(electron);
        } else if (this.electronShell2.containsElectron(electron)) {
            electron2 = this.electronShell2.removeElectron(electron);
        }
        return electron2;
    }

    public Electron removeElectron() {
        return this.electronShell1.removeElectron();
    }

    private void checkAndReconfigureShells() {
        this.checkAndReconfigureShells(this.electronShell1, this.electronShell2);
    }

    private void checkAndReconfigureShells(ElectronShell electronShell, ElectronShell electronShell2) {
        if (!electronShell.isFull() && !electronShell2.isEmpty()) {
            ArrayList<Point2D> arrayList = electronShell.getOpenShellLocations();
            assert (arrayList.size() == 1);
            Electron electron = electronShell2.getClosestElectron(arrayList.get(0));
            electronShell2.removeElectron(electron);
            electronShell.addElectron(electron, false);
        }
    }

    public void reset() {
        for (Proton sphericalParticle : this.protons) {
            sphericalParticle.removeListener(this.nucleonGrabbedListener);
        }
        for (Neutron neutron : this.neutrons) {
            neutron.removeListener(this.nucleonGrabbedListener);
        }
        this.protons.clear();
        this.neutrons.clear();
        this.electronShell2.reset();
        this.electronShell1.reset();
        this.notifyConfigurationChanged();
    }

    public ArrayList<ElectronShell> getElectronShells() {
        ArrayList<ElectronShell> arrayList = new ArrayList<ElectronShell>();
        arrayList.add(this.electronShell1);
        arrayList.add(this.electronShell2);
        return arrayList;
    }

    public int getRemainingElectronCapacity() {
        return this.electronShell1.getNumOpenLocations() + this.electronShell2.getNumOpenLocations();
    }

    public Point2D getPosition() {
        return new Point2D.Double(this.position.getX(), this.position.getY());
    }

    public void setPosition(double d, double d2) {
        this.position.setLocation(d, d2);
        this.electronShell1.setCenterLocation(d, d2);
        this.electronShell2.setCenterLocation(d, d2);
        this.reconfigureNucleus(true);
        this.notifyPositionChanged();
    }

    public void setPosition(Point2D point2D) {
        this.setPosition(point2D.getX(), point2D.getY());
    }

    public boolean configurationEquals(IAtom iAtom) {
        return this.protons.size() == iAtom.getNumProtons() && this.neutrons.size() == iAtom.getNumNeutrons() && this.electronShell1.getNumElectrons() + this.electronShell2.getNumElectrons() == iAtom.getNumElectrons();
    }

    public void addProton(Proton proton, boolean bl) {
        assert (!this.protons.contains(proton));
        this.protons.add(proton);
        this.reconfigureNucleus(bl);
        proton.addListener(this.nucleonGrabbedListener);
        this.notifyConfigurationChanged();
    }

    public void addNeutron(Neutron neutron, boolean bl) {
        assert (!this.neutrons.contains(neutron));
        this.neutrons.add(neutron);
        this.reconfigureNucleus(bl);
        neutron.addListener(this.nucleonGrabbedListener);
        this.notifyConfigurationChanged();
    }

    public void addElectron(Electron electron, boolean bl) {
        if (!this.electronShell1.isFull()) {
            this.electronShell1.addElectron(electron, bl);
        } else if (!this.electronShell2.isFull()) {
            this.electronShell2.addElectron(electron, bl);
        } else assert (false);
        this.notifyConfigurationChanged();
    }

    public void reconfigureNucleus(boolean bl) {
        double d;
        if (this.isAway) {
            this.jumpBack();
        }
        double d2 = 5.0;
        ArrayList<SphericalParticle> arrayList = this.getNucleons();
        double d3 = this.getPosition().getX();
        double d4 = this.getPosition().getY();
        if (arrayList.size() == 0) {
            return;
        }
        if (arrayList.size() == 1) {
            arrayList.get(0).setDestination(this.getPosition());
        } else if (arrayList.size() == 2) {
            d = RAND.nextDouble() * 2.0 * Math.PI;
            arrayList.get(0).setDestination(d3 + d2 * Math.cos(d), d4 + d2 * Math.sin(d));
            arrayList.get(1).setDestination(d3 - d2 * Math.cos(d), d4 - d2 * Math.sin(d));
        } else if (arrayList.size() == 3) {
            d = RAND.nextDouble() * 2.0 * Math.PI;
            double d5 = d2 * 1.155;
            arrayList.get(0).setDestination(d3 + d5 * Math.cos(d), d4 + d5 * Math.sin(d));
            arrayList.get(1).setDestination(d3 + d5 * Math.cos(d + 2.0943951023931953), d4 + d5 * Math.sin(d + 2.0943951023931953));
            arrayList.get(2).setDestination(d3 + d5 * Math.cos(d + 4.1887902047863905), d4 + d5 * Math.sin(d + 4.1887902047863905));
        } else if (arrayList.size() == 4) {
            d = RAND.nextDouble() * 2.0 * Math.PI;
            arrayList.get(0).setDestination(d3 + d2 * Math.cos(d), d4 + d2 * Math.sin(d));
            arrayList.get(2).setDestination(d3 - d2 * Math.cos(d), d4 - d2 * Math.sin(d));
            double d6 = d2 * 2.0 * Math.cos(1.0471975511965976);
            arrayList.get(1).setDestination(d3 + d6 * Math.cos(d + 1.5707963267948966), d4 + d6 * Math.sin(d + 1.5707963267948966));
            arrayList.get(3).setDestination(d3 - d6 * Math.cos(d + 1.5707963267948966), d4 - d6 * Math.sin(d + 1.5707963267948966));
        } else if (arrayList.size() >= 5) {
            d = 0.0;
            int n = 1;
            int n2 = 0;
            double d7 = 0.0;
            double d8 = 0.0;
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList.get(i).setDestination(d3 + d * Math.cos(d7), d4 + d * Math.sin(d7));
                if (--n > 0) {
                    d7 += d8;
                    continue;
                }
                d7 += 0.39269908169872414;
                n = (int)Math.floor((d += d2 * 1.35 / (double)(++n2)) * Math.PI / d2);
                d8 = Math.PI * 2 / (double)n;
            }
            if (arrayList.size() == 7 && this.neutrons.size() == 4) {
                Neutron neutron = this.neutrons.get(this.neutrons.size() - 1);
                neutron.setDestination(neutron.getDestination().getX(), neutron.getDestination().getY() - 3.0);
            }
        }
        if (bl) {
            for (SphericalParticle sphericalParticle : arrayList) {
                sphericalParticle.moveToDestination();
            }
        }
    }

    private ArrayList<SphericalParticle> getNucleons() {
        ArrayList<SphericalParticle> arrayList = new ArrayList<SphericalParticle>();
        for (int i = 0; i < Math.max(this.protons.size(), this.neutrons.size()); ++i) {
            if (i < this.protons.size()) {
                arrayList.add(this.protons.get(i));
            }
            if (i >= this.neutrons.size()) continue;
            arrayList.add(this.neutrons.get(i));
        }
        return arrayList;
    }

    public ArrayList<Electron> getElectrons() {
        ArrayList<Electron> arrayList = new ArrayList<Electron>();
        arrayList.addAll(this.electronShell1.getElectrons());
        arrayList.addAll(this.electronShell2.getElectrons());
        return arrayList;
    }

    public boolean containsElectron(Electron electron) {
        return this.electronShell1.containsElectron(electron) || this.electronShell2.containsElectron(electron);
    }

    public ArrayList<Proton> getProtons() {
        return this.protons;
    }

    public ArrayList<Neutron> getNeutrons() {
        return this.neutrons;
    }

    @Override
    public int getNumProtons() {
        return this.protons.size();
    }

    @Override
    public void addAtomListener(final VoidFunction0 voidFunction0) {
        this.addAtomListener(new AtomListener(){

            public void configurationChanged() {
                voidFunction0.apply();
            }

            public void postitionChanged() {
            }
        });
    }

    @Override
    public int getNumNeutrons() {
        return this.neutrons.size();
    }

    @Override
    public int getNumElectrons() {
        return this.electronShell1.getNumElectrons() + this.electronShell2.getNumElectrons();
    }

    @Override
    public int getMassNumber() {
        return this.getNumProtons() + this.getNumNeutrons();
    }

    @Override
    public double getAtomicMass() {
        return AtomIdentifier.getAtomicMass(this);
    }

    public ArrayList<SphericalParticle> setState(ImmutableAtom immutableAtom, BuildAnAtomModel buildAnAtomModel, boolean bl) {
        ArrayList<SphericalParticle> arrayList = new ArrayList<SphericalParticle>();
        while (this.getNumProtons() > immutableAtom.getNumProtons()) {
            arrayList.add(this.removeProton());
        }
        while (this.getNumProtons() < immutableAtom.getNumProtons()) {
            this.addProton(buildAnAtomModel.getFreeProton(), bl);
        }
        while (this.getNumNeutrons() > immutableAtom.getNumNeutrons()) {
            arrayList.add(this.removeNeutron());
        }
        while (this.getNumNeutrons() < immutableAtom.getNumNeutrons()) {
            this.addNeutron(buildAnAtomModel.getFreeNeutron(), bl);
        }
        while (this.getNumElectrons() > immutableAtom.getNumElectrons()) {
            arrayList.add(this.removeElectron());
        }
        while (this.getNumElectrons() < immutableAtom.getNumElectrons()) {
            this.addElectron(buildAnAtomModel.getFreeElectron(), bl);
        }
        this.notifyConfigurationChanged();
        return arrayList;
    }

    public boolean containsProton(Proton proton) {
        return this.protons.contains(proton);
    }

    public boolean containsNeutron(Neutron neutron) {
        return this.neutrons.contains(neutron);
    }

    @Override
    public ImmutableAtom toImmutableAtom() {
        return new ImmutableAtom(this.getNumProtons(), this.getNumNeutrons(), this.getNumElectrons());
    }

    @Override
    public int getCharge() {
        return this.getNumProtons() - this.getNumElectrons();
    }

    @Override
    public String getName() {
        return AtomIdentifier.getName(this);
    }

    @Override
    public String getSymbol() {
        return AtomIdentifier.getSymbol(this);
    }

    @Override
    public boolean isStable() {
        return AtomIdentifier.isStable(this);
    }

    @Override
    public String getFormattedCharge() {
        if (this.getCharge() <= 0) {
            return "" + this.getCharge();
        }
        return "+" + this.getCharge();
    }

    @Override
    public double getNaturalAbundance() {
        return AtomIdentifier.getNaturalAbundance(this);
    }

    @Override
    public void addAtomListener(AtomListener atomListener) {
        this.listeners.add(atomListener);
    }

    private void notifyConfigurationChanged() {
        for (AtomListener atomListener : this.listeners) {
            atomListener.configurationChanged();
        }
    }

    private void notifyPositionChanged() {
        for (AtomListener atomListener : this.listeners) {
            atomListener.postitionChanged();
        }
    }
}

