/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.model;

import edu.colorado.phet.buildanatom.BuildAnAtomStrings;
import edu.colorado.phet.buildanatom.model.IAtom;
import edu.colorado.phet.buildanatom.model.ImmutableAtom;
import edu.colorado.phet.common.phetcommon.util.PrecisionDecimal;
import edu.colorado.phet.common.piccolophet.nodes.periodictable.SymbolTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomIdentifier {
    private static final List<IsotopeKey> STABLE_ISOTOPES = new ArrayList<IsotopeKey>(){
        {
            this.add(new IsotopeKey(1, 0));
            this.add(new IsotopeKey(1, 1));
            this.add(new IsotopeKey(2, 1));
            this.add(new IsotopeKey(2, 2));
            this.add(new IsotopeKey(3, 3));
            this.add(new IsotopeKey(3, 4));
            this.add(new IsotopeKey(4, 5));
            this.add(new IsotopeKey(5, 5));
            this.add(new IsotopeKey(5, 6));
            this.add(new IsotopeKey(6, 6));
            this.add(new IsotopeKey(6, 7));
            this.add(new IsotopeKey(7, 7));
            this.add(new IsotopeKey(7, 8));
            this.add(new IsotopeKey(8, 8));
            this.add(new IsotopeKey(8, 9));
            this.add(new IsotopeKey(8, 10));
            this.add(new IsotopeKey(9, 10));
            this.add(new IsotopeKey(10, 10));
            this.add(new IsotopeKey(10, 11));
            this.add(new IsotopeKey(10, 12));
            this.add(new IsotopeKey(11, 12));
            this.add(new IsotopeKey(12, 12));
            this.add(new IsotopeKey(12, 13));
            this.add(new IsotopeKey(12, 14));
            this.add(new IsotopeKey(13, 14));
            this.add(new IsotopeKey(14, 14));
            this.add(new IsotopeKey(14, 15));
            this.add(new IsotopeKey(14, 16));
            this.add(new IsotopeKey(15, 16));
            this.add(new IsotopeKey(16, 16));
            this.add(new IsotopeKey(16, 17));
            this.add(new IsotopeKey(16, 18));
            this.add(new IsotopeKey(16, 20));
            this.add(new IsotopeKey(17, 18));
            this.add(new IsotopeKey(17, 20));
            this.add(new IsotopeKey(18, 18));
            this.add(new IsotopeKey(18, 20));
            this.add(new IsotopeKey(18, 22));
        }
    };
    private static final Map<IsotopeKey, IsotopeInfo> ISOTOPE_INFO_MAP = AtomIdentifier.generateIsotopeInfoTable();
    private static final Map<Integer, String> MAP_ATOMIC_NUMBER_TO_AVERAGE_MASS = AtomIdentifier.generateMapOfAtomicNumberToMass();

    public static String getSymbol(IAtom iAtom) {
        return AtomIdentifier.getSymbol(iAtom.getNumProtons());
    }

    public static String getSymbol(int n) {
        if (n <= 0 || n > SymbolTable.ELEMENT_SYMBOL_TABLE.length) {
            return BuildAnAtomStrings.ELEMENT_NONE_SYMBOL;
        }
        return SymbolTable.ELEMENT_SYMBOL_TABLE[n];
    }

    public static String getName(IAtom iAtom) {
        return AtomIdentifier.getName(iAtom.getNumProtons());
    }

    public static String getName(int n) {
        if (n == 0) {
            return BuildAnAtomStrings.ELEMENT_NONE_NAME;
        }
        for (IsotopeKey isotopeKey : ISOTOPE_INFO_MAP.keySet()) {
            if (isotopeKey.getNumProtons() != n) continue;
            return ISOTOPE_INFO_MAP.get(isotopeKey).getElementName();
        }
        System.err.println("Error: No element found for proton count = " + n);
        return "Unknown";
    }

    public static boolean isStable(IAtom iAtom) {
        IsotopeKey isotopeKey = new IsotopeKey(iAtom);
        return ISOTOPE_INFO_MAP.containsKey(isotopeKey) ? ISOTOPE_INFO_MAP.get(isotopeKey).isStable() : false;
    }

    public static double getAtomicMass(IAtom iAtom) {
        IsotopeKey isotopeKey = new IsotopeKey(iAtom);
        return ISOTOPE_INFO_MAP.containsKey(isotopeKey) ? ISOTOPE_INFO_MAP.get(isotopeKey).getAtomicMass() : 0.0;
    }

    public static double getNaturalAbundance(IAtom iAtom) {
        return AtomIdentifier.getNaturalAbundancePrecisionDecimal(iAtom).getPreciseValue();
    }

    public static PrecisionDecimal getNaturalAbundancePrecisionDecimal(IAtom iAtom) {
        PrecisionDecimal precisionDecimal = new PrecisionDecimal(0.0, 10);
        IsotopeKey isotopeKey = new IsotopeKey(iAtom);
        return ISOTOPE_INFO_MAP.containsKey(isotopeKey) ? ISOTOPE_INFO_MAP.get(isotopeKey).getAbundance() : precisionDecimal;
    }

    public static ImmutableAtom getMostCommonIsotope(int n) {
        HashMap<IsotopeKey, IsotopeInfo> hashMap = new HashMap<IsotopeKey, IsotopeInfo>();
        for (IsotopeKey isotopeKey : ISOTOPE_INFO_MAP.keySet()) {
            if (isotopeKey.getNumProtons() != n) continue;
            hashMap.put(isotopeKey, ISOTOPE_INFO_MAP.get(isotopeKey));
        }
        double d = 0.0;
        IsotopeKey isotopeKey = new IsotopeKey(0, 0);
        for (IsotopeKey isotopeKey2 : hashMap.keySet()) {
            if (!(((IsotopeInfo)hashMap.get(isotopeKey2)).getAbundance().getPreciseValue() > d)) continue;
            isotopeKey = isotopeKey2;
            d = ((IsotopeInfo)hashMap.get(isotopeKey2)).getAbundance().getPreciseValue();
        }
        return new ImmutableAtom(isotopeKey.getNumProtons(), isotopeKey.getNumNeutrons(), isotopeKey.getNumProtons());
    }

    public static ArrayList<ImmutableAtom> getAllIsotopesOfElement(int n) {
        ArrayList<ImmutableAtom> arrayList = new ArrayList<ImmutableAtom>();
        for (IsotopeKey isotopeKey : ISOTOPE_INFO_MAP.keySet()) {
            if (n != isotopeKey.getNumProtons()) continue;
            arrayList.add(new ImmutableAtom(isotopeKey.getNumProtons(), isotopeKey.getNumNeutrons(), isotopeKey.getNumProtons()));
        }
        return arrayList;
    }

    public static ArrayList<ImmutableAtom> getStableIsotopesOfElement(int n) {
        ArrayList<ImmutableAtom> arrayList = AtomIdentifier.getAllIsotopesOfElement(n);
        ArrayList<ImmutableAtom> arrayList2 = new ArrayList<ImmutableAtom>();
        for (ImmutableAtom immutableAtom : arrayList) {
            if (!AtomIdentifier.isStable(immutableAtom)) continue;
            arrayList2.add(immutableAtom);
        }
        return arrayList2;
    }

    public static PrecisionDecimal getStandardAtomicMassPrecisionDecimal(int n) {
        PrecisionDecimal precisionDecimal = new PrecisionDecimal(0.0, 5);
        if (MAP_ATOMIC_NUMBER_TO_AVERAGE_MASS.containsKey(n)) {
            String string = MAP_ATOMIC_NUMBER_TO_AVERAGE_MASS.get(n);
            double d = Double.parseDouble(string);
            int n2 = string.indexOf(46) >= 0 ? string.substring(string.indexOf(46) + 1).length() : 0;
            precisionDecimal = new PrecisionDecimal(d, n2);
        }
        return precisionDecimal;
    }

    private static Map<Integer, String> generateMapOfAtomicNumberToMass() {
        String[] stringArray = "1, 1.00794\n2, 4.002602\n3, 6.941\n4, 9.012182\n5, 10.811\n6, 12.0107\n7, 14.0067\n8, 15.9994\n9, 18.9984032\n10, 20.1797\n11, 22.98976928\n12, 24.3050\n13, 26.9815386\n14, 28.0855\n15, 30.973762\n16, 32.065\n17, 35.453\n18, 39.948\n19, 39.0983\n20, 40.078\n21, 44.955912\n22, 47.867\n23, 50.9415\n24, 51.9961\n25, 54.938045\n26, 55.845\n27, 58.933195\n28, 58.6934\n29, 63.546\n30, 65.38\n31, 69.723\n32, 72.64\n33, 74.9216\n34, 78.96\n35, 79.904\n36, 83.798\n37, 85.4678\n38, 87.62\n39, 88.90585\n40, 91.224\n41, 92.90638\n42, 95.96\n43, 98\n44, 101.07\n45, 102.9055\n46, 106.42\n47, 107.8682\n48, 112.411\n49, 114.818\n50, 118.71\n51, 121.76\n52, 127.6\n53, 126.90447\n54, 131.293\n55, 132.9054519\n56, 137.327\n57, 138.90547\n58, 140.116\n59, 140.90765\n60, 144.242\n61, 145\n62, 150.36\n63, 151.964\n64, 157.25\n65, 158.92535\n66, 162.5\n67, 164.93032\n68, 167.259\n69, 168.93421\n70, 173.054\n71, 174.9668\n72, 178.49\n73, 180.94788\n74, 183.84\n75, 186.207\n76, 190.23\n77, 192.217\n78, 195.084\n79, 196.966569\n80, 200.59\n81, 204.3833\n82, 207.2\n83, 208.9804\n".split("\n");
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        boolean bl = false;
        for (String string : stringArray) {
            String[] stringArray2 = string.split(",");
            hashMap.put(Integer.parseInt(stringArray2[0]), stringArray2[1].trim());
        }
        return hashMap;
    }

    private static Map<IsotopeKey, IsotopeInfo> generateIsotopeInfoTable() {
        long l = System.currentTimeMillis();
        System.out.println("Entry, time = " + l);
        HashMap<IsotopeKey, IsotopeInfo> hashMap = new HashMap<IsotopeKey, IsotopeInfo>();
        String[] stringArray = "1,H,1,1.00782503207,0.999885\n,D,2,2.0141017778,0.000115\n,T,3,3.0160492777,1.0E-12\n2,He,3,3.0160293191,0.00000134\n,,4,4.00260325415,0.99999866\n3,Li,6,6.015122795,0.0759\n,,7,7.01600455,0.9241\n4,Be,9,9.0121822,1.0000\n5,B,10,10.0129370,0.199\n,,11,11.0093054,0.801\n6,C,12,12.0000000,0.9893\n,,13,13.0033548378,0.0107\n,,14,14.003241989,1.0E-12\n7,N,14,14.0030740048,0.99636\n,,15,15.0001088982,0.00364\n8,O,16,15.99491461956,0.99757\n,,17,16.99913170,0.00038\n,,18,17.9991610,0.00205\n9,F,19,18.99840322,1.0000\n10,Ne,20,19.9924401754,0.9048\n,,21,20.99384668,0.0027\n,,22,21.991385114,0.0925\n11,Na,23,22.9897692809,1.0000\n12,Mg,24,23.985041700,0.7899\n,,25,24.98583692,0.1000\n,,26,25.982592929,0.1101\n13,Al,27,26.98153863,1.0000\n14,Si,28,27.9769265325,0.92223\n,,29,28.976494700,0.04685\n,,30,29.97377017,0.03092\n15,P,31,30.97376163,1.0000\n16,S,32,31.97207100,0.9499\n,,33,32.97145876,0.0075\n,,34,33.96786690,0.0425\n,,36,35.96708076,0.0001\n17,Cl,35,34.96885268,0.7576\n,,37,36.96590259,0.2424\n18,Ar,36,35.967545106,0.003365\n,,38,37.9627324,0.000632\n,,40,39.9623831225,0.996003\n19,K,39,38.96370668,0.932581\n,,40,39.96399848,0.000117\n,,41,40.96182576,0.067302\n20,Ca,40,39.96259098,0.96941\n,,42,41.95861801,0.00647\n,,43,42.9587666,0.00135\n,,44,43.9554818,0.02086\n,,46,45.9536926,0.00004\n,,48,47.952534,0.00187\n21,Sc,45,44.9559119,1.0000\n22,Ti,46,45.9526316,0.0825\n,,47,46.9517631,0.0744\n,,48,47.9479463,0.7372\n,,49,48.9478700,0.0541\n,,50,49.9447912,0.0518\n23,V,50,49.9471585,0.00250\n,,51,50.9439595,0.99750\n24,Cr,50,49.9460442,0.04345\n,,52,51.9405075,0.83789\n,,53,52.9406494,0.09501\n,,54,53.9388804,0.02365\n25,Mn,55,54.9380451,1.0000\n26,Fe,54,53.9396105,0.05845\n,,56,55.9349375,0.91754\n,,57,56.9353940,0.02119\n,,58,57.9332756,0.00282\n27,Co,59,58.9331950,1.0000\n28,Ni,58,57.9353429,0.680769\n,,60,59.9307864,0.262231\n,,61,60.9310560,0.011399\n,,62,61.9283451,0.036345\n,,64,63.9279660,0.009256\n29,Cu,63,62.9295975,0.6915\n,,65,64.9277895,0.3085\n30,Zn,64,63.9291422,0.48268\n,,66,65.9260334,0.27975\n,,67,66.9271273,0.04102\n,,68,67.9248442,0.19024\n,,70,69.9253193,0.00631\n31,Ga,69,68.9255736,0.60108\n,,71,70.9247013,0.39892\n32,Ge,70,69.9242474,0.2038\n,,72,71.9220758,0.2731\n,,73,72.9234589,0.0776\n,,74,73.9211778,0.3672\n,,76,75.9214026,0.0783\n33,As,75,74.9215965,1.0000\n34,Se,74,73.9224764,0.0089\n,,76,75.9192136,0.0937\n,,77,76.9199140,0.0763\n,,78,77.9173091,0.2377\n,,80,79.9165213,0.4961\n,,82,81.9166994,0.0873\n35,Br,79,78.9183371,0.5069\n,,81,80.9162906,0.4931\n36,Kr,78,77.9203648,0.00355\n,,80,79.9163790,0.02286\n,,82,81.9134836,0.11593\n,,83,82.914136,0.11500\n,,84,83.911507,0.56987\n,,86,85.91061073,0.17279\n37,Rb,85,84.911789738,0.7217\n,,87,86.909180527,0.2783\n38,Sr,84,83.913425,0.0056\n,,86,85.9092602,0.0986\n,,87,86.9088771,0.0700\n,,88,87.9056121,0.8258\n39,Y,89,88.9058483,1.0000\n40,Zr,90,89.9047044,0.5145\n,,91,90.9056458,0.1122\n,,92,91.9050408,0.1715\n,,94,93.9063152,0.1738\n,,96,95.9082734,0.0280\n41,Nb,93,92.9063781,1.0000\n42,Mo,92,91.906811,0.1477\n,,94,93.9050883,0.0923\n,,95,94.9058421,0.1590\n,,96,95.9046795,0.1668\n,,97,96.9060215,0.0956\n,,98,97.9054082,0.2419\n,,100,99.907477,0.0967\n43,Tc,97,96.906365,\n,,98,97.907216,\n,,99,98.9062547,\n44,Ru,96,95.907598,0.0554\n,,98,97.905287,0.0187\n,,99,98.9059393,0.1276\n,,100,99.9042195,0.1260\n,,101,100.9055821,0.1706\n,,102,101.9043493,0.3155\n,,104,103.905433,0.1862\n45,Rh,103,102.905504,1.0000\n46,Pd,102,101.905609,0.0102\n,,104,103.904036,0.1114\n,,105,104.905085,0.2233\n,,106,105.903486,0.2733\n,,108,107.903892,0.2646\n,,110,109.905153,0.1172\n47,Ag,107,106.905097,0.51839\n,,109,108.904752,0.48161\n48,Cd,106,105.906459,0.0125\n,,108,107.904184,0.0089\n,,110,109.9030021,0.1249\n,,111,110.9041781,0.1280\n,,112,111.9027578,0.2413\n,,113,112.9044017,0.1222\n,,114,113.9033585,0.2873\n,,116,115.904756,0.0749\n49,In,113,112.904058,0.0429\n,,115,114.903878,0.9571\n50,Sn,112,111.904818,0.0097\n,,114,113.902779,0.0066\n,,115,114.903342,0.0034\n,,116,115.901741,0.1454\n,,117,116.902952,0.0768\n,,118,117.901603,0.2422\n,,119,118.903308,0.0859\n,,120,119.9021947,0.3258\n,,122,121.9034390,0.0463\n,,124,123.9052739,0.0579\n51,Sb,121,120.9038157,0.5721\n,,123,122.9042140,0.4279\n52,Te,120,119.904020,0.0009\n,,122,121.9030439,0.0255\n,,123,122.9042700,0.0089\n,,124,123.9028179,0.0474\n,,125,124.9044307,0.0707\n,,126,125.9033117,0.1884\n,,128,127.9044631,0.3174\n,,130,129.9062244,0.3408\n53,I,127,126.904473,1.0000\n54,Xe,124,123.9058930,0.000952\n,,126,125.904274,0.000890\n,,128,127.9035313,0.019102\n,,129,128.9047794,0.264006\n,,130,129.9035080,0.040710\n,,131,130.9050824,0.212324\n,,132,131.9041535,0.269086\n,,134,133.9053945,0.104357\n,,136,135.907219,0.088573\n55,Cs,133,132.905451933,1.0000\n56,Ba,130,129.9063208,0.00106\n,,132,131.9050613,0.00101\n,,134,133.9045084,0.02417\n,,135,134.9056886,0.06592\n,,136,135.9045759,0.07854\n,,137,136.9058274,0.11232\n,,138,137.9052472,0.71698\n57,La,138,137.907112,0.00090\n,,139,138.9063533,0.99910\n58,Ce,136,135.907172,0.00185\n,,138,137.905991,0.00251\n,,140,139.9054387,0.88450\n,,142,141.909244,0.11114\n59,Pr,141,140.9076528,1.0000\n60,Nd,142,141.9077233,0.272\n,,143,142.9098143,0.122\n,,144,143.9100873,0.238\n,,145,144.9125736,0.083\n,,146,145.9131169,0.172\n,,148,147.916893,0.057\n,,150,149.920891,0.056\n61,Pm,145,144.912749,\n,,147,146.9151385,\n62,Sm,144,143.911999,0.0307\n,,147,146.9148979,0.1499\n,,148,147.9148227,0.1124\n,,149,148.9171847,0.1382\n,,150,149.9172755,0.0738\n,,152,151.9197324,0.2675\n,,154,153.9222093,0.2275\n63,Eu,151,150.9198502,0.4781\n,,153,152.9212303,0.5219\n64,Gd,152,151.9197910,0.0020\n,,154,153.9208656,0.0218\n,,155,154.9226220,0.1480\n,,156,155.9221227,0.2047\n,,157,156.9239601,0.1565\n,,158,157.9241039,0.2484\n,,160,159.9270541,0.2186\n65,Tb,159,158.9253468,1.0000\n66,Dy,156,155.924283,0.00056\n,,158,157.924409,0.00095\n,,160,159.9251975,0.02329\n,,161,160.9269334,0.18889\n,,162,161.9267984,0.25475\n,,163,162.9287312,0.24896\n,,164,163.9291748,0.28260\n67,Ho,165,164.9303221,1.0000\n68,Er,162,161.928778,0.00139\n,,164,163.929200,0.01601\n,,166,165.9302931,0.33503\n,,167,166.9320482,0.22869\n,,168,167.9323702,0.26978\n,,170,169.9354643,0.14910\n69,Tm,169,168.9342133,1.0000\n70,Yb,168,167.933897,0.0013\n,,170,169.9347618,0.0304\n,,171,170.9363258,0.1428\n,,172,171.9363815,0.2183\n,,173,172.9382108,0.1613\n,,174,173.9388621,0.3183\n,,176,175.9425717,0.1276\n71,Lu,175,174.9407718,0.9741\n,,176,175.9426863,0.0259\n72,Hf,174,173.940046,0.0016\n,,176,175.9414086,0.0526\n,,177,176.9432207,0.1860\n,,178,177.9436988,0.2728\n,,179,178.9458161,0.1362\n,,180,179.9465500,0.3508\n73,Ta,180,179.9474648,0.00012\n,,181,180.9479958,0.99988\n74,W,180,179.946704,0.0012\n,,182,181.9482042,0.2650\n,,183,182.9502230,0.1431\n,,184,183.9509312,0.3064\n,,186,185.9543641,0.2843\n75,Re,185,184.9529550,0.3740\n,,187,186.9557531,0.6260\n76,Os,184,183.9524891,0.0002\n,,186,185.9538382,0.0159\n,,187,186.9557505,0.0196\n,,188,187.9558382,0.1324\n,,189,188.9581475,0.1615\n,,190,189.9584470,0.2626\n,,192,191.9614807,0.4078\n77,Ir,191,190.9605940,0.373\n,,193,192.9629264,0.627\n78,Pt,190,189.959932,0.00014\n,,192,191.9610380,0.00782\n,,194,193.9626803,0.32967\n,,195,194.9647911,0.33832\n,,196,195.9649515,0.25242\n,,198,197.967893,0.07163\n79,Au,197,196.9665687,1.0000\n80,Hg,196,195.965833,0.0015\n,,198,197.9667690,0.0997\n,,199,198.9682799,0.1687\n,,200,199.9683260,0.2310\n,,201,200.9703023,0.1318\n,,202,201.9706430,0.2986\n,,204,203.9734939,0.0687\n81,Tl,203,202.9723442,0.2952\n,,205,204.9744275,0.7048\n82,Pb,204,203.9730436,0.014\n,,206,205.9744653,0.241\n,,207,206.9758969,0.221\n,,208,207.9766521,0.524\n83,Bi,209,208.9803987,1.0000\n84,Po,209,208.9824304,\n,,210,209.9828737,\n85,At,210,209.987148,\n,,211,210.9874963,\n86,Rn,211,210.990601,\n,,220,220.0113940,\n,,222,222.0175777,\n87,Fr,223,223.0197359,\n88,Ra,223,223.0185022,\n,,224,224.0202118,\n,,226,226.0254098,\n,,228,228.0310703,\n89,Ac,227,227.0277521,\n90,Th,230,230.0331338,\n,,232,232.0380553,1.0000\n91,Pa,231,231.0358840,1.0000\n92,U,233,233.0396352,\n,,234,234.0409521,0.000054\n,,235,235.0439299,0.007204\n,,236,236.0455680,\n,,238,238.0507882,0.992742\n93,Np,236,236.046570,\n,,237,237.0481734,\n94,Pu,238,238.0495599,\n,,239,239.0521634,\n,,240,240.0538135,\n,,241,241.0568515,\n,,242,242.0587426,\n,,244,244.064204,\n95,Am,241,241.0568291,\n,,243,243.0613811,\n96,Cm,243,243.0613891,\n,,244,244.0627526,\n,,245,245.0654912,\n,,246,246.0672237,\n,,247,247.070354,\n,,248,248.072349,\n97,Bk,247,247.070307,\n,,249,249.0749867,\n98,Cf,249,249.0748535,\n,,250,250.0764061,\n,,251,251.079587,\n,,252,252.081626,\n99,Es,252,252.082980,\n100,Fm,257,257.095105,\n101,Md,258,258.098431,\n,,260,260.10365,\n102,No,259,259.10103,\n103,Lr,262,262.10963,\n104,Rf,265,265.11670,\n105,Db,268,268.12545,\n106,Sg,271,271.13347,\n107,Bh,272,272.13803,\n108,Hs,270,270.13465,\n109,Mt,276,276.15116,\n110,Ds,281,281.16206,\n111,Rg,280,280.16447,\n112,Cn,285,285.17411,\n113,Uut,284,284.17808,\n114,Uuq,289,289.18728,\n115,Uup,288,288.19249,\n".split("\n");
        int n = 0;
        String string = "";
        for (String string2 : stringArray) {
            String[] stringArray2 = string2.split(",");
            if (stringArray2[0].length() != 0) {
                n = Integer.parseInt(stringArray2[0]);
                string = stringArray2[1];
            }
            int n2 = Integer.parseInt(stringArray2[2]) - n;
            IsotopeKey isotopeKey = new IsotopeKey(n, Integer.parseInt(stringArray2[2]) - n);
            IsotopeInfo isotopeInfo = new IsotopeInfo();
            isotopeInfo.setAtomicMass(Double.parseDouble(stringArray2[3]));
            String string3 = stringArray2.length >= 5 ? stringArray2[4] : "0";
            int n3 = string3.indexOf(46) >= 0 ? string3.substring(string3.indexOf(46) + 1).length() : 0;
            isotopeInfo.setAbundance(new PrecisionDecimal(Double.parseDouble(string3), n3));
            isotopeInfo.setElementSymbol(string);
            hashMap.put(isotopeKey, isotopeInfo);
        }
        AtomIdentifier.setIsotopeName(0, hashMap, BuildAnAtomStrings.ELEMENT_NONE_NAME);
        AtomIdentifier.setIsotopeName(1, hashMap, BuildAnAtomStrings.ELEMENT_HYDROGEN_NAME);
        AtomIdentifier.setIsotopeName(2, hashMap, BuildAnAtomStrings.ELEMENT_HELIUM_NAME);
        AtomIdentifier.setIsotopeName(3, hashMap, BuildAnAtomStrings.ELEMENT_LITHIUM_NAME);
        AtomIdentifier.setIsotopeName(4, hashMap, BuildAnAtomStrings.ELEMENT_BERYLLIUM_NAME);
        AtomIdentifier.setIsotopeName(5, hashMap, BuildAnAtomStrings.ELEMENT_BORON_NAME);
        AtomIdentifier.setIsotopeName(6, hashMap, BuildAnAtomStrings.ELEMENT_CARBON_NAME);
        AtomIdentifier.setIsotopeName(7, hashMap, BuildAnAtomStrings.ELEMENT_NITROGEN_NAME);
        AtomIdentifier.setIsotopeName(8, hashMap, BuildAnAtomStrings.ELEMENT_OXYGEN_NAME);
        AtomIdentifier.setIsotopeName(9, hashMap, BuildAnAtomStrings.ELEMENT_FLUORINE_NAME);
        AtomIdentifier.setIsotopeName(10, hashMap, BuildAnAtomStrings.ELEMENT_NEON_NAME);
        AtomIdentifier.setIsotopeName(11, hashMap, BuildAnAtomStrings.ELEMENT_SODIUM_NAME);
        AtomIdentifier.setIsotopeName(12, hashMap, BuildAnAtomStrings.ELEMENT_MAGNESIUM_NAME);
        AtomIdentifier.setIsotopeName(13, hashMap, BuildAnAtomStrings.ELEMENT_ALUMINUM_NAME);
        AtomIdentifier.setIsotopeName(14, hashMap, BuildAnAtomStrings.ELEMENT_SILICON_NAME);
        AtomIdentifier.setIsotopeName(15, hashMap, BuildAnAtomStrings.ELEMENT_PHOSPHORUS_NAME);
        AtomIdentifier.setIsotopeName(16, hashMap, BuildAnAtomStrings.ELEMENT_SULFUR_NAME);
        AtomIdentifier.setIsotopeName(17, hashMap, BuildAnAtomStrings.ELEMENT_CHLORINE_NAME);
        AtomIdentifier.setIsotopeName(18, hashMap, BuildAnAtomStrings.ELEMENT_ARGON_NAME);
        for (IsotopeKey isotopeKey : hashMap.keySet()) {
            ((IsotopeInfo)hashMap.get(isotopeKey)).setElementSymbol(isotopeKey.getNumProtons() < SymbolTable.ELEMENT_SYMBOL_TABLE.length ? SymbolTable.ELEMENT_SYMBOL_TABLE[isotopeKey.getNumProtons()] : BuildAnAtomStrings.ELEMENT_NONE_SYMBOL);
            ((IsotopeInfo)hashMap.get(isotopeKey)).setStable(STABLE_ISOTOPES.contains(isotopeKey));
        }
        System.out.println("Table created, time to create = " + (System.currentTimeMillis() - l));
        return hashMap;
    }

    private static List<IsotopeInfo> getMatchingIsotopes(int n, Map<IsotopeKey, IsotopeInfo> map) {
        ArrayList<IsotopeInfo> arrayList = new ArrayList<IsotopeInfo>();
        for (IsotopeKey isotopeKey : map.keySet()) {
            if (isotopeKey.getNumProtons() != n) continue;
            arrayList.add(map.get(isotopeKey));
        }
        return arrayList;
    }

    private static void setIsotopeName(int n, Map<IsotopeKey, IsotopeInfo> map, String string) {
        for (IsotopeInfo isotopeInfo : AtomIdentifier.getMatchingIsotopes(n, map)) {
            isotopeInfo.setElementName(string);
        }
    }

    private static class IsotopeInfo {
        public double atomicMass;
        public String elementSymbol;
        public String elementName;
        public PrecisionDecimal abundance;
        public boolean stable;

        public double getAtomicMass() {
            return this.atomicMass;
        }

        public void setAtomicMass(double d) {
            this.atomicMass = d;
        }

        public void setElementSymbol(String string) {
            this.elementSymbol = string;
        }

        public String getElementName() {
            return this.elementName;
        }

        public void setElementName(String string) {
            this.elementName = string;
        }

        public PrecisionDecimal getAbundance() {
            return this.abundance;
        }

        public void setAbundance(PrecisionDecimal precisionDecimal) {
            this.abundance = precisionDecimal;
        }

        public boolean isStable() {
            return this.stable;
        }

        public void setStable(boolean bl) {
            this.stable = bl;
        }
    }

    private static class IsotopeKey {
        private final int numProtons;
        private final int numNeutrons;

        public IsotopeKey(IAtom iAtom) {
            this(iAtom.getNumProtons(), iAtom.getNumNeutrons());
        }

        public IsotopeKey(int n, int n2) {
            this.numProtons = n;
            this.numNeutrons = n2;
        }

        public int getNumProtons() {
            return this.numProtons;
        }

        public int getNumNeutrons() {
            return this.numNeutrons;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            IsotopeKey isotopeKey = (IsotopeKey)object;
            if (this.numProtons != isotopeKey.getNumProtons()) {
                return false;
            }
            return this.numNeutrons == isotopeKey.getNumNeutrons();
        }

        public int hashCode() {
            int n = this.numProtons;
            n = 31 * n + this.numNeutrons;
            return n;
        }
    }
}

