/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.model;

import edu.colorado.phet.buildanatom.BuildAnAtomStrings;
import edu.colorado.phet.buildanatom.model.Atom;
import edu.colorado.phet.buildanatom.model.BuildAnAtomClock;
import edu.colorado.phet.buildanatom.model.Electron;
import edu.colorado.phet.buildanatom.model.ImmutableAtom;
import edu.colorado.phet.buildanatom.model.Neutron;
import edu.colorado.phet.buildanatom.model.Proton;
import edu.colorado.phet.buildanatom.model.SphericalParticle;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.SphereBucket;
import edu.colorado.phet.common.phetcommon.view.PhetColorScheme;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildAnAtomModel
implements Resettable {
    private static final Dimension2D BUCKET_SIZE = new PDimension(60.0, 30.0);
    private static final Point2D PROTON_BUCKET_POSITION = new Point2D.Double(-80.0, -150.0);
    private static final Point2D NEUTRON_BUCKET_POSITION = new Point2D.Double(0.0, -150.0);
    private static final Point2D ELECTRON_BUCKET_POSITION = new Point2D.Double(80.0, -150.0);
    private final BuildAnAtomClock clock;
    private final Atom atom;
    private final ArrayList<Electron> electrons = new ArrayList();
    private final ArrayList<Proton> protons = new ArrayList();
    private final ArrayList<Neutron> neutrons = new ArrayList();
    private final SphereBucket<SphericalParticle> electronBucket = new SphereBucket(ELECTRON_BUCKET_POSITION, BUCKET_SIZE, Color.blue, BuildAnAtomStrings.ELECTRONS_NAME, 3.0, 0.6, -1.5);
    private final SphereBucket<SphericalParticle> protonBucket = new SphereBucket(PROTON_BUCKET_POSITION, BUCKET_SIZE, PhetColorScheme.RED_COLORBLIND, BuildAnAtomStrings.PROTONS_NAME, 5.0);
    private final SphereBucket<SphericalParticle> neutronBucket = new SphereBucket(NEUTRON_BUCKET_POSITION, BUCKET_SIZE, Color.gray, BuildAnAtomStrings.NEUTRONS_NAME, 5.0);

    public BuildAnAtomModel(BuildAnAtomClock buildAnAtomClock) {
        this(buildAnAtomClock, new ImmutableAtom(10, 13, 10));
    }

    public BuildAnAtomModel(BuildAnAtomClock buildAnAtomClock, ImmutableAtom immutableAtom, boolean bl) {
        this(buildAnAtomClock, immutableAtom);
        this.setState(immutableAtom, bl);
    }

    public BuildAnAtomModel(BuildAnAtomClock buildAnAtomClock, ImmutableAtom immutableAtom) {
        SphericalParticle sphericalParticle;
        int n;
        this.clock = buildAnAtomClock;
        this.atom = new Atom(new Point2D.Double(0.0, 0.0), buildAnAtomClock);
        for (n = 0; n < immutableAtom.getNumElectrons(); ++n) {
            sphericalParticle = new Electron(buildAnAtomClock);
            this.electrons.add((Electron)sphericalParticle);
            sphericalParticle.addListener(new SphericalParticle.Adapter((Electron)sphericalParticle){
                final /* synthetic */ Electron val$electron;
                {
                    this.val$electron = electron;
                }

                public void droppedByUser(SphericalParticle sphericalParticle) {
                    if (BuildAnAtomModel.this.atom.getRemainingElectronCapacity() > 0 && this.val$electron.getPosition().distance(BuildAnAtomModel.this.atom.getPosition()) < 122.0) {
                        BuildAnAtomModel.this.atom.addElectron(this.val$electron, false);
                    } else {
                        BuildAnAtomModel.this.electronBucket.addParticleNearestOpen(this.val$electron, false);
                    }
                }
            });
        }
        for (n = 0; n < immutableAtom.getNumProtons(); ++n) {
            sphericalParticle = new Proton(buildAnAtomClock);
            this.protons.add((Proton)sphericalParticle);
            sphericalParticle.addListener(new SphericalParticle.Adapter((Proton)sphericalParticle){
                final /* synthetic */ Proton val$proton;
                {
                    this.val$proton = proton;
                }

                public void droppedByUser(SphericalParticle sphericalParticle) {
                    if (this.val$proton.getPosition().distance(BuildAnAtomModel.this.atom.getPosition()) < 34.0) {
                        BuildAnAtomModel.this.atom.addProton(this.val$proton, false);
                    } else {
                        BuildAnAtomModel.this.protonBucket.addParticleNearestOpen(this.val$proton, false);
                    }
                }
            });
        }
        for (n = 0; n < immutableAtom.getNumNeutrons(); ++n) {
            sphericalParticle = new Neutron(buildAnAtomClock);
            this.neutrons.add((Neutron)sphericalParticle);
            sphericalParticle.addListener(new SphericalParticle.Adapter((Neutron)sphericalParticle){
                final /* synthetic */ Neutron val$neutron;
                {
                    this.val$neutron = neutron;
                }

                public void droppedByUser(SphericalParticle sphericalParticle) {
                    if (this.val$neutron.getPosition().distance(BuildAnAtomModel.this.atom.getPosition()) < 34.0) {
                        BuildAnAtomModel.this.atom.addNeutron(this.val$neutron, false);
                    } else {
                        BuildAnAtomModel.this.neutronBucket.addParticleNearestOpen(this.val$neutron, false);
                    }
                }
            });
        }
        this.initializeBuckets();
    }

    @Override
    public void reset() {
        this.atom.reset();
        this.electronBucket.reset();
        this.neutronBucket.reset();
        this.protonBucket.reset();
        this.initializeBuckets();
    }

    private void initializeBuckets() {
        for (Electron sphericalParticle : this.electrons) {
            this.electronBucket.addParticleFirstOpen(sphericalParticle, true);
        }
        for (Proton proton : this.protons) {
            this.protonBucket.addParticleFirstOpen(proton, true);
        }
        for (Neutron neutron : this.neutrons) {
            this.neutronBucket.addParticleFirstOpen(neutron, true);
        }
    }

    public Atom getAtom() {
        return this.atom;
    }

    public BuildAnAtomClock getClock() {
        return this.clock;
    }

    public SphereBucket<SphericalParticle> getElectronBucket() {
        return this.electronBucket;
    }

    public SphereBucket<SphericalParticle> getProtonBucket() {
        return this.protonBucket;
    }

    public SphereBucket<SphericalParticle> getNeutronBucket() {
        return this.neutronBucket;
    }

    public static <T> ArrayList<T> reverse(ArrayList<T> arrayList) {
        ArrayList<T> arrayList2 = new ArrayList<T>(arrayList);
        Collections.reverse(arrayList2);
        return arrayList2;
    }

    public Proton getFreeProton() {
        for (Proton proton : BuildAnAtomModel.reverse(this.protons)) {
            if (this.getAtom().containsProton(proton)) continue;
            return proton;
        }
        return null;
    }

    public Neutron getFreeNeutron() {
        for (Neutron neutron : BuildAnAtomModel.reverse(this.neutrons)) {
            if (this.getAtom().containsNeutron(neutron)) continue;
            return neutron;
        }
        return null;
    }

    public Electron getFreeElectron() {
        for (Electron electron : BuildAnAtomModel.reverse(this.electrons)) {
            if (this.getAtom().containsElectron(electron)) continue;
            return electron;
        }
        return null;
    }

    public void setState(ImmutableAtom immutableAtom, boolean bl) {
        ArrayList<SphericalParticle> arrayList = this.getAtom().setState(immutableAtom, this, bl);
        for (SphericalParticle sphericalParticle : arrayList) {
            if (sphericalParticle instanceof Proton) {
                this.protonBucket.addParticleNearestOpen(sphericalParticle, bl);
                continue;
            }
            if (sphericalParticle instanceof Electron) {
                this.electronBucket.addParticleNearestOpen(sphericalParticle, bl);
                continue;
            }
            if (!(sphericalParticle instanceof Neutron)) continue;
            this.neutronBucket.addParticleNearestOpen(sphericalParticle, bl);
        }
    }
}

