/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.model;

import edu.colorado.phet.buildanatom.model.Electron;
import edu.colorado.phet.buildanatom.model.SphericalParticle;
import edu.colorado.phet.common.phetcommon.util.SimpleObservable;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElectronShell
extends SimpleObservable {
    private final double radius;
    private final HashMap<Point2D, Electron> shellLocations = new HashMap();
    private final int electronCapacity;
    private final Point2D centerLocation = new Point2D.Double(0.0, 0.0);
    private final SphericalParticle.Adapter particleRemovalListener = new SphericalParticle.Adapter(){

        public void grabbedByUser(SphericalParticle sphericalParticle) {
            ElectronShell.this.removeElectron((Electron)sphericalParticle);
        }
    };

    ElectronShell(double d, int n, Point2D point2D) {
        this.radius = d;
        this.electronCapacity = n;
        this.centerLocation.setLocation(point2D);
        double d2 = Math.PI * 2 / (double)n;
        for (int i = 0; i < n; ++i) {
            double d3 = (double)i * d2;
            this.shellLocations.put(new Point2D.Double(this.radius * Math.cos(d3), this.radius * Math.sin(d3)), null);
        }
    }

    private Point2D getKey(SphericalParticle sphericalParticle) {
        assert (sphericalParticle != null);
        for (Point2D point2D : this.shellLocations.keySet()) {
            if (this.shellLocations.get(point2D) != sphericalParticle) continue;
            return point2D;
        }
        return null;
    }

    public Electron getClosestElectron(Point2D point2D) {
        Electron electron = null;
        for (Electron electron2 : this.shellLocations.values()) {
            if (electron2 == null) continue;
            if (electron == null) {
                electron = electron2;
                continue;
            }
            if (!(electron2.getPosition().distance(point2D) < electron.getPosition().distance(point2D))) continue;
            electron = electron2;
        }
        return electron;
    }

    public ArrayList<Point2D> getOpenShellLocations() {
        ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
        for (Point2D point2D : this.shellLocations.keySet()) {
            if (this.shellLocations.get(point2D) != null) continue;
            arrayList.add(point2D);
        }
        return arrayList;
    }

    public int getNumElectrons() {
        return this.shellLocations.size() - this.getOpenShellLocations().size();
    }

    public int getNumOpenLocations() {
        return this.getOpenShellLocations().size();
    }

    public int getElectronCapacity() {
        return this.electronCapacity;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setCenterLocation(double d, double d2) {
        this.centerLocation.setLocation(d, d2);
        this.notifyObservers();
    }

    public Point2D getCenterLocation() {
        return new Point2D.Double(this.centerLocation.getX(), this.centerLocation.getY());
    }

    protected boolean isFull() {
        return this.getOpenShellLocations().size() == 0;
    }

    protected boolean isEmpty() {
        return this.getOpenShellLocations().size() == this.shellLocations.size();
    }

    protected void reset() {
        if (this.getNumElectrons() > 0) {
            for (Electron object : this.shellLocations.values()) {
                if (object == null) continue;
                object.removeListener(this.particleRemovalListener);
            }
            for (Point2D point2D : this.shellLocations.keySet()) {
                this.shellLocations.put(point2D, null);
            }
            this.notifyObservers();
        }
    }

    protected void addElectron(Electron electron, boolean bl) {
        Point2D point2D = this.findClosestOpenLocation(electron.getPosition().toPoint2D());
        if (point2D == null) {
            System.err.println(this.getClass().getName() + " - Error: No space in shell.");
        }
        assert (point2D != null);
        electron.setDestination(point2D);
        this.shellLocations.put(point2D, electron);
        electron.addListener(this.particleRemovalListener);
        if (bl) {
            electron.moveToDestination();
        }
        this.notifyObservers();
    }

    public Electron removeElectron(Electron electron) {
        assert (this.shellLocations.containsValue(electron));
        assert (electron != null);
        if (this.shellLocations.containsValue(electron)) {
            this.shellLocations.put(this.getKey(electron), null);
            electron.removeListener(this.particleRemovalListener);
            this.notifyObservers();
            return electron;
        }
        return null;
    }

    public Electron removeElectron() {
        assert (this.getNumElectrons() > 0);
        for (Electron electron : this.shellLocations.values()) {
            if (electron == null) continue;
            return this.removeElectron(electron);
        }
        return null;
    }

    private Point2D findClosestOpenLocation(Point2D point2D) {
        ArrayList<Point2D> arrayList = this.getOpenShellLocations();
        if (arrayList.size() == 0) {
            return null;
        }
        Point2D point2D2 = null;
        for (Point2D point2D3 : arrayList) {
            if (point2D2 != null && !(point2D2.distance(point2D) > point2D3.distance(point2D))) continue;
            point2D2 = point2D3;
        }
        return point2D2;
    }

    public boolean containsElectron(Electron electron) {
        return this.shellLocations.containsValue(electron);
    }

    @Override
    public void addObserver(SimpleObserver simpleObserver) {
        super.addObserver(simpleObserver);
        simpleObserver.update();
    }

    public ArrayList<Electron> getElectrons() {
        ArrayList<Electron> arrayList = new ArrayList<Electron>();
        for (Electron electron : this.shellLocations.values()) {
            if (electron == null) continue;
            arrayList.add(electron);
        }
        return arrayList;
    }
}

