/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.model;

import edu.colorado.phet.buildanatom.model.ImmutableAtom;
import edu.colorado.phet.buildanatom.model.SphericalParticle;
import edu.colorado.phet.buildanatom.modules.isotopemixture.model.MovableAtom;
import edu.colorado.phet.common.phetcommon.model.SphereBucket;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonoIsotopeParticleBucket
extends SphereBucket<SphericalParticle> {
    private final Dimension2D size = new PDimension();
    private int numProtonsInIsotope = 0;
    private int numNeutronsInIsotope = 0;

    public MonoIsotopeParticleBucket(Point2D point2D, Dimension2D dimension2D, Color color, String string, double d, int n, int n2) {
        super(point2D, dimension2D, color, string, d);
        this.size.setSize(dimension2D);
        this.numProtonsInIsotope = n;
        this.numNeutronsInIsotope = n2;
    }

    public void addIsotopeInstanceFirstOpen(MovableAtom movableAtom, boolean bl) {
        if (this.isIsotopeAllowed(movableAtom.getAtomConfiguration())) {
            this.addParticleFirstOpen(movableAtom, bl);
        }
    }

    public void addIsotopeInstanceNearestOpen(MovableAtom movableAtom, boolean bl) {
        if (this.isIsotopeAllowed(movableAtom.getAtomConfiguration())) {
            this.addParticleNearestOpen(movableAtom, bl);
        }
    }

    public boolean isIsotopeAllowed(int n, int n2) {
        return this.numProtonsInIsotope == n && this.numNeutronsInIsotope == n2;
    }

    public boolean isIsotopeAllowed(ImmutableAtom immutableAtom) {
        return this.isIsotopeAllowed(immutableAtom.getNumProtons(), immutableAtom.getNumNeutrons());
    }

    public MovableAtom removeArbitraryIsotope() {
        MovableAtom movableAtom = null;
        if (this.getParticleList().size() > 0) {
            movableAtom = (MovableAtom)this.getParticleList().get(this.getParticleList().size() - 1);
            this.removeParticle(movableAtom);
        } else {
            System.err.println(this.getClass().getName() + " - Warning: Ignoring attempt to remove particle from empty bucket.");
        }
        return movableAtom;
    }

    public List<MovableAtom> getContainedIsotopes() {
        ArrayList<MovableAtom> arrayList = new ArrayList<MovableAtom>();
        for (SphericalParticle sphericalParticle : this.getParticleList()) {
            assert (sphericalParticle instanceof MovableAtom);
            arrayList.add((MovableAtom)sphericalParticle);
        }
        return arrayList;
    }
}

