/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.model;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.IBucketSphere;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SphericalParticle
implements IBucketSphere<SphericalParticle> {
    private final double radius;
    private final Property<Vector2D> position;
    private final Property<Boolean> userControlled = new Property<Boolean>(false);
    private final HashSet<IBucketSphere.Listener<SphericalParticle>> listeners = new HashSet();
    private Vector2D destination = new Vector2D();
    private final ClockAdapter clockListener = new ClockAdapter(){

        public void clockTicked(ClockEvent clockEvent) {
            SphericalParticle.this.stepInTime(clockEvent.getSimulationTimeChange());
        }
    };
    private final ConstantDtClock clock;
    private double motionVelocity = 120.0;

    public SphericalParticle(double d, double d2, double d3, ConstantDtClock constantDtClock) {
        this.clock = constantDtClock;
        this.radius = d;
        this.position = new Property<Vector2D>(new Vector2D(d2, d3));
        this.destination = new Vector2D(d2, d3);
        this.addedToModel();
        this.userControlled.addObserver(new SimpleObserver(){

            public void update() {
                ArrayList arrayList = new ArrayList(SphericalParticle.this.listeners);
                if (((Boolean)SphericalParticle.this.userControlled.get()).booleanValue()) {
                    for (IBucketSphere.Listener listener : arrayList) {
                        listener.grabbedByUser(SphericalParticle.this);
                    }
                } else {
                    for (IBucketSphere.Listener listener : arrayList) {
                        listener.droppedByUser(SphericalParticle.this);
                    }
                }
            }
        });
    }

    @Override
    public void addListener(IBucketSphere.Listener<SphericalParticle> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IBucketSphere.Listener<SphericalParticle> listener) {
        this.listeners.remove(listener);
    }

    private void stepInTime(double d) {
        if (this.getPosition().distance(this.destination) != 0.0) {
            double d2 = this.motionVelocity * d;
            if (d2 >= this.getPosition().distance(this.destination)) {
                this.setPosition(this.destination);
            } else {
                double d3 = Math.atan2(this.destination.getY() - this.getPosition().getY(), this.destination.getX() - this.getPosition().getX());
                this.translate(d2 * Math.cos(d3), d2 * Math.sin(d3));
            }
        }
    }

    @Override
    public Vector2D getPosition() {
        return this.position.get();
    }

    @Override
    public Vector2D getDestination() {
        return new Vector2D(this.destination.getX(), this.destination.getY());
    }

    public void setPosition(Vector2D vector2D) {
        this.setPosition(vector2D.getX(), vector2D.getY());
    }

    public void setPosition(Point2D point2D) {
        this.setPosition(point2D.getX(), point2D.getY());
    }

    public void setPosition(double d, double d2) {
        this.position.set(new Vector2D(d, d2));
    }

    @Override
    public void setDestination(Vector2D vector2D) {
        this.setDestination(vector2D.getX(), vector2D.getY());
    }

    public void setDestination(Point2D point2D) {
        this.setDestination(point2D.getX(), point2D.getY());
    }

    public void setDestination(double d, double d2) {
        this.destination = new Vector2D(d, d2);
    }

    public void setPositionAndDestination(double d, double d2) {
        this.setPosition(d, d2);
        this.setDestination(d, d2);
    }

    @Override
    public void setPositionAndDestination(Vector2D vector2D) {
        this.setPosition(vector2D);
        this.setDestination(vector2D);
    }

    public void setPositionAndDestination(Point2D point2D) {
        this.setPosition(point2D);
        this.setDestination(point2D);
    }

    public double getDiameter() {
        return this.getRadius() * 2.0;
    }

    @Override
    public double getRadius() {
        return this.radius;
    }

    public boolean isUserControlled() {
        return this.userControlled.get();
    }

    public void setUserControlled(boolean bl) {
        this.userControlled.set(bl);
    }

    public void translate(double d, double d2) {
        this.setPosition(this.position.get().getX() + d, this.position.get().getY() + d2);
    }

    public void translate(Vector2D vector2D) {
        this.translate(vector2D.getX(), vector2D.getY());
    }

    public void removedFromModel() {
        if (this.clock != null) {
            this.clock.removeClockListener(this.clockListener);
        }
        ArrayList<IBucketSphere.Listener<SphericalParticle>> arrayList = new ArrayList<IBucketSphere.Listener<SphericalParticle>>(this.listeners);
        for (IBucketSphere.Listener<SphericalParticle> listener : arrayList) {
            listener.removedFromModel(this);
        }
    }

    public void addedToModel() {
        if (this.clock != null) {
            this.clock.addClockListener(this.clockListener);
        }
    }

    @Override
    public void addPositionListener(SimpleObserver simpleObserver) {
        this.position.addObserver(simpleObserver);
    }

    @Override
    public void removePositionListener(SimpleObserver simpleObserver) {
        this.position.removeObserver(simpleObserver);
    }

    public void moveToDestination() {
        this.setPosition(this.getDestination());
    }

    public void setMotionVelocity(double d) {
        this.motionVelocity = d;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Adapter
    extends IBucketSphere.Adapter<SphericalParticle>
    implements Listener {
    }

    public static interface Listener
    extends IBucketSphere.Listener {
    }
}

