/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.modules.game.view;

import edu.colorado.phet.buildanatom.model.AtomIdentifier;
import edu.colorado.phet.buildanatom.model.ImmutableAtom;
import edu.colorado.phet.buildanatom.modules.game.view.ValueNode;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SignedIntegerFormat;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.Function0;
import edu.colorado.phet.common.phetcommon.view.PhetColorScheme;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import javax.swing.event.ChangeListener;

public class InteractiveSymbolNode
extends PNode {
    private static final Font SYMBOL_FONT = new PhetFont(90, true);
    private static final Font ELEMENT_NAME_FONT = new PhetFont(30, false);
    private final Property<Integer> massProperty;
    private final Property<Integer> protonCountProperty;
    private final Property<Integer> chargeProperty;
    private final Property<Boolean> interactiveProtonCountProperty;
    private final Property<Boolean> interactiveMassProperty;
    private final Property<Boolean> interactiveChargeProperty;

    public InteractiveSymbolNode(ImmutableAtom immutableAtom, boolean bl, boolean bl2, boolean bl3) {
        this.interactiveProtonCountProperty = new Property<Boolean>(bl);
        this.interactiveMassProperty = new Property<Boolean>(bl2);
        this.interactiveChargeProperty = new Property<Boolean>(bl3);
        this.protonCountProperty = new Property<Integer>(bl ? 0 : immutableAtom.getNumProtons());
        this.massProperty = new Property<Integer>(bl2 ? 0 : immutableAtom.getMassNumber());
        this.chargeProperty = new Property<Integer>(bl3 ? 0 : immutableAtom.getCharge());
        final PhetPPath phetPPath = new PhetPPath(new Rectangle2D.Double(0.0, 0.0, 200.0, 200.0), Color.white, new BasicStroke(3.0f), Color.black);
        this.addChild(phetPPath);
        final PText pText = new PText(){
            {
                this.setFont(SYMBOL_FONT);
            }
        };
        this.addChild(pText);
        final PText pText2 = new PText(){
            {
                this.setFont(ELEMENT_NAME_FONT);
                this.setTextPaint(PhetColorScheme.RED_COLORBLIND);
            }
        };
        this.addChild(pText2);
        ValueNode valueNode = new ValueNode(this.protonCountProperty, 0, 20, 1, this.interactiveProtonCountProperty, ValueNode.DEFAULT_NUMBER_FORMAT, new Function0.Constant<Color>(PhetColorScheme.RED_COLORBLIND));
        valueNode.setScale(35.0 / valueNode.getFullBoundsReference().height);
        valueNode.setOffset(5.0, 200.0 - valueNode.getFullBoundsReference().height - 5.0);
        this.addChild(valueNode);
        this.protonCountProperty.addObserver(new SimpleObserver(){

            public void update() {
                pText.setText((Integer)InteractiveSymbolNode.this.protonCountProperty.get() == 0 ? "-" : AtomIdentifier.getSymbol((Integer)InteractiveSymbolNode.this.protonCountProperty.get()));
                pText.setOffset(100.0 - pText.getFullBoundsReference().width / 2.0, 100.0 - pText.getFullBoundsReference().height / 2.0);
                pText2.setText(AtomIdentifier.getName((Integer)InteractiveSymbolNode.this.protonCountProperty.get()));
                pText2.setOffset(phetPPath.getFullBoundsReference().getCenterX() - pText2.getFullBoundsReference().width / 2.0, phetPPath.getFullBoundsReference().getMaxY() + 5.0);
                pText2.setVisible((Integer)InteractiveSymbolNode.this.protonCountProperty.get() != 0);
            }
        });
        final ValueNode valueNode2 = new ValueNode(this.massProperty, 0, 50, 1, this.interactiveMassProperty, ValueNode.DEFAULT_NUMBER_FORMAT, new Function0.Constant<Color>(Color.black));
        valueNode2.setScale(35.0 / valueNode2.getFullBoundsReference().height);
        valueNode2.setOffset(5.0, 5.0);
        this.addChild(valueNode2);
        ValueNode valueNode3 = new ValueNode(this.chargeProperty, -20, 20, 1, this.interactiveChargeProperty, new SignedIntegerFormat(), new Function0<Color>(){

            @Override
            public Color apply() {
                int n = (Integer)InteractiveSymbolNode.this.chargeProperty.get();
                Color color = n > 0 ? PhetColorScheme.RED_COLORBLIND : (n < 0 ? Color.blue : Color.black);
                return color;
            }
        }){
            {
                super(property, n, n2, n3, property2, numberFormat, function0);
                this.setScale(35.0 / this.getFullBoundsReference().height);
                double d = 200.0 - this.getFullBoundsReference().width - 5.0;
                if (d < valueNode2.getFullBoundsReference().getMaxX()) {
                    d = valueNode2.getFullBoundsReference().getMaxX() + 5.0;
                }
                this.setOffset(d, 5.0);
            }
        };
        this.addChild(valueNode3);
    }

    public ImmutableAtom getGuess() {
        int n = this.protonCountProperty.get();
        int n2 = this.massProperty.get();
        int n3 = this.chargeProperty.get();
        return new ImmutableAtom(n, n2 - n, n - n3);
    }

    public void displayAnswer(ImmutableAtom immutableAtom) {
        this.interactiveProtonCountProperty.set(false);
        this.interactiveMassProperty.set(false);
        this.interactiveChargeProperty.set(false);
        this.protonCountProperty.set(immutableAtom.getNumProtons());
        this.massProperty.set(immutableAtom.getMassNumber());
        this.chargeProperty.set(immutableAtom.getCharge());
    }

    public void addChangeListener(final ChangeListener changeListener) {
        SimpleObserver simpleObserver = new SimpleObserver(){

            public void update() {
                changeListener.stateChanged(null);
            }
        };
        this.massProperty.addObserver(simpleObserver, false);
        this.protonCountProperty.addObserver(simpleObserver, false);
        this.chargeProperty.addObserver(simpleObserver, false);
    }
}

