/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.modules.game.view;

import edu.colorado.phet.buildanatom.BuildAnAtomDefaults;
import edu.colorado.phet.buildanatom.BuildAnAtomStrings;
import edu.colorado.phet.buildanatom.model.BuildAnAtomClock;
import edu.colorado.phet.buildanatom.model.ImmutableAtom;
import edu.colorado.phet.buildanatom.modules.game.model.BuildAnAtomGameModel;
import edu.colorado.phet.buildanatom.modules.game.model.Problem;
import edu.colorado.phet.buildanatom.modules.game.view.BuildAnAtomGameCanvas;
import edu.colorado.phet.buildanatom.modules.game.view.StateView;
import edu.colorado.phet.common.games.GameAudioPlayer;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.FaceNode;
import edu.colorado.phet.common.piccolophet.nodes.HTMLImageButtonNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.text.MessageFormat;

public abstract class ProblemView
extends StateView {
    private static final Color FACE_COLOR = new Color(255, 255, 0, 180);
    private static final Point2D BUTTON_OFFSET = new Point2D.Double(720.0, 550.0);
    public static final ModelViewTransform SCHEMATIC_PROBLEM_MVT = ModelViewTransform.createSinglePointScaleInvertedYMapping(new Point2D.Double(0.0, 0.0), new Point((int)Math.round(BuildAnAtomDefaults.STAGE_SIZE.width * 0.27), (int)Math.round(BuildAnAtomDefaults.STAGE_SIZE.height * 0.45)), 2.0);
    private final GameButtonNode checkButton;
    private final PText problemNumberDisplay;
    private final PNode resultNode = new PNode();
    private final GameAudioPlayer gameAudioPlayer;
    private final Problem problem;
    private final BuildAnAtomClock clock = new BuildAnAtomClock();

    ProblemView(BuildAnAtomGameModel buildAnAtomGameModel, BuildAnAtomGameCanvas buildAnAtomGameCanvas, final Problem problem) {
        super(buildAnAtomGameModel, problem, buildAnAtomGameCanvas);
        this.problem = problem;
        this.gameAudioPlayer = new GameAudioPlayer(buildAnAtomGameModel.isSoundEnabled());
        this.gameAudioPlayer.init();
        int n = buildAnAtomGameModel.getProblemIndex(problem) + 1;
        int n2 = buildAnAtomGameModel.getNumberProblems();
        this.problemNumberDisplay = new PText(MessageFormat.format(BuildAnAtomStrings.GAME_PROBLEM_INDEX_READOUT_PATTERN, n, n2)){
            {
                this.setFont(new PhetFont(20, true));
            }
        };
        this.problemNumberDisplay.setOffset(30.0, 30.0);
        this.checkButton = new GameButtonNode(BuildAnAtomStrings.GAME_CHECK, BUTTON_OFFSET, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProblemView.this.getModel().processGuess(ProblemView.this.getGuess());
                final FaceNode faceNode = new FaceNode(400.0, FACE_COLOR, new Color(180, 180, 180, 120), new Color(180, 180, 180, 120));
                faceNode.setOffset(BuildAnAtomDefaults.STAGE_SIZE.getWidth() / 2.0 - faceNode.getFullBounds().getWidth() / 2.0, BuildAnAtomDefaults.STAGE_SIZE.getHeight() / 2.0 - faceNode.getFullBounds().getHeight() / 2.0);
                ProblemView.this.resultNode.addChild(faceNode);
                if (problem.isSolvedCorrectly()) {
                    ProblemView.this.setGuessEditable(false);
                    faceNode.smile();
                    faceNode.addChild(new PText("+" + problem.getScore()){
                        {
                            super(string);
                            this.setOffset(faceNode.getFullBounds().getWidth() / 2.0, faceNode.getFullBounds().getHeight());
                            this.setFont(new PhetFont(24, true));
                        }
                    });
                    ProblemView.this.gameAudioPlayer.correctAnswer();
                    GameButtonNode gameButtonNode = new GameButtonNode(BuildAnAtomStrings.GAME_NEXT, BUTTON_OFFSET, new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            ProblemView.this.getModel().next();
                        }
                    });
                    ProblemView.this.checkButton.setVisible(false);
                    ProblemView.this.resultNode.addChild(gameButtonNode);
                } else {
                    faceNode.frown();
                    ProblemView.this.gameAudioPlayer.wrongAnswer();
                    ProblemView.this.setGuessEditable(false);
                    if (problem.getNumGuesses() == 1) {
                        GameButtonNode gameButtonNode = new GameButtonNode(BuildAnAtomStrings.GAME_TRY_AGAIN, BUTTON_OFFSET, new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                ProblemView.this.resultNode.removeAllChildren();
                                ProblemView.this.checkButton.setVisible(true);
                                ProblemView.this.setGuessEditable(true);
                            }
                        });
                        ProblemView.this.resultNode.addChild(gameButtonNode);
                        ProblemView.this.checkButton.setVisible(false);
                    } else if (problem.getNumGuesses() == 2) {
                        GameButtonNode gameButtonNode = new GameButtonNode(BuildAnAtomStrings.GAME_SHOW_ANSWER, BUTTON_OFFSET, new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                ProblemView.this.displayAnswer(problem.getAnswer());
                                ProblemView.this.setGuessEditable(false);
                                ProblemView.this.resultNode.removeAllChildren();
                                GameButtonNode gameButtonNode = new GameButtonNode(BuildAnAtomStrings.GAME_NEXT, BUTTON_OFFSET, new ActionListener(){

                                    public void actionPerformed(ActionEvent actionEvent) {
                                        ProblemView.this.getModel().next();
                                    }
                                });
                                ProblemView.this.resultNode.addChild(gameButtonNode);
                            }
                        });
                        ProblemView.this.resultNode.addChild(gameButtonNode);
                        ProblemView.this.checkButton.setVisible(false);
                    }
                }
                ProblemView.this.resultNode.moveToFront();
            }
        });
        this.checkButton.setEnabled(false);
    }

    public BuildAnAtomClock getClock() {
        return this.clock;
    }

    public void enableCheckButton() {
        this.checkButton.setEnabled(true);
    }

    protected abstract ImmutableAtom getGuess();

    protected abstract void displayAnswer(ImmutableAtom var1);

    protected abstract void setGuessEditable(boolean var1);

    public Problem getProblem() {
        return this.problem;
    }

    public void init() {
        this.getScoreboard().setOffset(BuildAnAtomDefaults.STAGE_SIZE.width / 2.0 - this.getScoreboard().getFullBoundsReference().width / 2.0, BuildAnAtomDefaults.STAGE_SIZE.height - 1.3 * this.getScoreboard().getFullBoundsReference().height);
        this.addChild(this.checkButton);
        this.addChild(this.getScoreboard());
        this.addChild(this.problemNumberDisplay);
        this.addChild(this.resultNode);
        this.clock.start();
    }

    public void teardown() {
        this.removeChild(this.getScoreboard());
        this.removeChild(this.checkButton);
        this.removeChild(this.problemNumberDisplay);
        this.removeChild(this.resultNode);
        this.clock.stop();
    }

    private static class GameButtonNode
    extends HTMLImageButtonNode {
        public GameButtonNode(String string, Point2D point2D, ActionListener actionListener) {
            super(string, new PhetFont(1, 30), BuildAnAtomGameCanvas.BUTTONS_COLOR);
            this.addActionListener(actionListener);
            this.centerFullBoundsOnPoint(point2D.getX(), point2D.getY());
        }
    }
}

