/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.modules.game.view;

import edu.colorado.phet.buildanatom.modules.game.model.BuildAnAtomGameModel;
import edu.colorado.phet.buildanatom.modules.game.model.State;
import edu.colorado.phet.buildanatom.modules.game.view.BuildAnAtomGameCanvas;
import edu.colorado.phet.common.games.GameScoreboardNode;
import edu.umd.cs.piccolo.PNode;

public abstract class StateView {
    private final BuildAnAtomGameCanvas gameCanvas;
    private final State state;
    private final BuildAnAtomGameModel model;

    StateView(BuildAnAtomGameModel buildAnAtomGameModel, State state, BuildAnAtomGameCanvas buildAnAtomGameCanvas) {
        this.model = buildAnAtomGameModel;
        this.gameCanvas = buildAnAtomGameCanvas;
        this.state = state;
    }

    public abstract void init();

    public abstract void teardown();

    public GameScoreboardNode getScoreboard() {
        return this.gameCanvas.getScoreboard();
    }

    protected void addChild(PNode pNode) {
        this.gameCanvas.getRootNode().addChild(pNode);
    }

    protected void removeChild(PNode pNode) {
        this.gameCanvas.getRootNode().removeChild(pNode);
    }

    protected BuildAnAtomGameModel getModel() {
        return this.model;
    }
}

