/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.modules.game.view;

import edu.colorado.phet.buildanatom.BuildAnAtomDefaults;
import edu.colorado.phet.buildanatom.BuildAnAtomStrings;
import edu.colorado.phet.buildanatom.model.ImmutableAtom;
import edu.colorado.phet.buildanatom.modules.game.model.BuildAnAtomGameModel;
import edu.colorado.phet.buildanatom.modules.game.model.SymbolToCountsProblem;
import edu.colorado.phet.buildanatom.modules.game.view.BuildAnAtomGameCanvas;
import edu.colorado.phet.buildanatom.modules.game.view.EntryPanel;
import edu.colorado.phet.buildanatom.modules.game.view.ProblemDescriptionNode;
import edu.colorado.phet.buildanatom.modules.game.view.ProblemView;
import edu.colorado.phet.buildanatom.view.SymbolIndicatorNode;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.umd.cs.piccolo.PNode;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SymbolToCountsView
extends ProblemView {
    private final ProblemDescriptionNode description = new ProblemDescriptionNode(BuildAnAtomStrings.GAME_HOW_MANY_PARTICLES);
    private final SymbolIndicatorNode symbolIndicatorNode;
    private final MultiEntryPanel multiEntryPanel;

    public SymbolToCountsView(BuildAnAtomGameModel buildAnAtomGameModel, BuildAnAtomGameCanvas buildAnAtomGameCanvas, SymbolToCountsProblem symbolToCountsProblem) {
        super(buildAnAtomGameModel, buildAnAtomGameCanvas, symbolToCountsProblem);
        this.symbolIndicatorNode = new SymbolIndicatorNode(symbolToCountsProblem.getAnswer().toAtom(this.getClock()), true);
        this.symbolIndicatorNode.scale(2.25);
        this.symbolIndicatorNode.setOffset(BuildAnAtomDefaults.STAGE_SIZE.width / 4.0 - this.symbolIndicatorNode.getFullBounds().getWidth() / 2.0, BuildAnAtomDefaults.STAGE_SIZE.height / 2.0 - this.symbolIndicatorNode.getFullBounds().getHeight() / 2.0);
        this.multiEntryPanel = new MultiEntryPanel();
        this.multiEntryPanel.setOffset(BuildAnAtomDefaults.STAGE_SIZE.width * 3.0 / 4.0 - this.multiEntryPanel.getFullBounds().getWidth() / 2.0, BuildAnAtomDefaults.STAGE_SIZE.height / 2.0 - this.multiEntryPanel.getFullBounds().getHeight() / 2.0);
        this.multiEntryPanel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                SymbolToCountsView.this.enableCheckButton();
            }
        });
        this.description.centerAbove(this.multiEntryPanel);
        this.enableCheckButton();
    }

    protected ImmutableAtom getGuess() {
        return this.multiEntryPanel.getGuess();
    }

    protected void displayAnswer(ImmutableAtom immutableAtom) {
        this.multiEntryPanel.displayAnswer(immutableAtom);
    }

    protected void setGuessEditable(boolean bl) {
        this.multiEntryPanel.setPickable(bl);
        this.multiEntryPanel.setChildrenPickable(bl);
    }

    public void init() {
        super.init();
        this.addChild(this.description);
        this.addChild(this.symbolIndicatorNode);
        this.addChild(this.multiEntryPanel);
    }

    public void teardown() {
        super.teardown();
        this.removeChild(this.description);
        this.removeChild(this.symbolIndicatorNode);
        this.removeChild(this.multiEntryPanel);
    }

    public static class MultiEntryPanel
    extends PNode {
        private final EntryPanel protonEntryPanel;
        private final EntryPanel neutronEntryPanel;
        private final EntryPanel electronEntryPanel;
        public Property<Integer> protonGuess = new Property<Integer>(0);
        public Property<Integer> neutronGuess = new Property<Integer>(0);
        public Property<Integer> electronGuess = new Property<Integer>(0);

        public MultiEntryPanel() {
            this.protonEntryPanel = new EntryPanel(BuildAnAtomStrings.PROTONS_READOUT, this.protonGuess);
            this.addChild(this.protonEntryPanel);
            this.neutronEntryPanel = new EntryPanel(BuildAnAtomStrings.NEUTRONS_READOUT, this.neutronGuess);
            this.addChild(this.neutronEntryPanel);
            this.electronEntryPanel = new EntryPanel(BuildAnAtomStrings.ELECTRONS_READOUT, this.electronGuess);
            this.addChild(this.electronEntryPanel);
            double d = MathUtil.max(new double[]{this.protonEntryPanel.getLabelWidth(), this.neutronEntryPanel.getLabelWidth(), this.electronEntryPanel.getLabelWidth()});
            int n = 20;
            double d2 = d + (double)n;
            this.protonEntryPanel.setSpinnerX(d2);
            this.neutronEntryPanel.setSpinnerX(d2);
            this.electronEntryPanel.setSpinnerX(d2);
            this.protonEntryPanel.setOffset(0.0, 0.0);
            this.neutronEntryPanel.setOffset(this.protonEntryPanel.getFullBounds().getX(), this.protonEntryPanel.getFullBounds().getMaxY() + 20.0);
            this.electronEntryPanel.setOffset(this.neutronEntryPanel.getFullBounds().getX(), this.neutronEntryPanel.getFullBounds().getMaxY() + 20.0);
        }

        public ImmutableAtom getGuess() {
            return new ImmutableAtom(this.protonGuess.get(), this.neutronGuess.get(), this.electronGuess.get());
        }

        public void displayAnswer(ImmutableAtom immutableAtom) {
            this.protonGuess.set(immutableAtom.getNumProtons());
            this.electronGuess.set(immutableAtom.getNumElectrons());
            this.neutronGuess.set(immutableAtom.getNumNeutrons());
            this.protonEntryPanel.setEditable(false);
            this.neutronEntryPanel.setEditable(false);
            this.electronEntryPanel.setEditable(false);
        }

        public void addChangeListener(final ChangeListener changeListener) {
            SimpleObserver simpleObserver = new SimpleObserver(){

                public void update() {
                    changeListener.stateChanged(null);
                }
            };
            this.protonGuess.addObserver(simpleObserver, false);
            this.neutronGuess.addObserver(simpleObserver, false);
            this.electronGuess.addObserver(simpleObserver, false);
        }
    }
}

