/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.modules.game.view;

import edu.colorado.phet.buildanatom.BuildAnAtomDefaults;
import edu.colorado.phet.buildanatom.BuildAnAtomStrings;
import edu.colorado.phet.buildanatom.model.AtomListener;
import edu.colorado.phet.buildanatom.model.BuildAnAtomModel;
import edu.colorado.phet.buildanatom.model.ImmutableAtom;
import edu.colorado.phet.buildanatom.modules.game.model.BuildAnAtomGameModel;
import edu.colorado.phet.buildanatom.modules.game.model.SymbolToSchematicProblem;
import edu.colorado.phet.buildanatom.modules.game.view.BuildAnAtomGameCanvas;
import edu.colorado.phet.buildanatom.modules.game.view.InteractiveSchematicAtomNode;
import edu.colorado.phet.buildanatom.modules.game.view.ProblemDescriptionNode;
import edu.colorado.phet.buildanatom.modules.game.view.ProblemView;
import edu.colorado.phet.buildanatom.view.OrbitalView;
import edu.colorado.phet.buildanatom.view.SymbolIndicatorNode;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import java.awt.Point;
import java.awt.geom.Point2D;

public class SymbolToSchematicView
extends ProblemView {
    private final ProblemDescriptionNode description = new ProblemDescriptionNode(BuildAnAtomStrings.GAME_COMPLETE_THE_MODEL);
    private final SymbolIndicatorNode symbolIndicatorNode;
    private final InteractiveSchematicAtomNode interactiveSchematicAtomNode;

    public SymbolToSchematicView(BuildAnAtomGameModel buildAnAtomGameModel, BuildAnAtomGameCanvas buildAnAtomGameCanvas, SymbolToSchematicProblem symbolToSchematicProblem) {
        super(buildAnAtomGameModel, buildAnAtomGameCanvas, symbolToSchematicProblem);
        this.symbolIndicatorNode = new SymbolIndicatorNode(symbolToSchematicProblem.getAnswer().toAtom(this.getClock()), true);
        this.symbolIndicatorNode.scale(2.0);
        this.symbolIndicatorNode.setOffset(100.0, BuildAnAtomDefaults.STAGE_SIZE.height / 2.0 - this.symbolIndicatorNode.getFullBounds().getHeight() / 2.0);
        final BuildAnAtomModel buildAnAtomModel = new BuildAnAtomModel(this.getClock()){
            {
                this.reset();
            }
        };
        this.interactiveSchematicAtomNode = new InteractiveSchematicAtomNode(buildAnAtomModel, ModelViewTransform.createSinglePointScaleInvertedYMapping(new Point2D.Double(0.0, 0.0), new Point((int)Math.round(BuildAnAtomDefaults.STAGE_SIZE.width * 0.7), (int)Math.round(BuildAnAtomDefaults.STAGE_SIZE.height * 0.35)), 1.5), new Property<OrbitalView>(OrbitalView.PARTICLES));
        buildAnAtomModel.getAtom().addAtomListener(new AtomListener.Adapter(){

            public void configurationChanged() {
                if (buildAnAtomModel.getAtom().getMassNumber() > 0) {
                    SymbolToSchematicView.this.enableCheckButton();
                }
            }
        });
        this.description.centerAbove(this.interactiveSchematicAtomNode);
    }

    protected ImmutableAtom getGuess() {
        return this.interactiveSchematicAtomNode.getAtomValue();
    }

    protected void displayAnswer(ImmutableAtom immutableAtom) {
        this.interactiveSchematicAtomNode.setAtomValue(immutableAtom);
    }

    protected void setGuessEditable(boolean bl) {
        this.interactiveSchematicAtomNode.setPickable(bl);
        this.interactiveSchematicAtomNode.setChildrenPickable(bl);
    }

    public void init() {
        super.init();
        this.addChild(this.description);
        this.addChild(this.symbolIndicatorNode);
        this.addChild(this.interactiveSchematicAtomNode);
    }

    public void teardown() {
        super.teardown();
        this.removeChild(this.description);
        this.removeChild(this.symbolIndicatorNode);
        this.removeChild(this.interactiveSchematicAtomNode);
    }
}

