/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.modules.game.view;

import edu.colorado.phet.buildanatom.BuildAnAtomDefaults;
import edu.colorado.phet.buildanatom.BuildAnAtomStrings;
import edu.colorado.phet.buildanatom.model.ImmutableAtom;
import edu.colorado.phet.buildanatom.modules.game.model.BuildAnAtomGameModel;
import edu.colorado.phet.buildanatom.modules.game.model.ToSymbolProblem;
import edu.colorado.phet.buildanatom.modules.game.view.BuildAnAtomGameCanvas;
import edu.colorado.phet.buildanatom.modules.game.view.InteractiveSymbolNode;
import edu.colorado.phet.buildanatom.modules.game.view.ProblemDescriptionNode;
import edu.colorado.phet.buildanatom.modules.game.view.ProblemView;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ToSymbolProblemView
extends ProblemView {
    private final ProblemDescriptionNode description;
    private final InteractiveSymbolNode interactiveSymbolNode;

    public ToSymbolProblemView(BuildAnAtomGameModel buildAnAtomGameModel, BuildAnAtomGameCanvas buildAnAtomGameCanvas, ToSymbolProblem toSymbolProblem) {
        super(buildAnAtomGameModel, buildAnAtomGameCanvas, toSymbolProblem);
        this.interactiveSymbolNode = new InteractiveSymbolNode(toSymbolProblem.getAnswer(), toSymbolProblem.isConfigurableProtonCount(), toSymbolProblem.isConfigurableMass(), toSymbolProblem.isConfigurableCharge());
        this.interactiveSymbolNode.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ToSymbolProblemView.this.enableCheckButton();
            }
        });
        this.interactiveSymbolNode.setOffset(BuildAnAtomDefaults.STAGE_SIZE.width * 0.75 - this.interactiveSymbolNode.getFullBounds().getWidth() / 2.0, BuildAnAtomDefaults.STAGE_SIZE.height / 2.0 - this.interactiveSymbolNode.getFullBounds().getHeight() / 2.0);
        if (toSymbolProblem.isConfigurableProtonCount() && toSymbolProblem.isConfigurableMass() && toSymbolProblem.isConfigurableCharge()) {
            this.description = new ProblemDescriptionNode(BuildAnAtomStrings.GAME_COMPLETE_THE_SYMBOL_ALL);
        } else if (toSymbolProblem.isConfigurableProtonCount() && !toSymbolProblem.isConfigurableMass() && !toSymbolProblem.isConfigurableCharge()) {
            this.description = new ProblemDescriptionNode(BuildAnAtomStrings.GAME_COMPLETE_THE_SYMBOL_PROTON_COUNT);
        } else if (!toSymbolProblem.isConfigurableProtonCount() && toSymbolProblem.isConfigurableMass() && !toSymbolProblem.isConfigurableCharge()) {
            this.description = new ProblemDescriptionNode(BuildAnAtomStrings.GAME_COMPLETE_THE_SYMBOL_MASS);
        } else if (!toSymbolProblem.isConfigurableProtonCount() && !toSymbolProblem.isConfigurableMass() && toSymbolProblem.isConfigurableCharge()) {
            this.description = new ProblemDescriptionNode(BuildAnAtomStrings.GAME_COMPLETE_THE_SYMBOL_CHARGE);
        } else {
            System.err.println(this.getClass().getName() + " - Error: No problem description available for specified configuration.");
            assert (false);
            this.description = new ProblemDescriptionNode("Fill in.");
        }
        this.description.centerAbove(this.interactiveSymbolNode);
        this.enableCheckButton();
    }

    public void init() {
        super.init();
        this.addChild(this.description);
        this.addChild(this.interactiveSymbolNode);
    }

    public void teardown() {
        super.teardown();
        this.removeChild(this.description);
        this.removeChild(this.interactiveSymbolNode);
    }

    protected ImmutableAtom getGuess() {
        return this.interactiveSymbolNode.getGuess();
    }

    protected void displayAnswer(ImmutableAtom immutableAtom) {
        this.interactiveSymbolNode.displayAnswer(immutableAtom);
    }

    protected void setGuessEditable(boolean bl) {
        this.interactiveSymbolNode.setPickable(bl);
        this.interactiveSymbolNode.setChildrenPickable(bl);
    }
}

