/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.modules.interactiveisotope.model;

import edu.colorado.phet.buildanatom.BuildAnAtomStrings;
import edu.colorado.phet.buildanatom.model.Atom;
import edu.colorado.phet.buildanatom.model.BuildAnAtomClock;
import edu.colorado.phet.buildanatom.model.Electron;
import edu.colorado.phet.buildanatom.model.IAtom;
import edu.colorado.phet.buildanatom.model.IConfigurableAtomModel;
import edu.colorado.phet.buildanatom.model.ImmutableAtom;
import edu.colorado.phet.buildanatom.model.Neutron;
import edu.colorado.phet.buildanatom.model.Proton;
import edu.colorado.phet.buildanatom.model.SphericalParticle;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.SphereBucket;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakeIsotopesModel
implements IConfigurableAtomModel,
Resettable {
    private static final Dimension2D BUCKET_SIZE = new PDimension(65.0, 30.0);
    private static final Point2D NEUTRON_BUCKET_POSITION = new Point2D.Double(-120.0, -140.0);
    private static final ImmutableAtom DEFAULT_ATOM_CONFIG = new ImmutableAtom(1, 0, 1);
    private final BuildAnAtomClock clock;
    private final Atom atom;
    private final ArrayList<Neutron> neutrons = new ArrayList();
    private final ArrayList<Proton> protons = new ArrayList();
    private final ArrayList<Electron> electrons = new ArrayList();
    private final SphereBucket<SphericalParticle> neutronBucket = new SphereBucket(NEUTRON_BUCKET_POSITION, BUCKET_SIZE, Color.gray, BuildAnAtomStrings.NEUTRONS_NAME, 5.0);
    private final ArrayList<Listener> listeners = new ArrayList();
    private final SphericalParticle.Adapter neutronDropListener = new SphericalParticle.Adapter(){

        public void droppedByUser(SphericalParticle sphericalParticle) {
            assert (sphericalParticle instanceof Neutron);
            assert (MakeIsotopesModel.this.neutrons.contains(sphericalParticle));
            if (sphericalParticle.getPosition().distance(MakeIsotopesModel.this.atom.getPosition()) < 34.0) {
                MakeIsotopesModel.this.atom.addNeutron((Neutron)sphericalParticle, false);
            } else {
                MakeIsotopesModel.this.neutronBucket.addParticleNearestOpen(sphericalParticle, false);
            }
        }
    };

    public MakeIsotopesModel(BuildAnAtomClock buildAnAtomClock) {
        this.clock = buildAnAtomClock;
        this.atom = new Atom(new Point2D.Double(0.0, 0.0), buildAnAtomClock);
        for (int i = 0; i < 4; ++i) {
            final Neutron neutron = new Neutron(buildAnAtomClock);
            this.neutrons.add(neutron);
            neutron.addListener(new SphericalParticle.Adapter(){

                public void droppedByUser(SphericalParticle sphericalParticle) {
                    if (neutron.getPosition().distance(MakeIsotopesModel.this.atom.getPosition()) < 34.0) {
                        MakeIsotopesModel.this.atom.addNeutron(neutron, false);
                    } else {
                        MakeIsotopesModel.this.neutronBucket.addParticleNearestOpen(neutron, false);
                    }
                }
            });
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public BuildAnAtomClock getClock() {
        return this.clock;
    }

    @Override
    public Atom getAtom() {
        return this.atom;
    }

    @Override
    public void setAtomConfiguration(IAtom iAtom) {
        if (!this.atom.configurationEquals(iAtom)) {
            SphericalParticle sphericalParticle;
            int n;
            this.clearAtom();
            for (n = 0; n < iAtom.getNumElectrons(); ++n) {
                sphericalParticle = new Electron(this.clock);
                this.atom.addElectron((Electron)sphericalParticle, true);
                this.electrons.add((Electron)sphericalParticle);
                this.notifyParticleAdded(sphericalParticle);
            }
            for (n = 0; n < iAtom.getNumProtons(); ++n) {
                sphericalParticle = new Proton(this.clock);
                this.atom.addProton((Proton)sphericalParticle, true);
                this.protons.add((Proton)sphericalParticle);
                this.notifyParticleAdded(sphericalParticle);
            }
            for (n = 0; n < iAtom.getNumNeutrons(); ++n) {
                sphericalParticle = new Neutron(this.clock);
                sphericalParticle.setMotionVelocity(200.0);
                sphericalParticle.addListener(this.neutronDropListener);
                this.atom.addNeutron((Neutron)sphericalParticle, true);
                this.neutrons.add((Neutron)sphericalParticle);
                this.notifyParticleAdded(sphericalParticle);
            }
        }
        this.setNeutronBucketCount(4);
    }

    private void setNeutronBucketCount(int n) {
        this.clearBucket();
        for (int i = 0; i < n; ++i) {
            Neutron neutron = new Neutron(this.clock);
            neutron.setMotionVelocity(200.0);
            neutron.addListener(this.neutronDropListener);
            this.neutronBucket.addParticleFirstOpen(neutron, true);
            this.neutrons.add(neutron);
            this.notifyParticleAdded(neutron);
        }
    }

    private void clearAtom() {
        for (Proton sphericalParticle : new ArrayList<Proton>(this.atom.getProtons())) {
            this.atom.removeProton(sphericalParticle);
            this.protons.remove(sphericalParticle);
            sphericalParticle.removedFromModel();
        }
        for (Neutron neutron : new ArrayList<Neutron>(this.atom.getNeutrons())) {
            this.atom.removeNeutron(neutron);
            this.neutrons.remove(neutron);
            neutron.removedFromModel();
        }
        for (Electron electron : new ArrayList<Electron>(this.atom.getElectrons())) {
            this.atom.removeElectron(electron);
            this.electrons.remove(electron);
            electron.removedFromModel();
        }
    }

    private void clearBucket() {
        for (SphericalParticle sphericalParticle : new ArrayList<SphericalParticle>(this.neutronBucket.getParticleList())) {
            this.neutrons.remove(sphericalParticle);
            this.neutronBucket.removeParticle(sphericalParticle);
            sphericalParticle.removedFromModel();
        }
    }

    @Override
    public void reset() {
        this.setAtomConfiguration(DEFAULT_ATOM_CONFIG);
    }

    public SphereBucket<SphericalParticle> getNeutronBucket() {
        return this.neutronBucket;
    }

    private void notifyParticleAdded(SphericalParticle sphericalParticle) {
        for (Listener listener : this.listeners) {
            listener.particleAdded(sphericalParticle);
        }
    }

    public static class Adapter
    implements Listener {
        public void particleAdded(SphericalParticle sphericalParticle) {
        }
    }

    public static interface Listener {
        public void particleAdded(SphericalParticle var1);
    }
}

