/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.modules.interactiveisotope.view;

import edu.colorado.phet.buildanatom.BuildAnAtomStrings;
import edu.colorado.phet.buildanatom.model.AtomListener;
import edu.colorado.phet.buildanatom.model.IDynamicAtom;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.controls.PropertyRadioButton;
import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.text.DecimalFormat;
import javax.swing.JPanel;

public class AtomScaleNode
extends PNode {
    private static final Color COLOR = new Color(228, 194, 167);
    private static final Dimension2D SIZE = new PDimension(320.0, 125.0);
    private static final double WEIGH_PLATE_WIDTH = SIZE.getWidth() * 0.7;
    private static final Stroke STROKE = new BasicStroke(2.0f, 1, 1);
    private static final Paint STROKE_PAINT = Color.BLACK;
    private final Property<DisplayMode> displayModeProperty = new Property<DisplayMode>(DisplayMode.MASS_NUMBER);
    private final PNode weighPlateTop;

    public AtomScaleNode(IDynamicAtom iDynamicAtom) {
        double d = SIZE.getWidth() / 2.0;
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, SIZE.getHeight() * 0.55, SIZE.getWidth(), SIZE.getHeight() * 0.5);
        final PhetPPath phetPPath = new PhetPPath(double_, COLOR, STROKE, STROKE_PAINT);
        this.addChild(phetPPath);
        final ScaleReadoutNode scaleReadoutNode = new ScaleReadoutNode(iDynamicAtom, this.displayModeProperty){
            {
                super(iDynamicAtom, property);
                this.setOffset(SIZE.getWidth() * 0.05, phetPPath.getFullBoundsReference().getCenterY() - this.getFullBoundsReference().height / 2.0);
            }
        };
        this.addChild(scaleReadoutNode);
        this.addChild(new DisplayModeSelectionNode(this.displayModeProperty){
            {
                super(property);
                double d = phetPPath.getFullBoundsReference().getMaxX() - scaleReadoutNode.getFullBoundsReference().getMaxX() - 10.0;
                if (this.getFullBoundsReference().getWidth() > d) {
                    this.setScale(d / this.getFullBoundsReference().width);
                }
                this.setOffset(scaleReadoutNode.getFullBoundsReference().getMaxX() + 5.0, phetPPath.getFullBoundsReference().getCenterY() - this.getFullBoundsReference().height / 2.0);
            }
        });
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath();
        doubleGeneralPath.moveTo(SIZE.getWidth() * 0.15, SIZE.getHeight() * 0.375);
        doubleGeneralPath.lineTo(SIZE.getWidth() * 0.85, SIZE.getHeight() * 0.375);
        doubleGeneralPath.lineTo(SIZE.getWidth(), SIZE.getHeight() * 0.55);
        doubleGeneralPath.lineTo(0.0, SIZE.getHeight() * 0.55);
        doubleGeneralPath.closePath();
        Rectangle2D rectangle2D = doubleGeneralPath.getGeneralPath().getBounds2D();
        GradientPaint gradientPaint = new GradientPaint((float)rectangle2D.getCenterX(), (float)rectangle2D.getMaxY(), ColorUtils.brighterColor(COLOR, 0.5), (float)rectangle2D.getCenterX(), (float)rectangle2D.getMinY(), ColorUtils.darkerColor(COLOR, 0.5));
        PhetPPath phetPPath2 = new PhetPPath(doubleGeneralPath.getGeneralPath(), gradientPaint, STROKE, STROKE_PAINT);
        this.addChild(phetPPath2);
        DoubleGeneralPath doubleGeneralPath2 = new DoubleGeneralPath();
        double d2 = SIZE.getHeight() * 0.15;
        double d3 = SIZE.getWidth() * 0.1;
        double d4 = SIZE.getHeight() * 0.3;
        doubleGeneralPath2.moveTo(d - d3 / 2.0, d2);
        doubleGeneralPath2.lineTo(d - d3 / 2.0, d2 + d4);
        doubleGeneralPath2.quadTo(d, d2 + d4 * 1.2, SIZE.getWidth() / 2.0 + d3 / 2.0, d2 + d4);
        doubleGeneralPath2.lineTo(d + d3 / 2.0, d2);
        Rectangle2D rectangle2D2 = doubleGeneralPath2.getGeneralPath().getBounds2D();
        GradientPaint gradientPaint2 = new GradientPaint((float)rectangle2D2.getMinX(), (float)rectangle2D2.getCenterY(), ColorUtils.brighterColor(COLOR, 0.5), (float)rectangle2D2.getMaxX(), (float)rectangle2D2.getCenterY(), ColorUtils.darkerColor(COLOR, 0.5));
        PhetPPath phetPPath3 = new PhetPPath(doubleGeneralPath2.getGeneralPath(), gradientPaint2, STROKE, STROKE_PAINT);
        this.addChild(phetPPath3);
        DoubleGeneralPath doubleGeneralPath3 = new DoubleGeneralPath();
        doubleGeneralPath3.moveTo(d - WEIGH_PLATE_WIDTH * 0.35, 0.0);
        doubleGeneralPath3.lineTo(d + WEIGH_PLATE_WIDTH * 0.35, 0.0);
        doubleGeneralPath3.lineTo(d + WEIGH_PLATE_WIDTH / 2.0, SIZE.getHeight() * 0.125);
        doubleGeneralPath3.lineTo(d - WEIGH_PLATE_WIDTH / 2.0, SIZE.getHeight() * 0.125);
        doubleGeneralPath3.closePath();
        Rectangle2D rectangle2D3 = doubleGeneralPath3.getGeneralPath().getBounds2D();
        GradientPaint gradientPaint3 = new GradientPaint((float)rectangle2D3.getCenterX(), (float)rectangle2D3.getMaxY(), ColorUtils.brighterColor(COLOR, 0.5), (float)rectangle2D3.getCenterX(), (float)rectangle2D3.getMinY(), ColorUtils.darkerColor(COLOR, 0.2));
        this.weighPlateTop = new PhetPPath(doubleGeneralPath3.getGeneralPath(), gradientPaint3, STROKE, STROKE_PAINT);
        this.addChild(this.weighPlateTop);
        Rectangle2D.Double double_2 = new Rectangle2D.Double(d - WEIGH_PLATE_WIDTH / 2.0, SIZE.getHeight() * 0.125, WEIGH_PLATE_WIDTH, SIZE.getHeight() * 0.15);
        this.addChild(new PhetPPath(double_2, COLOR, STROKE, STROKE_PAINT));
    }

    public void reset() {
        this.displayModeProperty.reset();
    }

    public double getWeighPlateTopProjectedHeight() {
        return this.weighPlateTop.getFullBoundsReference().getHeight();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DisplayMode
    extends Enum<DisplayMode> {
        public static final /* enum */ DisplayMode MASS_NUMBER = new DisplayMode();
        public static final /* enum */ DisplayMode ATOMIC_MASS = new DisplayMode();
        private static final /* synthetic */ DisplayMode[] $VALUES;

        public static DisplayMode[] values() {
            return (DisplayMode[])$VALUES.clone();
        }

        static {
            $VALUES = new DisplayMode[]{MASS_NUMBER, ATOMIC_MASS};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DisplayModeSelectionNode
    extends PNode {
        private static final Font LABEL_FONT = new PhetFont(16);

        public DisplayModeSelectionNode(Property<DisplayMode> property) {
            JPanel jPanel = new JPanel(new GridLayout(2, 1)){
                {
                    this.setBackground(COLOR);
                }
            };
            PropertyRadioButton<DisplayMode> propertyRadioButton = new PropertyRadioButton<DisplayMode>(BuildAnAtomStrings.MASS_NUMBER, property, DisplayMode.MASS_NUMBER){
                {
                    this.setBackground(COLOR);
                    this.setFont(LABEL_FONT);
                }
            };
            jPanel.add(propertyRadioButton);
            PropertyRadioButton<DisplayMode> propertyRadioButton2 = new PropertyRadioButton<DisplayMode>(BuildAnAtomStrings.ATOMIC_MASS, property, DisplayMode.ATOMIC_MASS){
                {
                    this.setBackground(COLOR);
                    this.setFont(LABEL_FONT);
                }
            };
            jPanel.add(propertyRadioButton2);
            this.addChild(new PSwing(jPanel));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ScaleReadoutNode
    extends PNode {
        private static final DecimalFormat atomicMassNumberFormatter = new DecimalFormat("#0.00000");
        PText readoutText = new PText(){
            {
                this.setFont(new PhetFont(24));
            }
        };
        Property<DisplayMode> displayModeProperty;
        IDynamicAtom atom;
        private final PPath readoutBackground;

        public ScaleReadoutNode(IDynamicAtom iDynamicAtom, Property<DisplayMode> property) {
            this.atom = iDynamicAtom;
            this.displayModeProperty = property;
            this.readoutBackground = new PhetPPath(new RoundRectangle2D.Double(0.0, 0.0, SIZE.getWidth() * 0.4, SIZE.getHeight() * 0.33, 5.0, 5.0), Color.WHITE, new BasicStroke(2.0f), Color.BLACK);
            this.addChild(this.readoutBackground);
            this.addChild(this.readoutText);
            property.addObserver(new SimpleObserver(){

                public void update() {
                    ScaleReadoutNode.this.updateReadout();
                }
            });
            iDynamicAtom.addAtomListener(new AtomListener.Adapter(){

                public void configurationChanged() {
                    ScaleReadoutNode.this.updateReadout();
                }
            });
        }

        private void updateReadout() {
            double d;
            if (this.displayModeProperty.get() == DisplayMode.MASS_NUMBER) {
                this.readoutText.setText(Integer.toString(this.atom.getMassNumber()));
            } else {
                d = this.atom.getAtomicMass();
                this.readoutText.setText(d > 0.0 ? atomicMassNumberFormatter.format(d) : "--");
            }
            this.readoutText.setScale(1.0);
            if (this.readoutText.getFullBoundsReference().width > this.readoutBackground.getFullBoundsReference().width || this.readoutText.getFullBoundsReference().height > this.readoutBackground.getFullBoundsReference().height) {
                d = Math.min(this.readoutBackground.getFullBoundsReference().width / this.readoutText.getFullBoundsReference().width, this.readoutBackground.getFullBoundsReference().height / this.readoutText.getFullBoundsReference().height);
                this.readoutText.setScale(d);
            }
            this.readoutText.centerFullBoundsOnPoint(this.readoutBackground.getFullBoundsReference().getCenterX(), this.readoutBackground.getFullBoundsReference().getCenterY());
        }
    }
}

