/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.modules.isotopemixture.model;

import edu.colorado.phet.buildanatom.model.ImmutableAtom;
import edu.colorado.phet.buildanatom.modules.isotopemixture.model.MixIsotopesModel;
import edu.colorado.phet.buildanatom.modules.isotopemixture.model.MovableAtom;
import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsotopeTestChamber {
    private static final Dimension2D SIZE = new PDimension(3500.0, 3000.0);
    private static final Rectangle2D TEST_CHAMBER_RECT = new Rectangle2D.Double(-SIZE.getWidth() / 2.0, -SIZE.getHeight() / 2.0, SIZE.getWidth(), SIZE.getHeight());
    private static final Random RAND = new Random();
    private final MixIsotopesModel model;
    private final List<MovableAtom> containedIsotopes = new ArrayList<MovableAtom>();
    private final Property<Integer> isotopeCountProperty = new Property<Integer>(0);
    private final Property<Double> averageAtomicMassProperty = new Property<Double>(0.0);

    IsotopeTestChamber(MixIsotopesModel mixIsotopesModel) {
        this.model = mixIsotopesModel;
    }

    public int getIsotopeCount(ImmutableAtom immutableAtom) {
        assert (immutableAtom.getNumProtons() == immutableAtom.getNumElectrons());
        int n = 0;
        for (MovableAtom movableAtom : this.containedIsotopes) {
            if (!movableAtom.getAtomConfiguration().equals(immutableAtom)) continue;
            ++n;
        }
        return n;
    }

    public Rectangle2D getTestChamberRect() {
        return TEST_CHAMBER_RECT;
    }

    public boolean isIsotopePositionedOverChamber(MovableAtom movableAtom) {
        return TEST_CHAMBER_RECT.contains(movableAtom.getPosition().toPoint2D());
    }

    public boolean isIsotopeContained(MovableAtom movableAtom) {
        return this.containedIsotopes.contains(movableAtom);
    }

    public void addIsotopeToChamber(MovableAtom movableAtom) {
        this.addIsotopeToChamber(movableAtom, true);
    }

    public void bulkAddIsotopesToChamber(List<MovableAtom> list) {
        for (MovableAtom movableAtom : list) {
            this.addIsotopeToChamber(movableAtom, false);
        }
        this.updateCountProperty();
        this.updateAverageAtomicMassProperty();
    }

    private void addIsotopeToChamber(MovableAtom movableAtom, boolean bl) {
        if (this.isIsotopePositionedOverChamber(movableAtom)) {
            this.containedIsotopes.add(movableAtom);
            double d = movableAtom.getPosition().getX() + movableAtom.getRadius() - TEST_CHAMBER_RECT.getMaxX();
            if (d >= 0.0) {
                movableAtom.setPositionAndDestination(movableAtom.getPosition().getX() - d, movableAtom.getPosition().getY());
            } else {
                d = TEST_CHAMBER_RECT.getMinX() - (movableAtom.getPosition().getX() - movableAtom.getRadius());
                if (d >= 0.0) {
                    movableAtom.setPositionAndDestination(movableAtom.getPosition().getX() + d, movableAtom.getPosition().getY());
                }
            }
            d = movableAtom.getPosition().getY() + movableAtom.getRadius() - TEST_CHAMBER_RECT.getMaxY();
            if (d >= 0.0) {
                movableAtom.setPositionAndDestination(movableAtom.getPosition().getX(), movableAtom.getPosition().getY() - d);
            } else {
                d = TEST_CHAMBER_RECT.getMinY() - (movableAtom.getPosition().getY() - movableAtom.getRadius());
                if (d >= 0.0) {
                    movableAtom.setPositionAndDestination(movableAtom.getPosition().getX(), movableAtom.getPosition().getY() + d);
                }
            }
            if (bl) {
                this.updateCountProperty();
                this.averageAtomicMassProperty.set((this.averageAtomicMassProperty.get() * (double)(this.isotopeCountProperty.get() - 1) + movableAtom.getAtomConfiguration().getAtomicMass()) / (double)this.isotopeCountProperty.get().intValue());
            }
        } else {
            System.err.println(this.getClass().getName() + " - Warning: Ignoring attempt to add incorrectly located isotope to test chamber.");
        }
    }

    public void removeIsotopeFromChamber(MovableAtom movableAtom) {
        this.containedIsotopes.remove(movableAtom);
        this.updateCountProperty();
        if (this.isotopeCountProperty.get() > 0) {
            this.averageAtomicMassProperty.set((this.averageAtomicMassProperty.get() * (double)(this.isotopeCountProperty.get() + 1) - movableAtom.getAtomConfiguration().getAtomicMass()) / (double)this.isotopeCountProperty.get().intValue());
        } else {
            this.averageAtomicMassProperty.set(0.0);
        }
    }

    public MovableAtom removeIsotopeMatchingConfig(ImmutableAtom immutableAtom) {
        if (immutableAtom.getCharge() != 0) {
            throw new IllegalArgumentException("Isotope must be neutral");
        }
        MovableAtom movableAtom = null;
        for (MovableAtom movableAtom2 : this.containedIsotopes) {
            if (!movableAtom2.getAtomConfiguration().equals(immutableAtom)) continue;
            movableAtom = movableAtom2;
            break;
        }
        this.removeIsotopeFromChamber(movableAtom);
        return movableAtom;
    }

    public void removeAllIsotopes(boolean bl) {
        ArrayList<MovableAtom> arrayList = new ArrayList<MovableAtom>(this.containedIsotopes);
        this.containedIsotopes.clear();
        if (bl) {
            for (MovableAtom movableAtom : arrayList) {
                movableAtom.removeListener(this.model.isotopeGrabbedListener);
                movableAtom.removedFromModel();
            }
        }
        this.updateCountProperty();
        this.averageAtomicMassProperty.set(0.0);
        assert (this.isotopeCountProperty.get() == 0);
        assert (this.averageAtomicMassProperty.get() == 0.0);
    }

    protected List<MovableAtom> getContainedIsotopes() {
        return this.containedIsotopes;
    }

    public int getTotalIsotopeCount() {
        return this.isotopeCountProperty.get();
    }

    public void addTotalCountChangeObserver(SimpleObserver simpleObserver) {
        this.isotopeCountProperty.addObserver(simpleObserver);
    }

    private void updateCountProperty() {
        this.isotopeCountProperty.set(this.containedIsotopes.size());
    }

    private void updateAverageAtomicMassProperty() {
        if (this.containedIsotopes.size() > 0) {
            double d = 0.0;
            for (MovableAtom movableAtom : this.containedIsotopes) {
                d += movableAtom.getAtomConfiguration().getAtomicMass();
            }
            this.averageAtomicMassProperty.set(d / (double)this.containedIsotopes.size());
        } else {
            this.averageAtomicMassProperty.set(0.0);
        }
    }

    public void addAverageAtomicMassPropertyListener(SimpleObserver simpleObserver) {
        this.averageAtomicMassProperty.addObserver(simpleObserver);
    }

    public double getAverageAtomicMass() {
        return this.averageAtomicMassProperty.get();
    }

    public double getIsotopeProportion(ImmutableAtom immutableAtom) {
        assert (immutableAtom.getCharge() == 0);
        double d = 0.0;
        int n = 0;
        for (MovableAtom movableAtom : this.containedIsotopes) {
            if (!immutableAtom.equals(movableAtom.getAtomConfiguration())) continue;
            ++n;
        }
        d = (double)n / (double)this.containedIsotopes.size();
        return d;
    }

    public void adjustForOverlap() {
        if (this.getTotalIsotopeCount() > 100) {
            System.out.println(this.getClass().getName() + " - Warning: Ignoring request to adjust for overlap - too many particles in the chamber for that.");
            return;
        }
        int n = 10000;
        for (int i = 0; this.checkForParticleOverlap() && i < n; ++i) {
            double d = 2000.0;
            double d2 = d * 10.0;
            double d3 = 1.0E-4;
            HashMap<MovableAtom, MutableVector2D> hashMap = new HashMap<MovableAtom, MutableVector2D>();
            for (MovableAtom movableAtom : this.containedIsotopes) {
                MutableVector2D mutableVector2D = new MutableVector2D(0.0, 0.0);
                for (MovableAtom movableAtom2 : this.containedIsotopes) {
                    if (movableAtom == movableAtom2) continue;
                    MutableVector2D mutableVector2D2 = new MutableVector2D(0.0, 0.0);
                    double d4 = movableAtom.getPosition().distance(movableAtom2.getPosition());
                    if (d4 == 0.0) {
                        mutableVector2D2.setMagnitude(d / (d3 * d3));
                        mutableVector2D2.setAngle(RAND.nextDouble() * 2.0 * Math.PI);
                    } else if (d4 < movableAtom.getRadius() + movableAtom2.getRadius()) {
                        mutableVector2D2.setComponents(movableAtom.getPosition().getX() - movableAtom2.getPosition().getX(), movableAtom.getPosition().getY() - movableAtom2.getPosition().getY());
                        double d5 = Math.max(mutableVector2D2.magnitude(), d3);
                        mutableVector2D2.normalize();
                        mutableVector2D2.scale(d / (d5 * d5));
                    }
                    mutableVector2D.add(mutableVector2D2);
                }
                if (movableAtom.getPosition().getX() + movableAtom.getRadius() >= TEST_CHAMBER_RECT.getMaxX()) {
                    double d6 = TEST_CHAMBER_RECT.getMaxX() - movableAtom.getPosition().getX();
                    mutableVector2D.add(new Vector2D(-d2 / (d6 * d6), 0.0));
                } else if (movableAtom.getPosition().getX() - movableAtom.getRadius() <= TEST_CHAMBER_RECT.getMinX()) {
                    double d7 = movableAtom.getPosition().getX() - TEST_CHAMBER_RECT.getMinX();
                    mutableVector2D.add(new Vector2D(d2 / (d7 * d7), 0.0));
                }
                if (movableAtom.getPosition().getY() + movableAtom.getRadius() >= TEST_CHAMBER_RECT.getMaxY()) {
                    double d8 = TEST_CHAMBER_RECT.getMaxY() - movableAtom.getPosition().getY();
                    mutableVector2D.add(new Vector2D(0.0, -d2 / (d8 * d8)));
                } else if (movableAtom.getPosition().getY() - movableAtom.getRadius() <= TEST_CHAMBER_RECT.getMinY()) {
                    double d9 = movableAtom.getPosition().getY() - TEST_CHAMBER_RECT.getMinY();
                    mutableVector2D.add(new Vector2D(0.0, d2 / (d9 * d9)));
                }
                hashMap.put(movableAtom, mutableVector2D);
            }
            for (MovableAtom movableAtom : hashMap.keySet()) {
                movableAtom.setPositionAndDestination(((MutableVector2D)hashMap.get(movableAtom)).getDestination(movableAtom.getPosition().toPoint2D()));
            }
            if (i != n - 1) continue;
            System.out.println(this.getClass().getName() + " - Warning: Hit max iterations of repositioning algorithm.");
        }
    }

    private boolean checkForParticleOverlap() {
        for (MovableAtom movableAtom : this.containedIsotopes) {
            for (MovableAtom movableAtom2 : this.containedIsotopes) {
                double d;
                if (movableAtom == movableAtom2 || !((d = movableAtom.getPosition().distance(movableAtom2.getPosition())) < movableAtom.getRadius() + movableAtom2.getRadius())) continue;
                return true;
            }
        }
        return false;
    }

    public Point2D generateRandomLocation() {
        return new Point2D.Double(TEST_CHAMBER_RECT.getMinX() + RAND.nextDouble() * TEST_CHAMBER_RECT.getWidth(), TEST_CHAMBER_RECT.getMinY() + RAND.nextDouble() * TEST_CHAMBER_RECT.getHeight());
    }

    public State getState() {
        return new State(this);
    }

    public void setState(State state) {
        this.removeAllIsotopes(true);
        this.bulkAddIsotopesToChamber(state.getContainedIsotopes());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class State {
        private final List<MovableAtom> containedIsotopes;

        public State(IsotopeTestChamber isotopeTestChamber) {
            this.containedIsotopes = new ArrayList<MovableAtom>(isotopeTestChamber.getContainedIsotopes());
        }

        protected List<MovableAtom> getContainedIsotopes() {
            return this.containedIsotopes;
        }
    }
}

