/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.modules.isotopemixture.view;

import edu.colorado.phet.buildanatom.model.AtomIdentifier;
import edu.colorado.phet.buildanatom.model.ImmutableAtom;
import edu.colorado.phet.buildanatom.modules.isotopemixture.model.MixIsotopesModel;
import edu.colorado.phet.buildanatom.modules.isotopemixture.view.VariablePrecisionNumberFormat;
import edu.colorado.phet.common.phetcommon.math.vector.AbstractVector2D;
import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.util.PrecisionDecimal;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.PieChartNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IsotopeProprotionsPieChart
extends PNode {
    private static final Stroke CONNECTING_LINE_STROKE = new BasicStroke(1.0f);

    public IsotopeProprotionsPieChart(final MixIsotopesModel mixIsotopesModel) {
        final PNode pNode = new PNode();
        this.addChild(pNode);
        final PieChartNode pieChartNode = new PieChartNode(new PieChartNode.PieValue[]{new PieChartNode.PieValue(100.0, Color.yellow)}, new Rectangle(-40, -40, 80, 80)){
            {
                this.setOffset(0.0, 0.0);
            }
        };
        this.addChild(pieChartNode);
        final PhetPPath phetPPath = new PhetPPath(new Ellipse2D.Double(-40.0, -40.0, 80.0, 80.0), (Stroke)new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{5.0f, 4.0f}, 0.0f), (Paint)Color.black){
            {
                this.setOffset(0.0, 0.0);
            }
        };
        this.addChild(phetPPath);
        mixIsotopesModel.getIsotopeTestChamber().addTotalCountChangeObserver(new SimpleObserver(){

            public void update() {
                boolean bl = mixIsotopesModel.getIsotopeTestChamber().getTotalIsotopeCount() > 0;
                pieChartNode.setVisible(bl);
                pNode.setVisible(bl);
                phetPPath.setVisible(!bl);
                if (bl) {
                    double d;
                    double d2;
                    Object object;
                    PNode pNode2;
                    Point2D point2D;
                    int n;
                    Object object2;
                    pNode.removeAllChildren();
                    ArrayList<IsotopePieValue> arrayList = new ArrayList<IsotopePieValue>();
                    for (ImmutableAtom immutableAtom : mixIsotopesModel.getPossibleIsotopesProperty().get()) {
                        object2 = (Boolean)mixIsotopesModel.getShowingNaturesMixProperty().get() != false ? AtomIdentifier.getNaturalAbundancePrecisionDecimal(immutableAtom) : new PrecisionDecimal(mixIsotopesModel.getIsotopeTestChamber().getIsotopeProportion(immutableAtom), 3);
                        if (!(((PrecisionDecimal)object2).getPreciseValue() > 0.0)) continue;
                        arrayList.add(new IsotopePieValue(immutableAtom, (PrecisionDecimal)object2, mixIsotopesModel.getColorForIsotope(immutableAtom)));
                    }
                    pieChartNode.setPieValues(arrayList.toArray(new PieChartNode.PieValue[arrayList.size()]));
                    if (arrayList.size() == 0) {
                        System.out.println("No pie slices, aborting update of chart.");
                        System.out.println("Prototype isotope = " + mixIsotopesModel.getAtom().toImmutableAtom());
                        System.out.println("Possible Isotopes: ");
                        for (ImmutableAtom immutableAtom : mixIsotopesModel.getPossibleIsotopesProperty().get()) {
                            System.out.println("   " + immutableAtom);
                        }
                        return;
                    }
                    double d3 = ((IsotopePieValue)arrayList.get(0)).getValue() / pieChartNode.getTotal();
                    pieChartNode.setInitialAngle(Math.PI - d3 * Math.PI);
                    object2 = new ArrayList();
                    for (n = 0; n < arrayList.size(); ++n) {
                        double d4;
                        point2D = pieChartNode.getCenterEdgePtForSlice(n);
                        boolean bl2 = point2D.getX() < 0.0;
                        pNode2 = new SliceLabel(((IsotopePieValue)arrayList.get(n)).getIsotopeConfig(), ((IsotopePieValue)arrayList.get(n)).getValue() / pieChartNode.getTotal() * 100.0, ((IsotopePieValue)arrayList.get(n)).getPrecisionDecimal().getNumberOfDecimalPlaces() - 2, bl2);
                        pNode.addChild(pNode2);
                        ((ArrayList)object2).add(pNode2);
                        object = new MutableVector2D(point2D);
                        ((MutableVector2D)object).scale(1.4);
                        ((SliceLabel)pNode2).setUnconstrainedPos(((MutableVector2D)object).getX(), ((MutableVector2D)object).getY());
                        d2 = -60.0 + pNode2.getFullBoundsReference().height / 2.0;
                        d = 60.0 - pNode2.getFullBoundsReference().height / 2.0;
                        double d5 = d4 = bl2 ? -1.0 : 1.0;
                        if (((MutableVector2D)object).getY() < d2) {
                            ((MutableVector2D)object).setX(d4 * Math.sqrt(((AbstractVector2D)object).magnitudeSquared() - d2 * d2));
                            ((MutableVector2D)object).setY(d2);
                        } else if (((MutableVector2D)object).getY() > d) {
                            ((MutableVector2D)object).setX(d4 * Math.sqrt(((AbstractVector2D)object).magnitudeSquared() - d * d));
                            ((MutableVector2D)object).setY(d);
                        }
                        if (bl2) {
                            pNode2.setOffset(((MutableVector2D)object).getX() - pNode2.getFullBoundsReference().width, ((MutableVector2D)object).getY() - pNode2.getFullBoundsReference().height / 2.0);
                            continue;
                        }
                        pNode2.setOffset(((MutableVector2D)object).getX(), ((MutableVector2D)object).getY() - pNode2.getFullBoundsReference().height / 2.0);
                    }
                    IsotopeProprotionsPieChart.this.adjustLabelPositionsForOverlap((ArrayList)object2, -60.0, 60.0);
                    for (n = 0; n < ((ArrayList)object2).size(); ++n) {
                        pNode2 = (PNode)((ArrayList)object2).get(n);
                        point2D = new Point2D.Double();
                        if (pNode2.getFullBoundsReference().getCenterX() > pieChartNode.getFullBoundsReference().getCenterX()) {
                            point2D.setLocation(pNode2.getFullBoundsReference().getMinX(), pNode2.getFullBoundsReference().getCenterY());
                        } else {
                            point2D.setLocation(pNode2.getFullBoundsReference().getMaxX(), pNode2.getFullBoundsReference().getCenterY());
                        }
                        Point2D point2D2 = pieChartNode.getCenterEdgePtForSlice(n);
                        assert (point2D2 != null);
                        object = new DoubleGeneralPath(point2D2);
                        if (point2D2.getY() > 30.0 || point2D2.getY() < -30.0) {
                            d2 = 0.5;
                            d = 1.0 - Math.min(Math.abs(point2D2.getX()) / 20.0, 1.0);
                            Point2D.Double double_ = new Point2D.Double(point2D2.getX() * (1.0 + d2 * d), point2D2.getY() * (1.0 + d2 * d));
                            ((DoubleGeneralPath)object).lineTo(double_);
                        }
                        ((DoubleGeneralPath)object).lineTo(point2D);
                        pNode.addChild(new PhetPPath(((DoubleGeneralPath)object).getGeneralPath(), CONNECTING_LINE_STROKE, (Paint)Color.BLACK));
                    }
                }
            }
        });
    }

    private void adjustLabelPositionsForOverlap(ArrayList<SliceLabel> arrayList, double d, double d2) {
        double d3 = 0.015707963267948967;
        for (int i = 1; i < 50; ++i) {
            boolean bl = false;
            for (SliceLabel sliceLabel : arrayList) {
                Object object;
                boolean bl2 = false;
                boolean bl3 = false;
                for (SliceLabel sliceLabel2 : arrayList) {
                    if (sliceLabel == sliceLabel2 || !sliceLabel.fullIntersects(sliceLabel2.getFullBoundsReference())) continue;
                    bl = true;
                    if (sliceLabel.getUnconstrainedPosRef().getY() > sliceLabel2.getUnconstrainedPosRef().getY() && sliceLabel.getFullBoundsReference().getMaxY() < d2) {
                        bl2 = true;
                        continue;
                    }
                    if (!(sliceLabel.getUnconstrainedPosRef().getY() < sliceLabel2.getUnconstrainedPosRef().getY()) || !(sliceLabel.getFullBoundsReference().getMinY() > d)) continue;
                    bl3 = true;
                }
                if (bl2 && !bl3) {
                    if (this.isLabelOnRight(sliceLabel)) {
                        object = new MutableVector2D(sliceLabel.getOffset().getX(), sliceLabel.getOffset().getY() + sliceLabel.getFullBoundsReference().height / 2.0);
                        ((MutableVector2D)object).rotate(d3);
                        sliceLabel.setOffset(((MutableVector2D)object).getX(), ((MutableVector2D)object).getY() - sliceLabel.getFullBoundsReference().height / 2.0);
                        continue;
                    }
                    object = new MutableVector2D(sliceLabel.getFullBoundsReference().getMaxX(), sliceLabel.getOffset().getY() + sliceLabel.getFullBoundsReference().height / 2.0);
                    ((MutableVector2D)object).rotate(-d3);
                    sliceLabel.setOffset(((MutableVector2D)object).getX() - sliceLabel.getFullBoundsReference().width, ((MutableVector2D)object).getY() - sliceLabel.getFullBoundsReference().height / 2.0);
                    continue;
                }
                if (!bl3 || bl2) continue;
                if (this.isLabelOnRight(sliceLabel)) {
                    object = new MutableVector2D(sliceLabel.getOffset().getX(), sliceLabel.getOffset().getY() + sliceLabel.getFullBoundsReference().height / 2.0);
                    ((MutableVector2D)object).rotate(-d3);
                    sliceLabel.setOffset(((MutableVector2D)object).getX(), ((MutableVector2D)object).getY() - sliceLabel.getFullBoundsReference().height / 2.0);
                    continue;
                }
                object = new MutableVector2D(sliceLabel.getFullBoundsReference().getMaxX(), sliceLabel.getOffset().getY() + sliceLabel.getFullBoundsReference().height / 2.0);
                ((MutableVector2D)object).rotate(d3);
                sliceLabel.setOffset(((MutableVector2D)object).getX() - sliceLabel.getFullBoundsReference().width, ((MutableVector2D)object).getY() - sliceLabel.getFullBoundsReference().height / 2.0);
            }
            if (!bl) break;
        }
    }

    private boolean isLabelOnRight(SliceLabel sliceLabel) {
        return sliceLabel.getFullBoundsReference().getCenterX() > 0.0;
    }

    private static class ChemSymbolWithNumbers
    extends PNode {
        private static final Font CHEMICAL_SYMBOL_FONT = new PhetFont(16);
        private static final Font SUPERSCRIPT_SUBSCRIPT_FONT = new PhetFont(14);

        public ChemSymbolWithNumbers(ImmutableAtom immutableAtom) {
            final PText pText = new PText(Integer.toString(immutableAtom.getMassNumber())){
                {
                    this.setFont(SUPERSCRIPT_SUBSCRIPT_FONT);
                    this.setOffset(0.0, 0.0);
                }
            };
            this.addChild(pText);
            final PText pText2 = new PText(immutableAtom.getSymbol()){
                {
                    super(string);
                    this.setFont(CHEMICAL_SYMBOL_FONT);
                    this.setOffset(pText.getFullBoundsReference().getMaxX() + 2.0, pText.getFullBoundsReference().height * 0.4);
                }
            };
            this.addChild(pText2);
            PText pText3 = new PText(Integer.toString(immutableAtom.getNumProtons())){
                {
                    super(string);
                    this.setFont(SUPERSCRIPT_SUBSCRIPT_FONT);
                    this.setOffset(pText2.getFullBoundsReference().getMinX() - 2.0 - this.getFullBoundsReference().width, pText2.getFullBoundsReference().getMaxY() - this.getFullBoundsReference().height * 0.6);
                }
            };
            this.addChild(pText3);
        }
    }

    protected static class IsotopePieValue
    extends PieChartNode.PieValue {
        private final PrecisionDecimal precisionDecimal;
        private final ImmutableAtom isotopeConfig;

        protected IsotopePieValue(ImmutableAtom immutableAtom, PrecisionDecimal precisionDecimal, Color color) {
            super(precisionDecimal.getPreciseValue(), color);
            this.isotopeConfig = immutableAtom;
            this.precisionDecimal = precisionDecimal;
        }

        protected PrecisionDecimal getPrecisionDecimal() {
            return this.precisionDecimal;
        }

        protected ImmutableAtom getIsotopeConfig() {
            return this.isotopeConfig;
        }
    }

    private static class SliceLabel
    extends PNode {
        private static final Font READOUT_FONT = new PhetFont(18);
        private final Point2D unconstrainedPos = new Point2D.Double(0.0, 0.0);

        public SliceLabel(ImmutableAtom immutableAtom, double d, int n, boolean bl) {
            ChemSymbolWithNumbers chemSymbolWithNumbers = new ChemSymbolWithNumbers(immutableAtom);
            this.addChild(chemSymbolWithNumbers);
            final PText pText = new PText(VariablePrecisionNumberFormat.format(d, Math.min(4, n)) + " %"){
                {
                    this.setFont(READOUT_FONT);
                }
            };
            PhetPPath phetPPath = new PhetPPath(Color.WHITE, new BasicStroke(1.0f), Color.BLACK){
                {
                    super(paint, stroke, paint2);
                    RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(0.0, 0.0, pText.getFullBoundsReference().width * 1.2, pText.getFullBoundsReference().height * 1.1, 4.0, 4.0);
                    this.setPathTo(double_);
                    pText.centerFullBoundsOnPoint(this.getFullBoundsReference().getCenterX(), this.getFullBoundsReference().getCenterY());
                    this.addChild(pText);
                }
            };
            if (chemSymbolWithNumbers.getFullBoundsReference().height > phetPPath.getFullBoundsReference().height) {
                phetPPath.setOffset(phetPPath.getOffset().getX(), chemSymbolWithNumbers.getFullBoundsReference().getCenterY() - phetPPath.getFullBoundsReference().height / 2.0);
            } else {
                chemSymbolWithNumbers.setOffset(chemSymbolWithNumbers.getOffset().getX(), phetPPath.getFullBoundsReference().getCenterY() - chemSymbolWithNumbers.getFullBoundsReference().height / 2.0);
            }
            this.addChild(phetPPath);
            if (bl) {
                phetPPath.setOffset(chemSymbolWithNumbers.getFullBoundsReference().getMaxX() + 5.0, phetPPath.getOffset().getY());
            } else {
                chemSymbolWithNumbers.setOffset(phetPPath.getFullBoundsReference().getMaxX() + 5.0, chemSymbolWithNumbers.getOffset().getY());
            }
        }

        protected void setUnconstrainedPos(double d, double d2) {
            this.unconstrainedPos.setLocation(d, d2);
        }

        protected Point2D getUnconstrainedPosRef() {
            return this.unconstrainedPos;
        }
    }
}

