/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.modules.isotopemixture.view;

import edu.colorado.phet.buildanatom.modules.isotopemixture.model.MovableAtom;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.graphics.RoundGradientPaint;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.common.piccolophet.nodes.SphericalNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.geom.Point2D;

public class LabeledIsotopeNode
extends PNode {
    private final SphericalNode sphericalNode;

    public LabeledIsotopeNode(final ModelViewTransform modelViewTransform, final MovableAtom movableAtom, final Color color) {
        double d = movableAtom.getRadius();
        double d2 = modelViewTransform.modelToViewDeltaX(d);
        RoundGradientPaint roundGradientPaint = new RoundGradientPaint(d2 / 2.0, -d2 / 2.0, ColorUtils.brighterColor(color, 0.8), new Point2D.Double(d2 / 2.0, d2 / 2.0), ColorUtils.darkerColor(color, 0.2));
        this.sphericalNode = new SphericalNode(modelViewTransform.modelToViewDeltaX(d * 2.0), roundGradientPaint, false);
        this.addChild(this.sphericalNode);
        if (d2 > 10.0) {
            HTMLNode hTMLNode = new HTMLNode(){
                {
                    this.setHTML("<sup>" + movableAtom.getAtomConfiguration().getMassNumber() + "</sup>" + movableAtom.getAtomConfiguration().getSymbol());
                    this.setFont(new PhetFont(12, true));
                    this.setScale(((LabeledIsotopeNode)LabeledIsotopeNode.this).sphericalNode.getFullBoundsReference().width * 0.65 / this.getFullBoundsReference().width);
                    if (0.3 * (double)color.getRed() + 0.59 * (double)color.getGreen() + 0.11 * (double)color.getBlue() < 125.0) {
                        this.setHTMLColor(Color.WHITE);
                    }
                    this.setOffset(-this.getFullBoundsReference().width / 2.0, -this.getFullBoundsReference().height / 2.0);
                }
            };
            this.sphericalNode.addChild(hTMLNode);
        }
        movableAtom.addPositionListener(new SimpleObserver(){

            public void update() {
                LabeledIsotopeNode.this.sphericalNode.setOffset(modelViewTransform.modelToView(movableAtom.getPosition().toPoint2D()));
            }
        });
        this.addInputEventListener(new CursorHandler());
        this.addInputEventListener(new PDragEventHandler(){

            protected void startDrag(PInputEvent pInputEvent) {
                super.startDrag(pInputEvent);
                movableAtom.setUserControlled(true);
            }

            public void mouseDragged(PInputEvent pInputEvent) {
                PDimension pDimension = pInputEvent.getDeltaRelativeTo(LabeledIsotopeNode.this.getParent());
                Vector2D vector2D = modelViewTransform.viewToModelDelta(new Vector2D(pDimension.width, pDimension.height));
                movableAtom.setPositionAndDestination(movableAtom.getPosition().getX() + vector2D.getX(), movableAtom.getPosition().getY() + vector2D.getY());
            }

            protected void endDrag(PInputEvent pInputEvent) {
                super.endDrag(pInputEvent);
                movableAtom.setUserControlled(false);
            }
        });
    }
}

