/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildanatom.modules.isotopemixture.view;

import edu.colorado.phet.buildanatom.BuildAnAtomConstants;
import edu.colorado.phet.buildanatom.BuildAnAtomDefaults;
import edu.colorado.phet.buildanatom.BuildAnAtomStrings;
import edu.colorado.phet.buildanatom.IsotopesAndAtomicMassApplication;
import edu.colorado.phet.buildanatom.model.MonoIsotopeParticleBucket;
import edu.colorado.phet.buildanatom.model.SphericalParticle;
import edu.colorado.phet.buildanatom.modules.interactiveisotope.view.IsotopeSliderNode;
import edu.colorado.phet.buildanatom.modules.isotopemixture.model.MixIsotopesModel;
import edu.colorado.phet.buildanatom.modules.isotopemixture.model.MovableAtom;
import edu.colorado.phet.buildanatom.modules.isotopemixture.model.NumericalIsotopeQuantityControl;
import edu.colorado.phet.buildanatom.modules.isotopemixture.view.AverageAtomicMassIndicator;
import edu.colorado.phet.buildanatom.modules.isotopemixture.view.IsotopeProprotionsPieChart;
import edu.colorado.phet.buildanatom.modules.isotopemixture.view.LabeledIsotopeNode;
import edu.colorado.phet.buildanatom.view.MaximizeControlNode;
import edu.colorado.phet.buildanatom.view.PeriodicTableControlNode;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.property.SettableProperty;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.controls.PropertyRadioButton;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.BucketView;
import edu.colorado.phet.common.piccolophet.nodes.HTMLImageButtonNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.ResetAllButtonNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;

public class MixIsotopesCanvas
extends PhetPCanvas
implements Resettable {
    public static final Color BACKGROUND_COLOR = BuildAnAtomConstants.CANVAS_BACKGROUND;
    public static final PhetFont BUTTON_FONT = new PhetFont(1, 18);
    private final MixIsotopesModel model;
    private final PNode rootNode;
    private final ModelViewTransform mvt;
    private final MaximizeControlNode pieChartWindow;
    private final MaximizeControlNode averageAtomicMassWindow;
    private final Map<MonoIsotopeParticleBucket, BucketView> mapBucketToView = new HashMap<MonoIsotopeParticleBucket, BucketView>();

    public MixIsotopesCanvas(final MixIsotopesModel mixIsotopesModel) {
        this.model = mixIsotopesModel;
        this.setWorldTransformStrategy(new PhetPCanvas.CenteredStage(this, BuildAnAtomDefaults.STAGE_SIZE));
        this.mvt = ModelViewTransform.createSinglePointScaleInvertedYMapping(new Point2D.Double(0.0, 0.0), new Point((int)Math.round(BuildAnAtomDefaults.STAGE_SIZE.width * 0.295), (int)Math.round(BuildAnAtomDefaults.STAGE_SIZE.height * 0.38)), 0.16);
        this.setBackground(BACKGROUND_COLOR);
        this.rootNode = new PNode();
        this.addWorldChild(this.rootNode);
        final PNode pNode = new PNode();
        this.rootNode.addChild(pNode);
        final PNode pNode2 = new PNode();
        this.rootNode.addChild(pNode2);
        PNode pNode3 = new PNode();
        this.rootNode.addChild(pNode3);
        final PNode pNode4 = new PNode();
        this.rootNode.addChild(pNode4);
        final PNode pNode5 = new PNode();
        this.rootNode.addChild(pNode5);
        mixIsotopesModel.addListener(new MixIsotopesModel.Adapter(){

            public void isotopeInstanceAdded(MovableAtom movableAtom) {
                final LabeledIsotopeNode labeledIsotopeNode = new LabeledIsotopeNode(MixIsotopesCanvas.this.mvt, movableAtom, mixIsotopesModel.getColorForIsotope(movableAtom.getAtomConfiguration()));
                pNode4.addChild(labeledIsotopeNode);
                movableAtom.addListener(new SphericalParticle.Adapter(){

                    public void removedFromModel(SphericalParticle sphericalParticle) {
                        pNode4.removeChild(labeledIsotopeNode);
                    }
                });
                boolean bl = mixIsotopesModel.getInteractivityModeProperty().get() == MixIsotopesModel.InteractivityMode.BUCKETS_AND_LARGE_ATOMS && (Boolean)mixIsotopesModel.getShowingNaturesMixProperty().get() == false;
                labeledIsotopeNode.setPickable(bl);
                labeledIsotopeNode.setChildrenPickable(bl);
            }

            public void isotopeBucketAdded(MonoIsotopeParticleBucket monoIsotopeParticleBucket) {
                BucketView bucketView = new BucketView(monoIsotopeParticleBucket, MixIsotopesCanvas.this.mvt);
                pNode2.addChild(bucketView.getHoleNode());
                pNode5.addChild(bucketView.getFrontNode());
                MixIsotopesCanvas.this.mapBucketToView.put(monoIsotopeParticleBucket, bucketView);
            }

            public void isotopeBucketRemoved(MonoIsotopeParticleBucket monoIsotopeParticleBucket) {
                if (MixIsotopesCanvas.this.mapBucketToView.containsKey(monoIsotopeParticleBucket)) {
                    pNode5.removeChild(((BucketView)MixIsotopesCanvas.this.mapBucketToView.get(monoIsotopeParticleBucket)).getFrontNode());
                    pNode2.removeChild(((BucketView)MixIsotopesCanvas.this.mapBucketToView.get(monoIsotopeParticleBucket)).getHoleNode());
                    MixIsotopesCanvas.this.mapBucketToView.remove(monoIsotopeParticleBucket);
                } else {
                    System.out.println(this.getClass().getName() + "Warning: Attempt to remove bucket with no view component.");
                }
            }

            public void isotopeNumericalControllerAdded(final NumericalIsotopeQuantityControl numericalIsotopeQuantityControl) {
                final IsotopeSliderNode isotopeSliderNode = new IsotopeSliderNode(numericalIsotopeQuantityControl, MixIsotopesCanvas.this.mvt);
                pNode.addChild(isotopeSliderNode);
                numericalIsotopeQuantityControl.getPartOfModelProperty().addObserver(new SimpleObserver(){

                    public void update() {
                        if (!((Boolean)numericalIsotopeQuantityControl.getPartOfModelProperty().get()).booleanValue()) {
                            pNode.removeChild(isotopeSliderNode);
                        }
                    }
                }, false);
            }
        });
        final PhetPPath phetPPath = new PhetPPath(new BasicStroke(1.0f), Color.BLACK){
            {
                super(stroke, paint);
                this.setPathTo(MixIsotopesCanvas.this.mvt.modelToView(mixIsotopesModel.getIsotopeTestChamber().getTestChamberRect()));
            }
        };
        pNode3.addChild(phetPPath);
        IsotopesAndAtomicMassApplication.whiteIsotopeBoxProperty.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                if (bl.booleanValue()) {
                    phetPPath.setPaint(Color.WHITE);
                } else {
                    phetPPath.setPaint(Color.BLACK);
                }
            }
        });
        final PeriodicTableControlNode periodicTableControlNode = new PeriodicTableControlNode(mixIsotopesModel, 18, BACKGROUND_COLOR){
            {
                super(iConfigurableAtomModel, n, color);
                this.setOffset(phetPPath.getFullBoundsReference().getMaxX() + 15.0, phetPPath.getFullBoundsReference().getMinY());
                this.setScale(1.1);
            }
        };
        pNode.addChild(periodicTableControlNode);
        final double d = periodicTableControlNode.getFullBoundsReference().getX();
        final IsotopeProprotionsPieChart isotopeProprotionsPieChart = new IsotopeProprotionsPieChart(mixIsotopesModel);
        isotopeProprotionsPieChart.setOffset(200.0, 90.0);
        this.pieChartWindow = new MaximizeControlNode(BuildAnAtomStrings.PERCENT_COMPOSITION, new PDimension(400.0, 155.0), (PNode)isotopeProprotionsPieChart, true){
            {
                super(string, pDimension, pNode, bl);
                this.setOffset(d, periodicTableControlNode.getFullBoundsReference().getMaxY() + 25.0);
                this.addChild(isotopeProprotionsPieChart);
            }
        };
        pNode.addChild(this.pieChartWindow);
        final AverageAtomicMassIndicator averageAtomicMassIndicator = new AverageAtomicMassIndicator(mixIsotopesModel);
        this.averageAtomicMassWindow = new MaximizeControlNode(BuildAnAtomStrings.AVERAGE_ATOMIC_MASS, new PDimension(400.0, 120.0), (PNode)averageAtomicMassIndicator, true){
            {
                super(string, pDimension, pNode, bl);
                this.setOffset(d, phetPPath.getFullBoundsReference().getMaxY() - this.getFullBoundsReference().height);
                this.addChild(averageAtomicMassIndicator);
            }
        };
        pNode.addChild(this.averageAtomicMassWindow);
        averageAtomicMassIndicator.setOffset(this.averageAtomicMassWindow.getFullBoundsReference().width / 2.0 - averageAtomicMassIndicator.getFullBoundsReference().width / 2.0, 30.0);
        final PropertyRadioButton<Boolean> propertyRadioButton = new PropertyRadioButton<Boolean>(BuildAnAtomStrings.MY_MIX_OF_ISOTOPES, (SettableProperty)mixIsotopesModel.getShowingNaturesMixProperty(), Boolean.valueOf(false)){
            {
                this.setFont(new PhetFont(20));
            }
        };
        final PropertyRadioButton<Boolean> propertyRadioButton2 = new PropertyRadioButton<Boolean>(BuildAnAtomStrings.NATURES_MIX_OF_ISOTOPES, (SettableProperty)mixIsotopesModel.getShowingNaturesMixProperty(), Boolean.valueOf(true)){
            {
                this.setFont(new PhetFont(20));
            }
        };
        VerticalLayoutPanel verticalLayoutPanel = new VerticalLayoutPanel(){
            {
                this.add(propertyRadioButton);
                this.add(propertyRadioButton2);
                SwingUtils.setBackgroundDeep(this, BACKGROUND_COLOR);
            }
        };
        pNode.addChild(new PSwing(verticalLayoutPanel){
            {
                super(jComponent);
                this.setOffset(phetPPath.getFullBoundsReference().getMaxX() + 140.0, MixIsotopesCanvas.this.averageAtomicMassWindow.getFullBoundsReference().getMaxY() + 20.0);
            }
        });
        final Point2D.Double double_ = new Point2D.Double(phetPPath.getFullBoundsReference().getCenterX(), BuildAnAtomDefaults.STAGE_SIZE.height - 30.0);
        final HTMLImageButtonNode hTMLImageButtonNode = new HTMLImageButtonNode(BuildAnAtomStrings.MORE, BUTTON_FONT, new Color(0, 198, 158)){
            {
                super(string, phetFont, color);
                this.centerFullBoundsOnPoint(double_.getX(), double_.getY());
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        mixIsotopesModel.getInteractivityModeProperty().set(MixIsotopesModel.InteractivityMode.SLIDERS_AND_SMALL_ATOMS);
                    }
                });
            }
        };
        pNode.addChild(hTMLImageButtonNode);
        final HTMLImageButtonNode hTMLImageButtonNode2 = new HTMLImageButtonNode(BuildAnAtomStrings.LESS, BUTTON_FONT, new Color(159, 182, 205)){
            {
                super(string, phetFont, color);
                this.centerFullBoundsOnPoint(double_.getX(), double_.getY());
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        mixIsotopesModel.getInteractivityModeProperty().set(MixIsotopesModel.InteractivityMode.BUCKETS_AND_LARGE_ATOMS);
                    }
                });
            }
        };
        pNode.addChild(hTMLImageButtonNode2);
        SimpleObserver simpleObserver = new SimpleObserver(){

            public void update() {
                hTMLImageButtonNode.setVisible(mixIsotopesModel.getInteractivityModeProperty().get() == MixIsotopesModel.InteractivityMode.BUCKETS_AND_LARGE_ATOMS && (Boolean)mixIsotopesModel.getShowingNaturesMixProperty().get() == false);
                hTMLImageButtonNode2.setVisible(mixIsotopesModel.getInteractivityModeProperty().get() == MixIsotopesModel.InteractivityMode.SLIDERS_AND_SMALL_ATOMS && (Boolean)mixIsotopesModel.getShowingNaturesMixProperty().get() == false);
            }
        };
        mixIsotopesModel.getInteractivityModeProperty().addObserver(simpleObserver);
        mixIsotopesModel.getShowingNaturesMixProperty().addObserver(simpleObserver);
        final HTMLImageButtonNode hTMLImageButtonNode3 = new HTMLImageButtonNode(BuildAnAtomStrings.CLEAR_BOX, BUTTON_FONT, new Color(255, 153, 0)){
            {
                super(string, phetFont, color);
                this.centerFullBoundsOnPoint(MixIsotopesCanvas.this.averageAtomicMassWindow.getFullBoundsReference().getMinX() + 80.0, BuildAnAtomDefaults.STAGE_SIZE.height - 30.0);
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        mixIsotopesModel.clearTestChamber();
                    }
                });
            }
        };
        pNode.addChild(hTMLImageButtonNode3);
        SimpleObserver simpleObserver2 = new SimpleObserver(){

            public void update() {
                hTMLImageButtonNode3.setVisible(mixIsotopesModel.getIsotopeTestChamber().getTotalIsotopeCount() > 0 && (Boolean)mixIsotopesModel.getShowingNaturesMixProperty().get() == false);
            }
        };
        mixIsotopesModel.getShowingNaturesMixProperty().addObserver(simpleObserver2);
        mixIsotopesModel.getIsotopeTestChamber().addTotalCountChangeObserver(simpleObserver2);
        ResetAllButtonNode resetAllButtonNode = new ResetAllButtonNode(this, this, BUTTON_FONT.getSize(), Color.BLACK, new Color(255, 153, 0)){
            {
                this.setConfirmationEnabled(false);
                this.centerFullBoundsOnPoint(MixIsotopesCanvas.this.averageAtomicMassWindow.getFullBoundsReference().getMaxX() - 80.0, BuildAnAtomDefaults.STAGE_SIZE.height - 30.0);
            }
        };
        pNode.addChild(resetAllButtonNode);
    }

    public void reset() {
        this.model.reset();
        this.pieChartWindow.setMaximized(true);
        this.averageAtomicMassWindow.setMaximized(true);
    }
}

